<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
 
/******************************************Core Function******************************************/
//Get option
if(!function_exists('sv_get_option')){
	function sv_get_option($key,$default=NULL)
    {
        if(function_exists('ot_get_option'))
        {
            return ot_get_option($key,$default);
        }

        return $default;
    }
}

//Autoload folder
if(!function_exists('sv_load_files')){
    function sv_load_files($folder)
    {
        //Auto load widget
        $files=glob(get_template_directory()."/"."7upframe/".$folder."/*.php");

        // Auto load all file
        if(!empty($files)){
            foreach ($files as $filename)
            {
                load_template($filename);
            }
        }

    }
}

//Add header style
if (!function_exists('sv_add_head_style')) {
    function sv_add_head_style($style) {
        $content ='<script type="text/javascript">
                    (function($) {
                        "use strict";
                        $("head").append('."'".'<style id="sv_add_footer_css">'.$style.'</style>'."'".');
                    })(jQuery);
                    </script>';
        return $content;
    }
}

//Get list header page
if(!function_exists('sv_list_header_page'))
{
    function sv_list_header_page()
    {
        global $post;
        $page_list = array();
        $page_list[] = array(
            'value' => '',
            'label' => esc_html__('-- Choose One --','megastore')
        );
        $pages = get_pages();
        foreach ($pages as $page) {
            if (strpos($page->post_content, '[sv_logo') ||  strpos($page->post_content, '[sv_menu')) {
                $page_list[] = array(
                    'value' => $page->ID,
                    'label' => $page->post_title
                );
            }
        }        
        return $page_list;
    }
}

//Get list sidebar
if(!function_exists('sv_get_sidebar_ids'))
{
    function sv_get_sidebar_ids($for_optiontree=false)
    {
        global $wp_registered_sidebars;
        $r=array();
        $r[]=esc_html__('--Select--','megastore');
        if(!empty($wp_registered_sidebars)){
            foreach($wp_registered_sidebars as $key=>$value)
            {

                if($for_optiontree){
                    $r[]=array(
                        'value'=>$value['id'],
                        'label'=>$value['name']
                    );
                }else{
                    $r[$value['id']]=$value['name'];
                }
            }
        }
        return $r;
    }
}

//Get order list
if(!function_exists('sv_get_order_list'))
{
    function sv_get_order_list($current=false,$extra=array(),$return='array')
    {
        $default = array(
            esc_html__('None','megastore')               => 'none',
            esc_html__('Post ID','megastore')            => 'ID',
            esc_html__('Author','megastore')             => 'author',
            esc_html__('Post Title','megastore')         => 'title',
            esc_html__('Post Name','megastore')          => 'name',
            esc_html__('Post Date','megastore')          => 'date',
            esc_html__('Last Modified Date','megastore') => 'modified',
            esc_html__('Post Parent','megastore')        => 'parent',
            esc_html__('Random','megastore')             => 'rand',
            esc_html__('Comment Count','megastore')      => 'comment_count',
            esc_html__('View Post','megastore')          => 'post_views',
            esc_html__('Like Post','megastore')          => '_post_like_count',
            esc_html__('Custom Modified Date','megastore')=> 'time_update',            
        );

        if(!empty($extra) and is_array($extra))
        {
            $default=array_merge($default,$extra);
        }

        if($return=="array")
        {
            return $default;
        }elseif($return=='option')
        {
            $html='';
            if(!empty($default)){
                foreach($default as $key=>$value){
                    $selected=selected($key,$current,false);
                    $html.="<option {$selected} value='{$key}'>{$value}</option>";
                }
            }
            return $html;
        }
    }
}

// Get sidebar
if(!function_exists('sv_get_sidebar'))
{
    function sv_get_sidebar()
    {
        $default=array(
            'position'=>'right',
            'id'      =>'blog-sidebar'
        );

        return apply_filters('sv_get_sidebar',$default);
    }
}

//Favicon
if(!function_exists('sv_load_favicon') )
{
    function sv_load_favicon()
    {
        $value = sv_get_option('favicon');
        $favicon = (isset($value) && !empty($value))?$value:false;
        if($favicon)
            echo '<link rel="Shortcut Icon" href="' . esc_url( $favicon ) . '" type="image/x-icon" />' . "\n";
    }
}
if(!function_exists( 'wp_site_icon' ) ){
    add_action( 'wp_head','sv_load_favicon');
    add_action('login_head', 'sv_load_favicon');
    add_action('admin_head', 'sv_load_favicon');
}

//Fill css background
if(!function_exists('sv_fill_css_background'))
{
    function sv_fill_css_background($data)
    {
        $string = '';
        if(!empty($data['background-color'])) $string .= 'background-color:'.$data['background-color'].';'."\n";
        if(!empty($data['background-repeat'])) $string .= 'background-repeat:'.$data['background-repeat'].';'."\n";
        if(!empty($data['background-attachment'])) $string .= 'background-attachment:'.$data['background-attachment'].';'."\n";
        if(!empty($data['background-position'])) $string .= 'background-position:'.$data['background-position'].';'."\n";
        if(!empty($data['background-size'])) $string .= 'background-size:'.$data['background-size'].';'."\n";
        if(!empty($data['background-image'])) $string .= 'background-image:url("'.$data['background-image'].'");'."\n";
        if(!empty($string)) return SV_Assets::build_css($string);
        else return false;
    }
}

// Get list menu
if(!function_exists('sv_list_menu_name'))
{
    function sv_list_menu_name()
    {
        $menu_nav = wp_get_nav_menus();
        $menu_list = array('Default' => '');
        if(is_array($menu_nav) && !empty($menu_nav))
        {
            foreach($menu_nav as $item)
            { 
                if(is_object($item))
                {
                    $menu_list[$item->name] = $item->slug;
                }
            }
        }
        return $menu_list;
    }
}

//Display BreadCrumb
if(!function_exists('sv_display_breadcrumb'))
{
    function sv_display_breadcrumb()
    {
        $breadcrumb = sv_get_value_by_id('sv_show_breadrumb','on');
        if($breadcrumb == 'on' && (!is_home() && !is_front_page())){ 
            $b_class = sv_fill_css_background(sv_get_option('sv_bg_breadcrumb'));
            ?>
            <div class="tp-breadcrumb">
                <div class="container">
                    <div class="block block-breadcrumbs clearfix <?php echo esc_attr($b_class)?>">
                        <ul>
                            <?php
                                if(function_exists('bcn_display')) bcn_display();
                                else sv_breadcrumb();
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php }
    }
}

//Custom BreadCrumb
if(!function_exists('sv_breadcrumb'))
{
    function sv_breadcrumb() {
        global $post;
        if (!is_home() || (is_home() && !is_front_page())) {
            echo '<li><a href="';
            echo esc_url(home_url('/'));
            echo '">';
            echo '<i class="fa fa-home"></i>';
            echo '</a>'.' <span></span></li>';
            if(is_home() && !is_front_page()){
                echo '<li>'.esc_html__('Blog','megastore').'</li>'; 
            }
            if (is_category() || is_single()) {
                echo '<li>';
                the_category(' </li><span></span><li> ');
                echo '</li>';
                if (is_single()) {
                    echo ' <span></span><li> ';
                    the_title();
                    echo '</li>';
                }
            } elseif (is_page()) {
                if($post->post_parent){
                    $anc = get_post_ancestors( get_the_ID() );
                    $title = get_the_title();
                    foreach ( $anc as $ancestor ) {
                        $output = '<li><a href="'.esc_url(get_permalink($ancestor)).'" title="'.get_the_title($ancestor).'">'.get_the_title($ancestor).'</a> <span></span></li><li> ';
                    }
                    echo balanceTags($output);
                    echo '<li> '.esc_html($title).'</li>';
                } else {
                    echo '<li> '.get_the_title().'</li>';
                }
            }
            elseif (is_tag()) {echo "<li>".single_tag_title("", false)."</li>";}
            elseif (is_day()) {echo "<li>".esc_html__("Archive for ","megastore"); the_time(get_option( 'date_format' )); echo'</li>';}
            elseif (is_month()) {echo "<li>".esc_html__("Archive for ","megastore"); echo get_the_time('F, Y'); echo'</li>';}
            elseif (is_year()) {echo "<li>".esc_html__("Archive for ","megastore"); echo get_the_time('Y'); echo'</li>';}
            elseif (is_author()) {echo "<li>".esc_html__("Author Archive ","megastore"); echo'</li>';}
            elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>".esc_html__("Blog Archives","megastore"); echo'</li>';}
            elseif (is_search()) {echo "<li>".esc_html__("Search Results","megastore"); echo'</li>';}
        }
        elseif (is_tag()) {echo "<li>".single_tag_title("", false)."</li>";}
        elseif (is_day()) {echo "<li>".esc_html__("Archive for ","megastore"); the_time(get_option( 'date_format' )); echo'</li>';}
        elseif (is_month()) {echo "<li>".esc_html__("Archive for ","megastore"); echo get_the_time('F, Y'); echo'</li>';}
        elseif (is_year()) {echo "<li>".esc_html__("Archive for ","megastore"); echo get_the_time('Y'); echo'</li>';}
        elseif (is_author()) {echo "<li>".esc_html__("Author Archive ","megastore"); echo'</li>';}
        elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>".esc_html__("Blog Archives","megastore"); echo'</li>';}
        elseif (is_search()) {echo "<li>".esc_html__("Search Results","megastore"); echo'</li>';}
    }
}

//Get page value by ID
if(!function_exists('sv_get_value_by_id'))
{   
    function sv_get_value_by_id($key)
    {
        if(!empty($key)){
            $id = get_the_ID();
            if(is_front_page() && is_home()) $id = (int)get_option( 'page_on_front' );
            if(!is_front_page() && is_home()) $id = (int)get_option( 'page_for_posts' );
            if(is_archive() || is_search()) $id = 0;
            if (class_exists('woocommerce')) {
                if(is_shop()) $id = (int)get_option('woocommerce_shop_page_id');
                if(is_cart()) $id = (int)get_option('woocommerce_cart_page_id');
                if(is_checkout()) $id = (int)get_option('woocommerce_checkout_page_id');
                if(is_account_page()) $id = (int)get_option('woocommerce_myaccount_page_id');
            }
            $value = get_post_meta($id,$key,true);
            if(empty($value)) $value = sv_get_option($key);
            return $value;
        }
        else return esc_html__('Missing a variable of this funtion','megastore');
    }
}

//Check woocommerce page
if (!function_exists('sv_is_woocommerce_page')) {
    function sv_is_woocommerce_page() {
        if(  function_exists ( "is_woocommerce" ) && is_woocommerce()){
                return true;
        }
        $woocommerce_keys   =   array ( "woocommerce_shop_page_id" ,
                                        "woocommerce_terms_page_id" ,
                                        "woocommerce_cart_page_id" ,
                                        "woocommerce_checkout_page_id" ,
                                        "woocommerce_pay_page_id" ,
                                        "woocommerce_thanks_page_id" ,
                                        "woocommerce_myaccount_page_id" ,
                                        "woocommerce_edit_address_page_id" ,
                                        "woocommerce_view_order_page_id" ,
                                        "woocommerce_change_password_page_id" ,
                                        "woocommerce_logout_page_id" ,
                                        "woocommerce_lost_password_page_id" ) ;
        foreach ( $woocommerce_keys as $wc_page_id ) {
                if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
                        return true ;
                }
        }
        return false;
    }
}

//navigation
if(!function_exists('sv_paging_nav'))
{
    function sv_paging_nav()
    {
        // Don't print empty markup if there's only one page.
        if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
            return;
        }

        $paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
        $pagenum_link = html_entity_decode( get_pagenum_link() );
        $query_args   = array();
        $url_parts    = explode( '?', $pagenum_link );

        if ( isset( $url_parts[1] ) ) {
            wp_parse_str( $url_parts[1], $query_args );
        }

        $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
        $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

        $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
        $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

        // Set up paginated links.
        $links = paginate_links( array(
            'base'     => $pagenum_link,
            'format'   => $format,
            'total'    => $GLOBALS['wp_query']->max_num_pages,
            'current'  => $paged,
            'mid_size' => 1,
            'type'     => 'list',
            'add_args' => array_map( 'urlencode', $query_args ),
            'prev_text' => '<span>'.esc_html__( '&laquo; Prev', 'megastore' ).'</span>',
            'next_text' => '<span>'.esc_html__( 'Next &raquo;', 'megastore' ).'</span>',
        ) );

        if ($links) : ?>
        <div class="sortPagiBar">
            <div class="sortPagiBar-inner">
                <nav>
                  <?php echo balanceTags($links); ?>
                </nav>
            </div>
        </div>
        <?php endif;
    }
}

//Set post view
if(!function_exists('sv_set_post_view'))
{
    function sv_set_post_view($post_id=false)
    {
        if(!$post_id) $post_id=get_the_ID();

        $view=(int)get_post_meta($post_id,'post_views',true);
        $view++;
        update_post_meta($post_id,'post_views',$view);
    }
}

if(!function_exists('sv_get_post_view'))
{
    function sv_get_post_view($post_id=false)
    {
        if(!$post_id) $post_id=get_the_ID();

        return (int)get_post_meta($post_id,'post_views',true);
    }
}

//remove attr embed
if(!function_exists('sv_remove_w3c')){
    function sv_remove_w3c($embed_code){
        $embed_code=str_replace('webkitallowfullscreen','',$embed_code);
        $embed_code=str_replace('mozallowfullscreen','',$embed_code);
        $embed_code=str_replace('frameborder="0"','',$embed_code);
        $embed_code=str_replace('frameborder="no"','',$embed_code);
        $embed_code=str_replace('scrolling="no"','',$embed_code);
        $embed_code=str_replace('&','&amp;',$embed_code);
        return $embed_code;
    }
}

// MetaBox
if(!function_exists('sv_display_metabox'))
{
    function sv_display_metabox($type ='') {
        switch ($type) {
            case 'blog':
                break;

            default:?>
                <div class="entry-meta-data">
                    <span class="author">
                    <i class="fa fa-user"></i> 
                    <?php esc_html_e('by', 'megastore');?>: <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo get_the_author(); ?></a></span>
                    <span class="cat">
                        <i class="fa fa-folder-o"></i>
                        <?php $cats = get_the_category_list(', ');?>
                        <?php if($cats) echo balanceTags($cats); else esc_html_e("No Category",'megastore');?>
                    </span>
                    <?php if(is_front_page() && is_home()):?>
                        <span class="cat">
                            <i class="fa fa-tags"></i>
                            <?php $tags = get_the_tag_list(' ',', ',' ');?>
                            <?php if($tags) echo balanceTags($tags); else esc_html_e("No Tag",'megastore');?>
                        </span>
                    <?php endif;?>
                    <span class="comment-count">
                        <i class="fa fa-comment-o"></i> <?php echo get_comments_number(); ?>
                    </span>
                    <span class="date"><i class="fa fa-calendar"></i> <?php echo get_the_time('Y-m-d h:i:s')?></span>
                </div>
                <?php
                break;
        }
    ?>        
    <?php
    }
}
if(!function_exists('sv_get_header_default')){
    function sv_get_header_default(){
        ?>
        <div id="header" class="header-default">
            <div class="container">
                <div class="row header">
                    <div class="main-header">
                        <div class="logo">
                            <a href="<?php echo esc_url(home_url('/'));?>" title="<?php echo esc_attr__("logo","megastore");?>">
                                <?php $sv_logo=sv_get_option('logo');?>
                                <?php if($sv_logo!=''){
                                    echo '<h1 class="hidden">'.get_bloginfo('name', 'display').'</h1><img src="' . esc_url($sv_logo) . '" alt="logo">';
                                }   else { echo '<h1>'.get_bloginfo('name', 'display').'</h1>'; }
                                ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="main-menu">
                <div class="container">
                    <div class="row">
                        <nav class="navbar" id="main-menu">
                            <div class="container-fluid">
                                <div class="navbar-header">
                                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                                        <i class="fa fa-bars"></i>
                                    </button>
                                    <a class="navbar-brand" href="#"><?php esc_html_e("MENU","megastore")?></a>
                                </div>
                                <div id="navbar" class="navbar-collapse collapse">
                                    <?php if ( has_nav_menu( 'primary' ) ) {
                                        wp_nav_menu( array(
                                                'theme_location' => 'primary',
                                                'container'=>false,
                                                'walker'=>new SV_Walker_Nav_Menu(),
                                                'menu_class'=>'nav navbar-nav',
                                             )
                                        );
                                    } ?>
                                </div>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
if(!function_exists('sv_get_footer_default')){
    function sv_get_footer_default(){
        ?>
        <div id="footer" class="default-footer">
            <div class="container">
                <div class="block-coppyright footer-bottom">
                    <?php esc_html_e("Copyright &copy; by 7up. All Rights Reserved. Designed by","megastore")?> <a href="#"><span><?php esc_html_e("7uptheme","megastore")?></span>.<?php esc_html_e("com","megastore")?></a>.
                </div>
            </div>
        </div>
        <?php
    }
}
if(!function_exists('sv_get_footer_visual')){
    function sv_get_footer_visual($page_id){
        ?>
        <div id="footer" class="footer-page">
            <div class="container">
                <?php echo SV_Template::get_vc_pagecontent($page_id);?>
            </div>
        </div>
        <?php
    }
}
if(!function_exists('sv_get_header_visual')){
    function sv_get_header_visual($page_id){
        ?>
        <div id="header" class="header-page">
            <div class="container">
                <?php echo SV_Template::get_vc_pagecontent($page_id);?>
            </div>
        </div>
        <?php
    }
}
if(!function_exists('sv_get_main_class')){
    function sv_get_main_class(){
        $sidebar=sv_get_sidebar();
        $sidebar_pos=$sidebar['position'];
        $main_class = 'col-md-12 col-sm-12 col-xs-12';
        if($sidebar_pos != 'no') $main_class = 'col-md-9 col-sm-8 col-xs-12';
        return $main_class;
    }
}
if(!function_exists('sv_output_sidebar')){
    function sv_output_sidebar($position){
        $sidebar = sv_get_sidebar();
        $sidebar_pos = $sidebar['position'];
        if($sidebar_pos == $position) get_sidebar();
    }
}
if(!function_exists('sv_fix_import_category')){
    function sv_fix_import_category($taxonomy){
        global $sv_config;
        $data = $sv_config['import_category'];
        $data = json_decode($data,true);
        foreach ($data as $cat => $value) {
            $parent_id = 0;
            $term = get_term_by( 'slug',$cat, $taxonomy );
            $term_parent = get_term_by( 'slug', $value['parent'], $taxonomy );
            if(isset($term_parent->term_id)) $parent_id = $term_parent->term_id;
            if($parent_id) wp_update_term( $term->term_id, $taxonomy, array('parent'=> $parent_id) );
            if($value['thumbnail']){
                if($taxonomy == 'product_cat')  update_metadata( 'woocommerce_term', $term->term_id, 'thumbnail_id', $value['thumbnail']);
                else{
                    update_term_meta( $term->term_id, 'thumbnail_id', $value['thumbnail']);
                }
            }
        }
    }
}
/***************************************END Core Function***************************************/


/***************************************Add Theme Function***************************************/
// get list taxonomy
if(!function_exists('sv_list_taxonomy'))
{
    function sv_list_taxonomy($taxonomy,$show_all = true)
    {
        if($show_all) $list = array('--Select--' => '');
        else $list = array();
        if(!isset($taxonomy) || empty($taxonomy)) $taxonomy = 'category';
        $tags = get_terms($taxonomy);
        if(is_array($tags) && !empty($tags)){
            foreach ($tags as $tag) {
                $list[$tag->name] = $tag->slug;
            }
        }
        return $list;
    }
}
//Compare URL
if(!function_exists('sv_compare_url')){
    function sv_compare_url($ajax = false,$cp_class = "btn-add-comparre",$pre_tag = '',$end_tag = ''){
        if(class_exists('YITH_Woocompare')){  
            $id = get_the_ID();
            $cp_link = str_replace('&', '&amp;',add_query_arg( array('action' => 'yith-woocompare-add-product','id' => $id )));          
            $html = '<a href="'.esc_url($cp_link).'" class="product-compare compare '.$cp_class.'" data-product_id="'.get_the_ID().'">'.$pre_tag.esc_html__("Compare","megastore").$end_tag.'</a>';
            return $html;
        }
    }
}
if(!function_exists('sv_product_thumb_hover')){
    function sv_product_thumb_hover($size = 'full',$class = 'product-thumb'){
        $html = '<div class="'.esc_attr($class).'">
                    <a class="product-img" href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail(get_the_ID(),$size).'</a>
                    <a title="'.esc_html__("Quick View","megastore").'" data-product-id="'.get_the_id().'" href="'.esc_url(get_the_permalink()).'" class="product-quick-view btn-quick-view">'.esc_html__("Quick View","megastore").'</a>
                </div>';
        return $html;
    }
}
if(!function_exists('sv_product_thumb_hover2')){
    function sv_product_thumb_hover2($size = 'full',$class = 'product-thumb'){
        $html = '<div class="'.esc_attr($class).'">
                    <a class="product-thumb-link" href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail(get_the_ID(),$size).'</a>
                    <a title="'.esc_html__("Quick View","megastore").'" data-product-id="'.get_the_id().'" href="'.esc_url(get_the_permalink()).'" class="product-quick-view quickview-link"><i class="fa fa-search" aria-hidden="true"></i></a>
                </div>';
        return $html;
    }
}
if(!function_exists('sv_product_thumb_hover3')){
    function sv_product_thumb_hover3($size = 'full',$class = 'product-thumb'){
        $html = '<div class="'.esc_attr($class).'">
                    <a class="product-thumb-link" href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail(get_the_ID(),$size).'</a>
                    <a title="'.esc_html__("Quick View","megastore").'" data-product-id="'.get_the_id().'" href="'.esc_url(get_the_permalink()).'" class="product-quick-view quickview-link"><i class="fa fa-eye" aria-hidden="true"></i></a>
                </div>';
        return $html;
    }
}
if(!function_exists('sv_product_link')){
    function sv_product_link($style = ''){
        global $product;
        switch ($style) {
            case 'style4':
                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s"><span>%s</span></a>',
                        esc_url( $product->add_to_cart_url() ),
                        esc_attr( $product->get_id() ),
                        esc_attr( $product->get_sku() ),
                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button addcart-link' : '',
                        esc_attr( $product->get_type() ),
                        esc_html( $product->add_to_cart_text() )
                    ),
                $product );        
                $html_wl = '';
                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.esc_url(str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() ))).'" class="add_to_wishlist wishlist-link" rel="nofollow" data-product-id="'.get_the_ID().'"><span>'.esc_html__("Add Wishlist","megastore").'</span></a>';
                $html =    '<div class="product-extra-link product">
                                '.$html_wl.'
                                '.$button_html.'
                                '.sv_compare_url(false,'compare-link','<span>','</span>').'
                            </div>';
                break;

            case 'style3':
                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s"></a>',
                        esc_url( $product->add_to_cart_url() ),
                        esc_attr( $product->get_id() ),
                        esc_attr( $product->get_sku() ),
                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button addcart-link' : '',
                        esc_attr( $product->get_type() ),
                        esc_html( $product->add_to_cart_text() )
                    ),
                $product );        
                $html_wl = '';
                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.esc_url(str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() ))).'" class="add_to_wishlist wishlist-link" rel="nofollow" data-product-id="'.get_the_ID().'"></a>';
                $html =    '<div class="product-extra-link product style3">
                                '.$button_html.'
                                '.$html_wl.'
                                '.sv_compare_url(false,'compare-link').'
                                <a data-product-id="'.get_the_id().'" href="'.esc_url(get_the_permalink()).'" class="product-quick-view quickview-link"></a>
                            </div>';
                break;

            case 'style2':
                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s"><span>%s</span></a>',
                        esc_url( $product->add_to_cart_url() ),
                        esc_attr( $product->get_id() ),
                        esc_attr( $product->get_sku() ),
                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button addcart-link' : '',
                        esc_attr( $product->get_type() ),
                        esc_html( $product->add_to_cart_text() )
                    ),
                $product );        
                $html_wl = '';
                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.esc_url(str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() ))).'" class="add_to_wishlist wishlist-link" rel="nofollow" data-product-id="'.get_the_ID().'"><span>'.esc_html__("Add Wishlist","megastore").'</span></a>';
                $html =    '<div class="product-extra-link product">
                                '.$button_html.'
                                '.$html_wl.'
                                '.sv_compare_url(false,'compare-link','<span>','</span>').'
                            </div>';
                break;
            
            default:
                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s">%s<span class="icon"></span></a>',
                        esc_url( $product->add_to_cart_url() ),
                        esc_attr( $product->get_id() ),
                        esc_attr( $product->get_sku() ),
                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button button-radius btn-add-cart' : '',
                        esc_attr( $product->get_type() ),
                        esc_html( $product->add_to_cart_text() )
                    ),
                $product );        
                $html_wl = '';
                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.esc_url(str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() ))).'" class="add_to_wishlist btn-add-wishlist" rel="nofollow" data-product-id="'.get_the_ID().'">'.esc_html__("Add Wishlist","megastore").'</a>';
                $html =    '<div class="product-button">
                                '.$html_wl.'
                                '.sv_compare_url().'
                                '.$button_html.'
                            </div>';
                break;
        }        
        return $html;
    }
}
if(!function_exists('sv_product_link_single')){
    function sv_product_link_single($style = ''){        
        $html_wl = '';
        if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.esc_url(str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() ))).'" class="add_to_wishlist link-wishlist" rel="nofollow" data-product-id="'.get_the_ID().'">'.esc_html__("Add Wishlist","megastore").'</a>';
        $html =    '<div class="box-control-button clearfix">
                        '.$html_wl.'
                        '.sv_compare_url(true,'link-compare').'
                        <a class="link-sendmail" href="'.esc_url('mailto:'.get_option('admin_email')).'">'.esc_html__("Email to a Friend","megastore").'</a>
                        <a class="link-print" href="javascript:window.print()">'.esc_html__("Print","megastore").'</a>
                    </div>';
        return $html;
    }
}
if(!function_exists('sv_get_rating_html')){
    function sv_get_rating_html($count = false,$style = ''){
        global $product;
        $html = '';
        $star = $product->get_average_rating();
        $review_count = $product->get_review_count();
        $width = $star / 5 * 100;
        $html .=    '<div class="product-rating '.$style.'">
                        <div class="inner-rating" style="width:'.$width.'%;"></div>';
        if($count) $html .= '<span>('.$review_count.'s)</span>';
        $html .=    '</div>';
        return $html;
    }
}
if(!function_exists('sv_get_rating_html2')){
    function sv_get_rating_html2($count = false,$style = ''){
        global $product;
        $html = '';
        $star = $product->get_average_rating();
        $review_count = $product->get_review_count();
        $width = $star / 5 * 100;
        $html .=    '<div class="product-rate '.$style.'">
                        <div class="inner-rate" style="width:'.$width.'%;"></div>';
        if($count) $html .= '<span>('.$review_count.'s)</span>';
        $html .=    '</div>';
        return $html;
    }
}
if(!function_exists('sv_get_new_html')){
    function sv_get_new_html($style=''){
        global $product,$post;
        $date_pro = strtotime($post->post_date);
        $date_now = strtotime('now');
        $set_timer = sv_get_option( 'sv_set_time_woo', 30);
        $uppsell = ($date_now - $date_pro - $set_timer*24*60*60);
        if($uppsell < 0){
            $uppsell_html = '<span class="new">'.esc_html__('New','megastore').'</span>';
        }
        else $uppsell_html = '';
        return $uppsell_html;
    }
}
if(!function_exists('sv_get_saleoff_html')){
    function sv_get_saleoff_html($style=''){
        global $product;
        $from = $product->get_regular_price();
        $to = $product->get_price();
        $percent = $html = '';
        if($from != $to && $from > 0){
            $percent = round(($from-$to)/$from*100);
        }
        $html = '<span class="sale">'.esc_html__('Sale','megastore').'</span>';
        return $html;
    }
}
// Mini cart
if(!function_exists('sv_mini_cart')){
    function sv_mini_cart($echo = false){
        $html = '';
        if ( ! WC()->cart->is_empty() ){
            $count_item = 0; $html = '';
            $html .=    '<h5 class="mini-cart-head"><span class="cart-item-count set-cart-number">0</span> '.esc_html__("Items in my cart","megastore").'</h5>
                        <div class="mini-cart-list"><ul class="list-mini-cart-item clearfix">';                    
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $count_item++;
                $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                $product_quantity = woocommerce_quantity_input( array(
                    'input_name'  => "cart[{$cart_item_key}][qty]",
                    'input_value' => $cart_item['quantity'],
                    'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                    'min_value'   => '0'
                ), $_product, false );
                $thumb_html = '';
                if(has_post_thumbnail($product_id)) $thumb_html = $_product->get_image(array(100,100));
                $html .=    '<li class="product-info item-info-cart" data-key="'.$cart_item_key.'">
                                <div class="p-left">                                    
                                    <a href="'.esc_url( $_product->get_permalink( $cart_item )).'">
                                        '.$thumb_html.'
                                    </a>
                                </div>
                                <div class="p-right">
                                    <a href="#" class="remove_link btn-remove">x</a>
                                    <p class="p-name">'.$_product->get_title().'</p>
                                    <p class="product-price">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ).'</p>
                                    <p class="qty-product">'.esc_html__("Qty:","megastore").' <span class="qty-num">'.$cart_item['quantity'].'</span></p>
                                </div>
                            </li>';
            }
            $html .=    '</ul><input id="count-cart-item" type="hidden" value="'.$count_item.'">
                        </div>
                        <div class="toal-cart mini-cart-total">
                            <span>'.esc_html__("Total","megastore").'</span>
                            <span class="toal-price pull-right total-price get-cart-price">'.WC()->cart->get_cart_subtotal().'</span>
                        </div>
                        <div class="cart-buttons">
                            <a href="'.esc_url(wc_get_checkout_url()).'" class="button-radius btn-check-out">'.esc_html__("Checkout","megastore").'<span class="icon"></span></a>
                        </div>';
        }
        else $html .= '<h5 class="mini-cart-head">'.esc_html__("No Product in your cart.","megastore").'</h5>';
        if($echo) echo balanceTags($html);
        else return $html;
    }
}
//get type url
if(!function_exists('sv_get_key_url')){
    function sv_get_key_url($key,$value){
        if(function_exists('sv_get_current_url')) $current_url = sv_get_current_url();
        else $current_url = get_the_permalink();
        if(isset($_GET[$key])){
            $current_url = str_replace('&'.$key.'='.$_GET[$key], '', $current_url);
            $current_url = str_replace('?'.$key.'='.$_GET[$key], '?', $current_url);
        }
        if(strpos($current_url,'?') > -1 ){
            $current_url .= '&amp;'.$key.'='.$value;
        }
        else {
            $current_url .= '?'.$key.'='.$value;
        }
        return $current_url;
    }
}
//product main detail
if(!function_exists('sv_product_main_detai')){
    function sv_product_main_detai($ajax = false){
        global $post, $product, $woocommerce;
        sv_set_post_view();
        $thumb_id = array(get_post_thumbnail_id());
        $attachment_ids = $product->get_gallery_image_ids();
        $attachment_ids = array_merge($thumb_id,$attachment_ids);
        $attachment_ids = array_unique($attachment_ids);
        $ul_block = $pager_html = $ul_block2 = ''; $i = 1;
        $thumb_style = sv_get_value_by_id('product_thumb_style'); 
        $gallerys = '';       
        foreach ( $attachment_ids as $attachment_id ) {
            $image_link = wp_get_attachment_url( $attachment_id );
            if($i == 1) $gallerys .= $image_link;
            else $gallerys .= ','.$image_link;
            if ( ! $image_link )
                continue;
            $image_title    = esc_attr( get_the_title( $attachment_id ) );
            $image_caption  = esc_attr( get_post_field( 'post_excerpt', $attachment_id ) );
            $image       = wp_get_attachment_image( $attachment_id, 'full', 0, $attr = array(
                'title' => $image_title,
                'alt'   => $image_title
                ) );
            if($i == 1) $active = 'selected';
            else $active = '';
            $ul_block .=    '<li><a data-image_id="'.$attachment_id.'" class="'.$active.'" href="'.wp_get_attachment_url($attachment_id).'">'.$image.'</a></li>';            
            $i++;
        }
        $available_data = array();
        if( $product->is_type( 'variable' ) ) $available_data = $product->get_available_variations();        
        if(!empty($available_data)){
            foreach ($available_data as $available) {
                if(!empty($available['image_id']) && !in_array($available['image_id'],$attachment_ids)){
                    $attachment_ids[] = $available['image_id'];
                    if(!empty($available['image_id'])){
                        $image_title    = esc_attr( get_the_title( $available['image_id'] ) );
                        $image_caption  = esc_attr( get_post_field( 'post_excerpt', $available['image_id'] ) );
                        $image2 = wp_get_attachment_image( $available['image_id'], 'full', 0, $attr = array(
                            'title' => $image_title,
                            'alt'   => $image_title
                            ) );
                        $ul_block .= '<li><a data-image_id="'.$available['image_id'].'" href="'.wp_get_attachment_url($available['image_id']).'">'.$image2.'</a></li>';
                    }
                }
            }
        }
        $sku = get_post_meta(get_the_ID(),'_sku',true);
        $stock = get_post_meta(get_the_ID(),'_stock_status',true);
        echo    '<div class="row single-product-content">
                    <div class="col-sm-5">
                        <div class="block block-product-image">
                            <div class="product-image easyzoom easyzoom--overlay easyzoom--with-thumbnails image-lightbox" data-gallery="'.$gallerys.'">
                                <a href="'.wp_get_attachment_url(get_post_thumbnail_id()).'">
                                    '.get_the_post_thumbnail(get_the_ID(),array(450,450)).'
                                </a>
                            </div>
                            <div class="text">'.esc_html__("Hover on the image to zoom","megastore").'</div>
                            <div class="product-list-thumb">
                                <ul class="thumbnails kt-owl-carousel" data-margin="10" data-nav="true" data-responsive='."'".'{"0":{"items":2},"600":{"items":2},"1000":{"items":3}}'."'".'>
                                    '.$ul_block.'
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-7">
                        <div class="row">';
        $check_side = sv_get_option('show_product_side');
        if($check_side == 'on' && !sv_check_sidebar()) $col_info = 7;
        else $col_info = 12;
        if($ajax) $col_info = 12;
        echo                '<div class="col-sm-12 col-md-'.$col_info.'">
                                <div class="block-product-info">
                                    <h2 class="product-name">'.get_the_title().'</h2>
                                    <div class="price-box">
                                        '.$product->get_price_html().'
                                    </div>
                                    '.sv_get_rating_html();
        if(has_excerpt( get_the_ID() )) echo '<div class="desc">'.get_the_excerpt().'</div>';
                                    do_action('s7upf_template_single_add_to_cart');
        echo                        sv_product_link_single();
                                    do_action( 'woocommerce_single_product_summary' );
        echo                    '</div>
                            </div>';
        echo                sv_get_side_single($ajax);
        echo            '<div class="col-sm-12 col-md-12">
                            <div class="block block-category-list">
                                <div class="block-inner clearfix">';
        echo                        wc_get_product_category_list( $product->get_id(), ' ', _n( '', '', count( $product->get_category_ids() ), 'megastore' ) . ' ', '' );
        echo                    '</div>
                            </div>
                        </div>';
        echo            '</div>
                    </div>
                </div>';
    }
}
if(!function_exists('sv_get_side_single')){
    function sv_get_side_single($ajax = false){
        $check_show = sv_get_option('show_product_side');
        $html = '';
        if($check_show == 'on' && !$ajax && !sv_check_sidebar()){
            $image  = sv_get_option('side_title_image');
            $title  = sv_get_option('side_title');
            $title2 = sv_get_option('side_title2');
            $product_type = sv_get_option('product_side_type');
            $number = sv_get_option('show_product_number');
            $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $number,
                'orderby'           => 'date',
                'order'             => 'DESC',
            );
            if($product_type == 'trending'){
                $args['meta_query'][] = array(
                        'key'     => 'trending_product',
                        'value'   => 'on',
                        'compare' => '=',
                    );
            }
            if($product_type == 'top-rate'){
                $args['meta_key'] = '_wc_average_rating';
                $args['orderby'] = 'meta_value_num';
                $args['meta_query'] = WC()->query->get_meta_query();
                $args['tax_query'][] = WC()->query->get_tax_query();
            }
            if($product_type == 'top-seller'){
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
            }
            if($product_type=='onsale'){
                $args['meta_query']['relation']= 'OR';
                $args['meta_query'][]=array(
                    'key'   => '_sale_price',
                    'value' => 0,
                    'compare' => '>',                
                    'type'          => 'numeric'
                );
                $args['meta_query'][]=array(
                    'key'   => '_min_variation_sale_price',
                    'value' => 0,
                    'compare' => '>',                
                    'type'          => 'numeric'
                );
            }
            if($product_type == 'featured'){
                $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
            }
            $html .=    '<div class="col-sm-12 col-md-5">
                            <div class="block block-top-sellers product-side">
                                <div class="block-head">
                                    <div class="block-title">
                                        <div class="block-icon">
                                            <img src="'.esc_url($image).'" alt="">
                                        </div>
                                        <div class="block-text">
                                            <div class="block-title-text text-sm">'.esc_html($title).'</div>
                                            <div class="block-title-text text-lg">'.esc_html($title2).'</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="block-inner">
                                    <ul class="products kt-owl-carousel" data-margin="10" data-items="1" data-autoplay="true" data-loop="true" data-nav="true" data-responsive='."'".'{"0":{"items":1},"600":{"items":2},"1000":{"items":1}}'."'".'>';
            $product_query = new WP_Query($args);
            if($product_query->have_posts()) {
                while($product_query->have_posts()) {
                    $product_query->the_post();
                    global $product;
                    $html .=        '<li class="item-product">
                                        <div class="product-container">
                                            <div class="product-left">';
                    $html .=                    sv_product_thumb_hover(array(230,230));                    
                    $html .=                '</div>
                                            <div class="product-right">
                                                <div class="product-name">
                                                    <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                                </div>
                                                <div class="price-box">
                                                    '.$product->get_price_html().'
                                                </div>
                                                '.sv_get_rating_html().'
                                                '.sv_product_link().'
                                            </div>
                                        </div>
                                    </li>';
                }
            }
            $html .=                '</ul>
                                </div>
                            </div>
                        </div>';
            wp_reset_postdata();
        }
        return $html;
    }
}
if(!function_exists('sv_single_upsell_product'))
{
    function sv_single_upsell_product()
    {
        $check_show = sv_get_value_by_id('show_single_upsell');
        $number = sv_get_value_by_id('show_single_number');
        if(!$number) $number = 6;$item = 5;
        if(sv_check_sidebar()) $item = 4;
        if($check_show == 'on' || $check_show == 'yes'){
            global $product;
            $upsells = $product->get_upsell_ids();
            ?>  
            <div class="block block-products-owl">
                <div class="block-head">
                    <div class="block-title">
                        <div class="block-title-text text-lg"><?php esc_html_e("Upsell Products","megastore")?></div>
                    </div>
                </div>
                <div class="block-inner">
                    <ul class="products kt-owl-carousel" data-margin="20" data-loop="true" data-nav="true" data-responsive='{"0":{"items":1},"568":{"items":2},"600":{"items":3},"1000":{"items":<?php echo esc_attr($item)?>}}'>
                    <?php
                        $meta_query = WC()->query->get_meta_query();
                        $args = array(
                            'post_type'           => 'product',
                            'ignore_sticky_posts' => 1,
                            'no_found_rows'       => 1,
                            'posts_per_page'      => $number,
                            'post__in'            => $upsells,
                            'post__not_in'        => array( $product->get_id() ),
                            'meta_query'          => $meta_query
                        );
                        $products = new WP_Query( $args );
                        if ( $products->have_posts() ) :
                            while ( $products->have_posts() ) : 
                                $products->the_post();                                  
                                global $product;
                                echo        '<li class="item-product">
                                                <div class="product-container">
                                                    <div class="product-left">';
                                echo                    sv_product_thumb_hover(array(230,230));                    
                                echo                '</div>
                                                    <div class="product-right">
                                                        <div class="product-name">
                                                            <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                                        </div>
                                                        <div class="price-box">
                                                            '.$product->get_price_html().'
                                                        </div>
                                                        '.sv_get_rating_html().'
                                                        '.sv_product_link().'
                                                    </div>
                                                </div>
                                            </li>';
                    ?>
                    
                    <?php   endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                    </ul>
                </div>
            </div>
        <?php
        }
    }
}
if(!function_exists('sv_single_lastest_product'))
{
    function sv_single_lastest_product()
    {
        $check_show = sv_get_value_by_id('show_single_lastest');
        $number = sv_get_value_by_id('show_single_number');
        if(!$number) $number = 6;$item = 5;
        if(sv_check_sidebar()) $item = 4;
        if($check_show == 'on' || $check_show == 'yes'){
            global $product;
            ?>  
            <div class="block block-products-owl">
                <div class="block-head">
                    <div class="block-title">
                        <div class="block-title-text text-lg"><?php esc_html_e("Lastest Products","megastore")?></div>
                    </div>
                </div>
                <div class="block-inner">
                    <ul class="products kt-owl-carousel" data-margin="20" data-loop="true" data-nav="true" data-responsive='{"0":{"items":1},"568":{"items":2},"600":{"items":3},"1000":{"items":<?php echo esc_attr($item)?>}}'>
                    <?php
                        $args = array(
                            'post_type'           => 'product',
                            'ignore_sticky_posts' => 1,
                            'posts_per_page'      => $number,
                            'post__not_in'        => array( $product->get_id() ),
                            'orderby'             => 'date'
                        );
                        $products = new WP_Query( $args );
                        if ( $products->have_posts() ) :
                            while ( $products->have_posts() ) : 
                                $products->the_post();                                  
                                global $product;
                                echo        '<li class="item-product">
                                                <div class="product-container">
                                                    <div class="product-left">';
                                echo                    sv_product_thumb_hover(array(230,230));                    
                                echo                '</div>
                                                    <div class="product-right">
                                                        <div class="product-name">
                                                            <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                                        </div>
                                                        <div class="price-box">
                                                            '.$product->get_price_html().'
                                                        </div>
                                                        '.sv_get_rating_html().'
                                                        '.sv_product_link().'
                                                    </div>
                                                </div>
                                            </li>';
                    ?>
                    
                    <?php   endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                    </ul>
                </div>
            </div>
        <?php
        }
    }
}
if(!function_exists('sv_single_relate_product'))
{
    function sv_single_relate_product()
    {
        global $product;
        $check_show = sv_get_value_by_id('show_single_relate');
        $number = sv_get_value_by_id('show_single_number');
        if(!$number) $number = 6;
        $related = wc_get_related_products($product->get_id(),$number);
        $item = 5;
        if(sv_check_sidebar()) $item = 4;
        if($check_show == 'on' || $check_show == 'yes'){
            global $product;
            ?>  
            <div class="block block-products-owl">
                <div class="block-head">
                    <div class="block-title">
                        <div class="block-title-text text-lg"><?php esc_html_e("Related Products","megastore")?></div>
                    </div>
                </div>
                <div class="block-inner">
                    <ul class="products kt-owl-carousel" data-margin="20" data-loop="true" data-nav="true" data-responsive='{"0":{"items":1},"568":{"items":2},"600":{"items":3},"1000":{"items":<?php echo esc_attr($item)?>}}'>
                    <?php
                        $args = array(
                            'post_type'           => 'product',
                            'ignore_sticky_posts'  => 1,
                            'no_found_rows'        => 1,
                            'posts_per_page'       => $number,                                    
                            'orderby'              => 'ID',
                            'post__in'             => $related,
                            'post__not_in'         => array( $product->get_id() )
                        );
                        $products = new WP_Query( $args );
                        if ( $products->have_posts() ) :
                            while ( $products->have_posts() ) : 
                                $products->the_post();                                  
                                global $product;
                                echo        '<li class="item-product">
                                                <div class="product-container">
                                                    <div class="product-left">';
                                echo                    sv_product_thumb_hover(array(230,230));                    
                                echo                '</div>
                                                    <div class="product-right">
                                                        <div class="product-name">
                                                            <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                                        </div>
                                                        <div class="price-box">
                                                            '.$product->get_price_html().'
                                                        </div>
                                                        '.sv_get_rating_html().'
                                                        '.sv_product_link().'
                                                    </div>
                                                </div>
                                            </li>';
                    ?>
                    
                    <?php   endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                    </ul>
                </div>
            </div>
        <?php
        }
    }
}
if(!function_exists('sv_check_sidebar')){
    function sv_check_sidebar(){
        $sidebar = sv_get_sidebar();
        if($sidebar['position'] == 'no') return false;
        else return true;
    }
}
if(!function_exists('sv_substr')){
    function sv_substr($string='',$start=0,$end=1){
        $output = '';
        if(!empty($string)){
            if($end < strlen($string)){
                if($string[$end] != ' '){
                    for ($i=$end; $i < strlen($string) ; $i++) { 
                        if($string[$i] == ' ' || $string[$i] == '.' || $i == strlen($string)-1){
                            $end = $i;
                            break;
                        }
                    }
                }
            }
            $output = substr($string,$start,$end);
        }
        return $output;
    }
}
//Get all page
if(!function_exists('sv_list_all_page'))
{
    function sv_list_all_page()
    {
        global $post;
        $page_list = array(
            esc_html__('-- Choose One --','megastore') => '',
            );
        $pages = get_pages();
        foreach ($pages as $page) {
            $page_list[$page->post_title] = $page->ID;
        }
        return $page_list;
    }
}
if(!function_exists('sv_header_slider_shop')){
    function sv_header_slider_shop(){
        $header_show = sv_get_value_by_id('show_header');
        $header_data = sv_get_value_by_id('header_data');
        if(is_single()) $header_show = sv_get_value_by_id('show_header_single');
        $html = '';
        if(($header_show == 'on' || $header_show == 'yes') && !empty($header_data) && sv_is_woocommerce_page()){            
        $html .=    '<div class="block block-categories-slider">
                        <div class="list kt-owl-carousel" data-animateout="fadeOut" data-animatein="fadeIn" data-items="1" data-autoplay="true" data-margin="0" data-loop="true" data-nav="true">';
            foreach ($header_data as $header) {
                $html .=    '<a href="'.esc_url($header['link']).'"><img src="'.esc_url($header['image']).'" alt=""></a>';
            }        
        $html .=        '</div>
                    </div>';
        }
        echo balanceTags($html);
    }
}
//get type url
if(!function_exists('sv_get_filter_url')){
    function sv_get_filter_url($key,$value){
        if(function_exists('sv_get_current_url')) $current_url = sv_get_current_url();
        else $current_url = get_the_permalink();
        if(isset($_GET[$key])){
            $current_val_string = $_GET[$key];
            if($current_val_string == $value){
                $current_url = str_replace('&'.$key.'='.$_GET[$key], '', $current_url);
                $current_url = str_replace('?'.$key.'='.$_GET[$key], '', $current_url);
            }
            $current_val_key = explode(',', $current_val_string);
            $val_encode = str_replace(',', '%2C', $current_val_string);
            if(!empty($current_val_string)){
                if(!in_array($value, $current_val_key)) $current_val_key[] = $value;
                else{
                    $pos = array_search($value, $current_val_key);
                    unset($current_val_key[$pos]);
                }            
                $new_val_string = implode('%2C', $current_val_key);
                $current_url = str_replace($key.'='.$val_encode, $key.'='.$new_val_string, $current_url);
                if (strpos($current_url, '?') == false) $current_url = str_replace('&','?',$current_url);
            }
            else $current_url = str_replace($key.'=', $key.'='.$value, $current_url);     
        }
        else{
            if(strpos($current_url,'?') > -1 ){
                $current_url .= '&amp;'.$key.'='.$value;
            }
            else {
                $current_url .= '?'.$key.'='.$value;
            }
        }
        return $current_url;
    }
}

if(!function_exists('sv_header_filter_shop')){
    function sv_header_filter_shop($show = false,$custom_cat = ''){
        $filter_show = sv_get_value_by_id('show_filter');
        $html = '';
        if(($filter_show == 'on' || $filter_show == 'yes' || $show) && !is_single()){
            if(!empty($custom_cat)) $custom_cat = explode(',', $custom_cat);
            else $cats = get_terms('product_cat');
            $cat_current = array();
            if(isset($_GET['product_cat'])) $cat_current = $_GET['product_cat'];
            if(!empty($cat_current)) $cat_current = explode(',', $cat_current);
            else $cat_current = array();
            global $wpdb,$wp;
                    $price_arange = sv_get_price_arange();
                    $min = $price_arange['min'];
                    $max = $price_arange['max'];
                    if(isset($_GET['product_cat'])) $cat_input_html = '<input class="product-cat-filter" type="hidden" name="product_cat" value="'.$_GET['product_cat'].'">';
                    else $cat_input_html = '';
                    if(isset($_GET['min_price'])) $current_min = $_GET['min_price'];
                    else $current_min = $min;
                    if(isset($_GET['max_price'])) $current_max = $_GET['max_price'];
                    else $current_max = $max;
                    if ( '' == get_option( 'permalink_structure' ) ) {
                        $form_action = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', esc_url(home_url( '/' )).$wp->request ) );
                    } else {
                        $form_action = preg_replace( '%\/page/[0-9]+%', '', esc_url(home_url( '/' )).trailingslashit( $wp->request ) );
                    }
                    $attribute = wc_get_attribute_taxonomies();
                    $input_attr_html = '';
                    foreach ($attribute as $key => $attr) {
                        if(isset($_GET['pa_'.$attr->attribute_name])){
                            $input_attr_html .= '<input class=" product-attr product-attr-'.$attr->attribute_name.'" type="hidden" name="pa_'.$attr->attribute_name.'" value="'.$_GET['pa_'.$attr->attribute_name].'">';
                        }
                    }
            $html .=    '<div class="block block-filter-top">
                            <div class="row filter-item-top">
                                <div class="col-sm-3 col-md-2">
                                    <div class="filter-label first">'.esc_html__("Category","megastore").'</div>
                                </div>
                                <div class="col-sm-9 col-md-10 first">
                                    <div class="filter-value">
                                        <ul class="list-category">';
            if(!empty($custom_cat) && is_array($custom_cat)){
                foreach ($custom_cat as $cat_slug) {
                    $cat = get_term_by('slug',$cat_slug,'product_cat');
                    if(is_object($cat)){
                        if(in_array($cat->slug, $cat_current)) $active = 'active';
                        else $active = '';
                        $html .=            '<li><a href="'.esc_url(sv_get_filter_url('product_cat',$cat->slug)).'" class="'.$active.'"> '.$cat->name.'</a></li>';
                    }
                }
            }
            else{
                if(is_array($cats) && !empty($cats)){
                    foreach ($cats as $cat) {
                        if(is_object($cat)){
                            if(in_array($cat->slug, $cat_current)) $active = 'active';
                            else $active = '';
                            $html .=            '<li><a href="'.esc_url(sv_get_filter_url('product_cat',$cat->slug)).'" class="'.$active.'"> '.$cat->name.'</a></li>';
                        }   
                    }
                }
            }
            $html .=                    '</ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row filter-item-top">
                                <div class="col-sm-3 col-md-2">
                                    <div class="filter-label">'.esc_html__("Price","megastore").'</div>
                                </div>
                                <div class="col-sm-9 col-md-10">
                                    <div class="filter-value">
                                        <div class="block-filter-inner box-filter-price">
                                            <form method="get" action="'.esc_url( $form_action ).'">                                                
                                                <div data-label-reasult="'.esc_html__("Range:","megastore").'" data-min="'.$min.'" data-max="'.$max.'" data-unit="'.get_woocommerce_currency_symbol().'" class="slider-range-price" data-value-min="'.$current_min.'" data-value-max="'.$current_max.'"></div>
                                                <div class="amount-range-price">'.esc_html__("Range:","megastore").' '.get_woocommerce_currency_symbol().$current_min.' - '.get_woocommerce_currency_symbol().$current_max.'</div>
                                                <input class="price-min-filter" type="hidden" name="min_price" value="'.$current_min.'">
                                                <input class="price-max-filter" type="hidden" name="max_price" value="'.$current_max.'">
                                                '.$cat_input_html.'
                                                '.$input_attr_html.'
                                                <div class="price-submit">
                                                    <button class="btn-filter button">'.esc_html__("Filter","megastore").'</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>';
            if(is_array($attribute) && !empty($attribute)){
                foreach ($attribute as $key => $attr) {
                    $terms = get_terms("pa_".$attr->attribute_name);
                    $term_current = array();
                    if(isset($_GET['pa_'.$attr->attribute_name])) $term_current = $_GET['pa_'.$attr->attribute_name];
                    if(!empty($term_current)) $term_current = explode(',', $term_current);
                    else $term_current = array();
                    if($attr->attribute_name == 'color'){                        
                        $html .=    '<div class="row filter-item-top">
                                    <div class="col-sm-3 col-md-2">
                                        <div class="filter-label">'. wc_attribute_label( $attr->attribute_name ).'</div>
                                    </div>
                                    <div class="col-sm-9 col-md-10">
                                        <div class="filter-value">
                                            <ul class="list-color">';
                        if(is_array($terms)){
                            foreach ($terms as $term) {
                                if(is_object($term)){
                                    if(in_array($term->slug, $term_current)) $active = 'selected';
                                    else $active = '';
                                    $html .= '<li><a class="'.$active.'" href="'.esc_url(sv_get_filter_url('pa_'.$attr->attribute_name,$term->slug)).'"><span class="color-'.$term->slug.'"></span></a></li>';
                                }
                            }
                        }
                        $html .=                '</ul>
                                        </div>
                                    </div>
                                </div>';
                    }
                    else{
                        $html .=    '<div class="row filter-item-top">
                                    <div class="col-sm-3 col-md-2">
                                        <div class="filter-label">'. wc_attribute_label( $attr->attribute_name ).'</div>
                                    </div>
                                    <div class="col-sm-9 col-md-10">
                                        <div class="filter-value">
                                            <ul class="list-size">';
                        if(is_array($terms)){
                            foreach ($terms as $term) {
                                if(is_object($term)){
                                    if(in_array($term->slug, $term_current)) $active = 'selected';
                                    else $active = '';
                                    $html .= '<li><a class="'.$active.'" href="'.esc_url(sv_get_filter_url('pa_'.$attr->attribute_name,$term->slug)).'"><span>'.$term->name.'</span></a></li>';
                                }
                            }
                        }
                        $html .=            '</ul>
                                        </div>
                                    </div>
                                </div>';
                    }
                }
            }            
            $html .=    '</div>';
        }
        echo balanceTags($html);
    }
}
if ( ! function_exists( 'sv_catalog_ordering' ) ) {
    function sv_catalog_ordering($query) {        
        $orderby                 = isset( $_GET['orderby'] ) ? wc_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
        $show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
        $catalog_orderby_options = apply_filters( 'woocommerce_catalog_orderby', array(
            'menu_order' => __( 'Default sorting', 'megastore' ),
            'popularity' => __( 'Sort by popularity', 'megastore' ),
            'rating'     => __( 'Sort by average rating', 'megastore' ),
            'date'       => __( 'Sort by newness', 'megastore' ),
            'price'      => __( 'Sort by price: low to high', 'megastore' ),
            'price-desc' => __( 'Sort by price: high to low', 'megastore' )
        ) );

        if ( ! $show_default_orderby ) {
            unset( $catalog_orderby_options['menu_order'] );
        }

        if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
            unset( $catalog_orderby_options['rating'] );
        }

        wc_get_template( 'loop/orderby.php', array( 'catalog_orderby_options' => $catalog_orderby_options, 'orderby' => $orderby, 'show_default_orderby' => $show_default_orderby ) );
    }
}
if(!function_exists('sv_check_sidebar')){
    function sv_check_sidebar(){
        $sidebar = sv_get_sidebar();
        if($sidebar['position'] == 'no') return false;
        else return true;
    }
}
if(!function_exists('sv_get_import_category')){
    function sv_get_import_category($taxonomy){
        $cats = get_terms($taxonomy);
        $data_json = '{';
        foreach ($cats as $key => $term) {
            $thumb_cat_id = get_woocommerce_term_meta( $term->term_id, 'thumbnail_id', true );
            $term_pa = get_term_by( 'id',$term->parent, $taxonomy );
            if(isset($term_pa->slug)) $slug_pa = $term_pa->slug;
            else $slug_pa = '';
            if($key > 0) $data_json .= ',';
            $data_json .= '"'.$term->slug.'":{"thumbnail":"'.$thumb_cat_id.'","parent":"'.$slug_pa.'"}';
        }
        $data_json .= '}';
        echo balanceTags($data_json);
    }
}
/***************************************END Theme Function***************************************/
