<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_shop'))
{
    function sv_vc_shop($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'title'      => '',
            'style'      => 'grid',
            'number'     => '12',
            'column'     => 'col-md-12 col-sm-12',
            'filter'     => '',
            'cats'     => '',
        ),$attr));
        $type = $style;$orderby = 'menu_order';
        if(isset($_GET['orderby'])){
            $orderby = $_GET['orderby'];
        }
        if(isset($_GET['type'])){
            $type = $_GET['type'];
        }
        if(isset($_GET['number'])){
            $number = $_GET['number'];
        }
        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
        $args = array(
            'post_type'         => 'product',
            'posts_per_page'    => $number,
            'paged'             => $paged,
            );
        $attr_taxquery = array();
        global $wpdb;
        $attribute_taxonomies = wc_get_attribute_taxonomies();
        if(!empty($attribute_taxonomies)){
            foreach($attribute_taxonomies as $attr){
                if(isset($_REQUEST['pa_'.$attr->attribute_name])){
                    $term = $_REQUEST['pa_'.$attr->attribute_name];
                    $term = explode(',', $term);
                    $attr_taxquery[] =  array(
                                            'taxonomy'      => 'pa_'.$attr->attribute_name,
                                            'terms'         => $term,
                                            'field'         => 'slug',
                                            'operator'      => 'IN'
                                        );
                }
            }
        }
        if ( !is_admin() && !empty($attr_taxquery)){
            $attr_taxquery = array('relation ' => 'AND');
            $args['meta_query'][]  = array(
                    'key'           => '_visibility',
                    'value'         => array('catalog', 'visible'),
                    'compare'       => 'IN'
                );
            $args['tax_query'] = $attr_taxquery;
        }
        if( isset( $_GET['min_price']) && isset( $_GET['max_price']) ){
            $min = $_GET['min_price'];
            $max = $_GET['max_price'];
            $args['post__in'] = sv_filter_price($min,$max);
        }
        switch ($orderby) {
            case 'price' :
                $args['orderby']  = "meta_value_num ID";
                $args['order']    = 'ASC';
                $args['meta_key'] = '_price';
            break;

            case 'price-desc' :
                $args['orderby']  = "meta_value_num ID";
                $args['order']    = 'DESC';
                $args['meta_key'] = '_price';
            break;

            case 'popularity' :
                $args['meta_key'] = 'total_sales';
                add_filter( 'posts_clauses', array( WC()->query, 'order_by_popularity_post_clauses' ) );
            break;

            case 'rating' :
                $args['meta_key'] = '_wc_average_rating';
                $args['orderby'] = 'meta_value_num';
                $args['meta_query'] = WC()->query->get_meta_query();
                $args['tax_query'][] = WC()->query->get_tax_query();
            break;

            case 'date':
                $args['orderby'] = 'date';
                break;
            
            default:
                $args['orderby'] = 'menuorder';
                break;
        }
        $grid_active = $list_active = '';
        if($type == 'grid') $grid_active = 'active'; 
        if($type == 'list') $list_active = 'active';
        $product_query = new WP_Query($args);
        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
        $sidebar=sv_get_sidebar();
        $sidebar_pos=$sidebar['position'];
        $view_col = 3; $control_col = 9;
        $col_thumb = 4;$col_info= 8;
        if($sidebar_pos == 'left-right'){
            $view_col = 4; $control_col = 8;
            $col_thumb = $col_info = 6;
        }
        ob_start();
        if($filter == "yes"){
            sv_header_filter_shop(true,$cats);
        }
        ?>
        <?php if(!empty($title)){
            echo '<h3 class="page-title">
                <span>'.esc_html($title).'</span>
            </h3>';
        }
        ?>
        <div class="sortPagiBar">
            <ul class="display-product-option">
                <li class="view-as-grid <?php if($type == 'grid') echo 'selected'?>">
                    <a href="<?php echo esc_url(sv_get_key_url('type','grid'))?>"><span><?php esc_html_e("grid","megastore")?></span></a>
                </li>
                <li class="view-as-list <?php if($type == 'list') echo 'selected'?>">
                    <a href="<?php echo esc_url(sv_get_key_url('type','list'))?>"><span><?php esc_html_e("list","megastore")?></span></a>
                </li>
            </ul>
            <div class="sortPagiBar-inner">
                <nav>
                    <?php
                        echo paginate_links( array(
                            'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
                            'format'       => '',
                            'add_args'     => '',
                            'current'      => max( 1, get_query_var( 'paged' ) ),
                            'total'        => $product_query->max_num_pages,
                            'prev_text' => '<span>'.esc_html__( '&laquo; Prev', 'megastore' ).'</span>',
                            'next_text' => '<span>'.esc_html__( 'Next &raquo;', 'megastore' ).'</span>',
                            'type'         => 'list',
                            'end_size'     => 2,
                            'mid_size'     => 1
                        ) );
                    ?>
                </nav>
                <div class="show-product-item">
                    <span><?php esc_html_e("Show ","megastore")?><?php echo esc_attr($number)?></span>
                    <ul class="per-page-list">
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','6'))?>"><?php esc_html_e("Show 6","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','9'))?>"><?php esc_html_e("Show 9","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','12'))?>"><?php esc_html_e("Show 12","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','18'))?>"><?php esc_html_e("Show 18","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','24'))?>"><?php esc_html_e("Show 24","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','48'))?>"><?php esc_html_e("Show 48","megastore")?></a></li>
                    </ul>
                </div>
                
                <div class="sort-product">
                    <?php sv_catalog_ordering($product_query)?>
                </div>
            </div>
        </div>
        <div class="category-products">
            <ul class="products product <?php echo esc_attr($type)?> row">
        <?php
        $count_product = 1;
        if($product_query->have_posts()) {
            while($product_query->have_posts()) {
                $product_query->the_post();
                global $product;
                ?>
                <?php if($type == 'list'){
                    ?>
                    <li class="item-product col-xs-12 col-sm-12 col-md-6">
                        <?php 
                        echo    '<div class="product-container">
                                    <div class="inner row">
                                        <div class="product-left col-sm-6 col-xs-6">
                                            '.sv_product_thumb_hover(array(330,330)).'
                                        </div>
                                        <div class="product-right col-sm-6 col-xs-6">
                                            <div class="product-name">
                                                <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                            </div>
                                            <div class="price-box">
                                                '.$product->get_price_html().'
                                            </div>
                                            '.sv_get_rating_html().'
                                            <div class="desc">'.get_the_excerpt().'</div>                            
                                            '.sv_product_link().'
                                        </div>
                                    </div>
                                </div>';
                        ?>      
                    </li>
                <?php }
                else{
                    $size = array(330,330);$col_option = 1;
                    if($column == 'col-md-12 col-sm-12') $size = 'full';
                    if($column == 'col-md-6 col-sm-6'){
                        $size = array(550,550);
                        $col_option = 2;
                    }
                    if($column == 'col-md-4 col-sm-6') $col_option = 3;
                    if($column == 'col-md-3 col-sm-4') $col_option = 4;
                    if($column == 'col-md-2 col-sm-4') $col_option = 6;
                    if($count_product % $col_option == 1) $break_class = 'break-item';
                    else $break_class = '';
                ?>
                <li class="item-product <?php echo esc_attr($column)?> col-xs-6 <?php echo esc_attr($break_class)?>">
                    <?php 
                        echo    '<div class="product-container">
                            <div class="inner">
                                <div class="product-left">
                                    '.sv_product_thumb_hover($size).'
                                </div>
                                <div class="product-right">
                                    <div class="product-name">
                                        <a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
                                    </div>
                                    <div class="price-box">
                                        '.$product->get_price_html().'
                                    </div>
                                    '.sv_get_rating_html().'
                                    '.sv_product_link().'
                                </div>
                            </div>
                        </div>';
                    ?>
                </li>
                <?php 
                $count_product++;
                }
            }
        }
        ?>
            </ul>
        </div>
        <div class="sortPagiBar">
            <ul class="display-product-option">
                <li class="view-as-grid <?php if($type == 'grid') echo 'selected'?>">
                    <a href="<?php echo esc_url(sv_get_key_url('type','grid'))?>"><span><?php esc_html_e("grid","megastore")?></span></a>
                </li>
                <li class="view-as-list <?php if($type == 'list') echo 'selected'?>">
                    <a href="<?php echo esc_url(sv_get_key_url('type','list'))?>"><span><?php esc_html_e("list","megastore")?></span></a>
                </li>
            </ul>
            <div class="sortPagiBar-inner">
                <?php if($product_query->max_num_pages > 1){?>
                <nav>
                    <?php
                        echo paginate_links( array(
                            'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
                            'format'       => '',
                            'add_args'     => '',
                            'current'      => max( 1, get_query_var( 'paged' ) ),
                            'total'        => $product_query->max_num_pages,
                            'prev_text' => '<span>'.esc_html__( '&laquo; Prev', 'megastore' ).'</span>',
                            'next_text' => '<span>'.esc_html__( 'Next &raquo;', 'megastore' ).'</span>',
                            'type'         => 'list',
                            'end_size'     => 2,
                            'mid_size'     => 1
                        ) );
                    ?>
                </nav>
                <?php }?>
                <div class="show-product-item">
                    <span><?php esc_html_e("Show ","megastore")?><?php echo esc_attr($number)?></span>
                    <ul class="per-page-list">
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','6'))?>"><?php esc_html_e("Show 6","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','9'))?>"><?php esc_html_e("Show 9","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','12'))?>"><?php esc_html_e("Show 12","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','18'))?>"><?php esc_html_e("Show 18","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','24'))?>"><?php esc_html_e("Show 24","megastore")?></a></li>
                        <li><a href="<?php echo esc_url(sv_get_key_url('number','48'))?>"><?php esc_html_e("Show 48","megastore")?></a></li>
                    </ul>
                </div>
                
                <div class="sort-product">
                    <?php sv_catalog_ordering($product_query)?>
                </div>
            </div>
        </div>
        <?php
        $html .= ob_get_clean();
        wp_reset_postdata();
        return $html;
    }
}

stp_reg_shortcode('sv_shop','sv_vc_shop');
add_action( 'vc_before_init_base','sv_admin_shop',10,100 );
if ( ! function_exists( 'sv_admin_shop' ) ) {
    function sv_admin_shop(){
        vc_map( array(
            "name"      => esc_html__("SV Shop", 'megastore'),
            "base"      => "sv_shop",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    "type" => "textfield",
                    "holder"    => 'div',
                    "heading" => esc_html__("Title",'megastore'),
                    "param_name" => "title",
                    ),
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Style",'megastore'),
                    "param_name" => "style",
                    "value"     => array(
                        esc_html__("Grid",'megastore')   => 'grid',
                        esc_html__("List",'megastore')   => 'list',
                        ),
                    ),
                array(
                    'heading'     => esc_html__( 'Number', 'megastore' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of product. Default is 12.', 'megastore' ),
                    'param_name'  => 'number',
                    ),
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Column",'megastore'),
                    "param_name" => "column",
                    "value"         => array(
                        esc_html__("1 Column","megastore")          => 'col-md-12 col-sm-12',
                        esc_html__("2 Column","megastore")          => 'col-md-6 col-sm-6',
                        esc_html__("3 Column","megastore")          => 'col-md-4 col-sm-6',
                        esc_html__("4 Column","megastore")          => 'col-md-3 col-sm-4',
                        esc_html__("6 Column","megastore")          => 'col-md-2 col-sm-4',
                        ),
                    "dependency"    => array(
                        "element"   => "style",
                        "value"   => "grid",
                        )
                    ),
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Show filter top",'megastore'),
                    "param_name" => "filter",
                    "value"         => array(
                        esc_html__("No","megastore")          => '',
                        esc_html__("Yes","megastore")          => 'yes',
                        ),
                    ),                
                array(
                    'holder'     => 'div',
                    'heading'     => esc_html__( 'Custom Product Categories', 'megastore' ),
                    'type'        => 'checkbox',
                    'param_name'  => 'cats',
                    'value'       => sv_list_taxonomy('product_cat',false)
                    ),
                ),
        ));
    }
}