<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 31/08/15
 * Time: 10:00 AM
 */
/************************************Main Slider*************************************/
if(!function_exists('sv_vc_cat_slider'))
{
    function sv_vc_cat_slider($attr, $content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style'           => 'style1',
            'title'           => '',
            'item'            => '3',
            'item_res'        => '',
            'autoplay'        => 'false',
            'loop'            => 'true',
        ),$attr));
        $data_res = '';$data_margin = 0;
        if(!empty($item_res)){
            $item_data = explode(',', $item_res);
            if(is_array($item_data)){
                $count_data = 1;
                foreach ($item_data as $data_device) {
                    $data_device = explode(':', $data_device);
                    if(is_array($data_device)){
                        $data_res .= '"'.$data_device[0].'":{"items":'.$data_device[1].'}';
                        if($count_data < count($item_data)) $data_res .= ',';                        
                        $count_data++;
                    }
                }
            }
            $data_res = "'".'{'.$data_res.'}'."'";
        }
        else{
            if($item >= 3) $data_res = "'".'{"0":{"items":1},"600":{"items":2},"1000":{"items":'.$item.'}}'."'";
            if($item >= 5) $data_res = "'".'{"0":{"items":1},"600":{"items":3},"1000":{"items":'.$item.'}}'."'";
            if($item >= 7) $data_res = "'".'{"0":{"items":1},"600":{"items":3},"1000":{"items":5},"1170":{"items":'.$item.'}}'."'";
        }
        switch ($style) {
            case 'style2':
                if($item >1) $data_margin = 30;
                $html .=    '<div class="option4 clearfix">
                                <div class="block-categories kt-owl-carousel" data-items="'.$item.'" data-autoplay="'.$autoplay.'" data-margin="'.$data_margin.'" data-loop="'.$loop.'"  data-nav="true" data-responsive='.$data_res.'>';
                $html .=            wpb_js_remove_wpautop($content, false);
                $html .=        '</div>
                            </div>';
                break;
            
            default:
                $html .=    '<div class="block-popular-cat">
                                <h3 class="title">
                                    <span class="text">'.esc_html($title).'</span>
                                </h3>
                                <div class="popular-inner">
                                    <div class="list-popular-cat kt-owl-carousel" data-items="'.$item.'" data-autoplay="'.$autoplay.'" data-margin="'.$data_margin.'" data-loop="'.$loop.'"  data-nav="true" data-responsive='.$data_res.'>';
                $html .=                wpb_js_remove_wpautop($content, false);
                $html .=            '</div>
                                </div>
                            </div>';
                break;
        }        
        return $html;
    }
}
stp_reg_shortcode('sv_cat_slider','sv_vc_cat_slider');
vc_map(
    array(
        'name'     => esc_html__( 'SV Product Category Slider', 'megastore' ),
        'base'     => 'sv_cat_slider',
        'category' => esc_html__( '7Up-theme', 'megastore' ),
        'icon'     => 'icon-st',
        'as_parent' => array( 'only' => 'sv_cat_slider_item,sv_cat_slider_item2' ),
        'content_element' => true,
        'js_view' => 'VcColumnView',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style', 'megastore' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Style 1', 'megastore' )    => 'style1',  
                    esc_html__( 'Style 2', 'megastore' )    => 'style2',  
                    )
            ),          
            array(
                'type'        => 'textfield',
                'holder'      => 'h4',
                'heading'     => esc_html__( 'Title', 'megastore' ),
                'param_name'  => 'title',
                'dependency'  => array(
                    'element'   => 'style',
                    'value'   => 'style1',
                    )
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__("Item",'megastore'),
                "param_name"    => "item",
                "description"   => esc_html__("Default is 3.",'megastore'),
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__("Item Responsive",'megastore'),
                "param_name"    => "item_res",
                'description' => esc_html__( 'Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,600:3,1000:4. Default is auto.', 'megastore' ),
            ),
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__("Autoplay",'megastore'),
                "param_name"    => "autoplay",
                "value"         => array(
                    esc_html__("False",'megastore') => 'false',
                    esc_html__("True",'megastore') => 'true',
                    )
            ),
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__("Loop",'megastore'),
                "param_name"    => "loop",
                "value"         => array(
                    esc_html__("True",'megastore') => 'true',
                    esc_html__("False",'megastore') => 'false',
                    )
            ),
        )
    )
);

/*******************************************END MAIN*****************************************/


/**************************************BEGIN ITEM************************************/
//Banner item Frontend
if(!function_exists('sv_vc_cat_slider_item'))
{
    function sv_vc_cat_slider_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'image'           => '',
            'cat'             => '',
            'title'           => '',
            'number'          => '5',
            'order_by'        => 'date',
            'order'           => 'DESC',
            'product_type'    => '',
        ),$attr));
        $term = get_term_by( 'slug',$cat, 'product_cat' );
        if(!empty($term) && is_object($term)){            
            $term_link = get_term_link( $term->term_id, 'product_cat' );
            if(empty($title)) $title = $term->name;
            $html .=    '<div class="item">
                            <div class="image">
                                '.wp_get_attachment_image($image,'full').'
                            </div>
                            <div class="inner">
                                <h5 class="parent-categories">'.esc_html($title).'</h5>
                                <ul class="sub-categories">';
            $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $number,
                'orderby'           => $order_by,
                'order'             => $order,
                );
            if($product_type == 'trendding'){
                $args['meta_query'][] = array(
                        'key'     => 'trending_product',
                        'value'   => 'on',
                        'compare' => '=',
                    );
            }
            if($product_type == 'toprate'){
                $args['meta_key'] = '_wc_average_rating';
                $args['orderby'] = 'meta_value_num';
                $args['meta_query'] = WC()->query->get_meta_query();
                $args['tax_query'][] = WC()->query->get_tax_query();
            }
            if($product_type == 'mostview'){
                $args['meta_key'] = 'post_views';
                $args['orderby'] = 'meta_value_num';
            }
            if($product_type == 'bestsell'){
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
            }
            if($product_type=='onsale'){
                $args['meta_query']['relation']= 'OR';
                $args['meta_query'][]=array(
                    'key'   => '_sale_price',
                    'value' => 0,
                    'compare' => '>',                
                    'type'          => 'numeric'
                );
                $args['meta_query'][]=array(
                    'key'   => '_min_variation_sale_price',
                    'value' => 0,
                    'compare' => '>',                
                    'type'          => 'numeric'
                );
            }
            if($product_type == 'featured'){
                $args['tax_query'][] =  array(
                                            'taxonomy' => 'product_visibility',
                                            'field'    => 'name',
                                            'terms'    => 'featured',
                                            'operator' => 'IN',
                                        );
            }
            $args['tax_query'][]=array(
                'taxonomy'=>'product_cat',
                'field'=>'slug',
                'terms'=> $cat
            );
            $product_query = new WP_Query($args);
            if($product_query->have_posts()) {
                while($product_query->have_posts()) {
                    $product_query->the_post();
                    $html .=        '<li><a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a></li>';
                }
            }
            $html .=            '</ul>
                            </div>
                        </div>';
        }
        wp_reset_postdata();
        return $html;
    }
}
stp_reg_shortcode('sv_cat_slider_item','sv_vc_cat_slider_item');

// Cat item
add_action( 'vc_before_init_base','sv_admin_category_item',10,100 );
if ( ! function_exists( 'sv_admin_category_item' ) ) {
    function sv_admin_category_item(){
        vc_map(
            array(
                'name'     => esc_html__( 'Category Item', 'megastore' ),
                'base'     => 'sv_cat_slider_item',
                'icon'     => 'icon-st',
                'content_element' => true,
                'as_child' => array('only' => 'sv_cat_slider'),
                'params'   => array(
                    array(
                        'type'        => 'attach_image',
                        'heading'     => esc_html__( 'Image', 'megastore' ),
                        'param_name'  => 'image',
                    ),            
                    array(
                        'type'        => 'dropdown',
                        'holder'      => 'div',
                        'heading'     => esc_html__( 'Product Category', 'megastore' ),
                        'param_name'  => 'cat',
                        'value'       => sv_list_taxonomy('product_cat',true),
                    ),
                    array(
                        'type'        => 'textfield',
                        'holder'      => 'h4',
                        'heading'     => esc_html__( 'Title', 'megastore' ),
                        'param_name'  => 'title',
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Number', 'megastore' ),
                        'param_name'  => 'number',
                        'description' => esc_html__( 'Default is 5.', 'megastore' ),
                    ),                    
                    array(
                        'heading'     => esc_html__( 'Product Type', 'megastore' ),
                        'type'        => 'dropdown',
                        'param_name'  => 'product_type',
                        'value' => array(
                            esc_html__('Default','megastore')            => '',
                            esc_html__('Trendding','megastore')          => 'trendding',
                            esc_html__('Featured Products','megastore')  => 'featured',
                            esc_html__('Best Sellers','megastore')       => 'bestsell',
                            esc_html__('On Sale','megastore')            => 'onsale',
                            esc_html__('Top rate','megastore')           => 'toprate',
                            esc_html__('Most view','megastore')          => 'mostview',
                        ),
                        'description' => esc_html__( 'Select Product View Type', 'megastore' ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__( 'Order By', 'megastore' ),
                        'value' => sv_get_order_list(),
                        'param_name' => 'orderby',
                        'description' => esc_html__( 'Select Orderby Type ', 'megastore' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                    array(
                        'heading'     => esc_html__( 'Order', 'megastore' ),
                        'type'        => 'dropdown',
                        'param_name'  => 'order',
                        'value' => array(                   
                            esc_html__('Desc','megastore')  => 'DESC',
                            esc_html__('Asc','megastore')  => 'ASC',
                        ),
                        'description' => esc_html__( 'Select Order Type ', 'megastore' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                )
            )
        );
    }
}

/**************************************END ITEM************************************/

/**************************************BEGIN ITEM************************************/
//Banner item Frontend
if(!function_exists('sv_vc_cat_slider_item2'))
{
    function sv_vc_cat_slider_item2($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'image'           => '',
            'cat'             => '',
            'title'           => '',
            'number'          => '6',
        ),$attr));
        $term = get_term_by( 'slug',$cat, 'product_cat' );
        if(!empty($term) && is_object($term)){            
            $term_link = get_term_link( $term->term_id, 'product_cat' );
            $term_childrents = get_term_children( $term->term_id, 'product_cat' );
            $cat_count = 1;$cat_number = (int)$number;
            if(empty($title)) $title = $term->name;
            $html .=    '<div class="block3 parent">
                            <div class="block-head">
                                <a href="'.esc_url($term_link).'">'.esc_html($title).'</a>
                            </div>
                            <div class="block-inner">
                                <a href="'.esc_url($term_link).'">'.wp_get_attachment_image($image,'full').'</a>';
            if(!empty($term_childrents)){
                $html .=        '<div class="sub-cat">
                                    <ul>';
                foreach ($term_childrents as $term_child) {
                    $term_childrent = get_term_by( 'id',$term_child, 'product_cat' );
                    $term_childrent_link = get_term_link( $term_childrent, 'product_cat' );
                    if(is_object($term_childrent)){
                    $html .=        '<li><a href="'.esc_url($term_childrent_link).'">'.$term_childrent->name.'</a></li>';
                    }
                    if($cat_count >= $cat_number) break;
                    $cat_count ++;
                }
                $html .=            '</ul>
                                </div>';
            }
            $html .=        '</div>
                        </div>';
        }
        wp_reset_postdata();
        return $html;
    }
}
stp_reg_shortcode('sv_cat_slider_item2','sv_vc_cat_slider_item2');

// Cat item
add_action( 'vc_before_init_base','sv_admin_category_item2',10,100 );
if ( ! function_exists( 'sv_admin_category_item2' ) ) {
    function sv_admin_category_item2(){
        vc_map(
            array(
                'name'     => esc_html__( 'Category Item 2', 'megastore' ),
                'base'     => 'sv_cat_slider_item2',
                'icon'     => 'icon-st',
                'content_element' => true,
                'as_child' => array('only' => 'sv_cat_slider'),
                'params'   => array(
                    array(
                        'type'        => 'attach_image',
                        'heading'     => esc_html__( 'Image', 'megastore' ),
                        'param_name'  => 'image',
                    ),            
                    array(
                        'type'        => 'dropdown',
                        'holder'      => 'div',
                        'heading'     => esc_html__( 'Product Category', 'megastore' ),
                        'param_name'  => 'cat',
                        'value'       => sv_list_taxonomy('product_cat',true),
                    ),                    
                    array(
                        'type'        => 'textfield',
                        'holder'      => 'h4',
                        'heading'     => esc_html__( 'Title', 'megastore' ),
                        'param_name'  => 'title',
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Number Categories Childrent', 'megastore' ),
                        'param_name'  => 'number',
                        'description' => esc_html__( 'Default is 6.', 'megastore' ),
                    ),
                )
            )
        );
    }
}

/**************************************END ITEM************************************/

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Sv_Cat_Slider extends WPBakeryShortCodesContainer {}
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Sv_Cat_Slider_Item extends WPBakeryShortCode {}
    class WPBakeryShortCode_Sv_Cat_Slider_Item2 extends WPBakeryShortCode {}
}