<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */
// Start at 16/6/2016
if(!function_exists('sv_vc_icon_box'))
{
    function sv_vc_icon_box($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'     => 'style1',
            'icon'      => '',
            'title'     => '',
            'title2'    => '',
            'des'       => '',
            'link'      => '',
        ),$attr));
        switch ($style) {
            case 'home13':
                $html .=    '<div class="item-service13">
                                <div class="service-icon">
                                    <a href="'.esc_url($link).'"><i class="fa '.esc_attr($icon).'" aria-hidden="true"></i></a>
                                </div>
                                <div class="service-info">
                                    <h3><a href="'.esc_url($link).'">'.esc_html($title).'</a></h3>
                                    <p>'.esc_html($des).'</p>
                                </div>
                            </div>';
                break;

            case 'style2':
                $html .=    '<div class="item-service8">
                                <div class="service-icon8">
                                    <a href="'.esc_url($link).'"><i class="fa '.esc_attr($icon).'" aria-hidden="true"></i></a>
                                </div>
                                <div class="service-info8">
                                    <h3><a href="'.esc_url($link).'">'.esc_html($title).'</a></h3>
                                    <p>'.esc_html($des).'</p>
                                </div>
                            </div>';
                break;

            case 'icon-left':
            case 'icon-right':
                $html .=    '<div class="item-about '.esc_attr($style).'">
                                <div class="about-info">
                                    <h3><a href="'.esc_url($link).'">'.esc_html($title).'</a></h3>
                                    <p>'.esc_html($des).'</p>
                                </div>
                                <div class="about-icon">
                                    <a href="'.esc_url($link).'"><i class="fa '.esc_attr($icon).'" aria-hidden="true"></i></a>
                                </div>
                            </div>';
                break;
            
            default:
                $html .=    '<div class="item-gift-cart">
                                <div class="icon-gift-cart">
                                    <a href="'.esc_url($link).'"><i class="fa '.esc_attr($icon).'" aria-hidden="true"></i></a>
                                </div>
                                <div class="info-gift-cart">
                                    <h3><a href="'.esc_url($link).'">'.esc_html($title).' <br> '.esc_html($title2).'</a></h3>
                                </div>
                            </div>';
                break;
        }
        return $html;
    }
}

stp_reg_shortcode('sv_icon_box','sv_vc_icon_box');

vc_map( array(
    "name"      => esc_html__("SV Icon Box", 'megastore'),
    "base"      => "sv_icon_box",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Style",'megastore'),
            "param_name" => "style",
            "value"     => array(
                esc_html__("Style 1",'megastore') => 'style1',
                esc_html__("About icon right",'megastore') => 'icon-right',
                esc_html__("About icon left",'megastore') => 'icon-left',
                esc_html__("Style 2 (Home 8)",'megastore') => 'style2',
                esc_html__("Service (Home 13)",'megastore') => 'home13',
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Icon",'megastore'),
            "param_name" => "icon",            
            'edit_field_class'=>'vc_col-sm-12 vc_column sv_iconpicker',
        ),
        array(
            "type" => "textfield",
            "holder" => "h3",
            "heading" => esc_html__("Title",'megastore'),
            "param_name" => "title",
        ),
        array(
            "type" => "textfield",
            "holder" => "h3",
            "heading" => esc_html__("Title line 2",'megastore'),
            "param_name" => "title2",
            "dependency"    => array(
                "element"   => 'style',
                "value"     => 'style1',
                )
        ),
        array(
            "type" => "textfield",
            "holder" => "p",
            "heading" => esc_html__("Description",'megastore'),
            "param_name" => "des",
            "dependency"    => array(
                "element"   => 'style',
                "value"     => array('icon-left','icon-right','style2','home13'),
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link",'megastore'),
            "param_name" => "link",
        )
    )
));