<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 31/08/15
 * Time: 10:00 AM
 */
/************************************Main Carousel*************************************/
if(!function_exists('sv_vc_category_icon'))
{
    function sv_vc_category_icon($attr, $content = false)
    {
        $html = $title_html = '';
        extract(shortcode_atts(array(
            'image'      => '',
            'title'      => '',
            'title2'      => '',
        ),$attr));
        $title_html =   '<div class="block-head">
                            <div class="block-title">';
        if(!empty($image)) $title_html .=   '<div class="block-icon">'.wp_get_attachment_image($image,'full').'</div>';
        $title_html .=          '<div class="block-text">
                                    <div class="block-title-text text-sm">'.esc_html($title).'</div>
                                    <div class="block-title-text text-lg">'.esc_html($title2).'</div>
                                </div>';
        $title_html .=      '</div>
                        </div>';
        $html .=    '<div class="list-product7 option7"><div class="block block-vertical-menu">
                        '.$title_html.'
                        <div class="vertical-menu-content">
                            <ul class="vertical-menu-list">';
        $html .=                 wpb_js_remove_wpautop($content, false);
        $html .=            '</ul>';
        $html .=        '</div>
                    </div></div>';
        return $html;
    }
}
stp_reg_shortcode('sv_category_icon','sv_vc_category_icon');
vc_map(
    array(
        'name'     => esc_html__( 'SV Categories List Icon', 'megastore' ),
        'base'     => 'sv_category_icon',
        'category' => esc_html__( '7Up-theme', 'megastore' ),
        'icon'     => 'icon-st',
        'as_parent' => array( 'only' => 'sv_category_icon_item' ),
        'content_element' => true,
        'js_view' => 'VcColumnView',
        'params'   => array(
            array(
                "type" => "attach_image",
                "heading" => esc_html__("Title image",'megastore'),
                "param_name" => "image",
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Title', 'megastore' ),
                'param_name'  => 'title',
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Title 2', 'megastore' ),
                'param_name'  => 'title2',
            ),
        )
    )
);

/*******************************************END MAIN*****************************************/

/**************************************BEGIN ITEM************************************/
//Banner item Frontend
if(!function_exists('sv_vc_category_icon_item'))
{
    function sv_vc_category_icon_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'cat'       => '',
            'image'     => '',
            'title'     => '',
            'link'      => '',
        ),$attr));
        $term = get_term_by( 'slug',$cat, 'product_cat' );
        if(!empty($term) && is_object($term)){            
            $term_link = get_term_link( $term->term_id, 'product_cat' );
            if(!empty($link)) $term_link = $link;
            $term_name = $term->name;
            if(!empty($title)) $term_name = $title;
            $html .=    '<li class="cat-item">
                            <a href="'.esc_url($term_link).'">'.wp_get_attachment_image($image,'full').$term_name.'</a>
                        </li>';
        }
        return $html;
    }
}
stp_reg_shortcode('sv_category_icon_item','sv_vc_category_icon_item');

// Banner item
add_action( 'vc_before_init_base','sv_admin_category_icon_item',10,100 );
if ( ! function_exists( 'sv_admin_category_icon_item' ) ) {
    function sv_admin_category_icon_item(){
        vc_map(
            array(
                'name'     => esc_html__( 'Product Category Item', 'megastore' ),
                'base'     => 'sv_category_icon_item',
                'icon'     => 'icon-st',
                'content_element' => true,
                'as_child' => array('only' => 'sv_category_icon'),
                'params'   => array(
                    array(
                        'type'        => 'dropdown',
                        'holder'      => 'div',
                        'heading'     => esc_html__( 'Product Category', 'megastore' ),
                        'param_name'  => 'cat',
                        'value'       => sv_list_taxonomy('product_cat',true),
                    ),
                    array(
                        "type" => "attach_image",
                        "heading" => esc_html__("Category image",'megastore'),
                        "param_name" => "image",
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Custom Title', 'megastore' ),
                        'param_name'  => 'title',
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Custom Link', 'megastore' ),
                        'param_name'  => 'link',
                    ),
                )
            )
        );
    }
}

/**************************************END ITEM************************************/


//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Sv_Category_Icon extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Sv_Category_Icon_Item extends WPBakeryShortCode {}
}