<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
/*********************************** ADD TO CART AJAX *******************************************/
if(class_exists("woocommerce")){
	add_action( 'wp_ajax_add_to_cart', 'sv_minicart_ajax' );
	add_action( 'wp_ajax_nopriv_add_to_cart', 'sv_minicart_ajax' );
	if(!function_exists('sv_minicart_ajax')){
		function sv_minicart_ajax() {
			
			$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) );
			$quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] );
			$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

			if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) ) {
				do_action( 'woocommerce_ajax_added_to_cart', $product_id );
				WC_AJAX::get_refreshed_fragments();
			} else {
				$this->json_headers();

				// If there was an error adding to the cart, redirect to the product page to show any errors
				$data = array(
					'error' => true,
					'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
					);
				echo json_encode( $data );
			}
			die();
		}
	}
	/*********************************** END ADD TO CART AJAX ****************************************/

	/*********************************** BEGIN UPDATE CART AJAX ****************************************/
    
    add_action( 'wp_ajax_update_mini_cart', 's7upf_update_mini_cart' );
    add_action( 'wp_ajax_nopriv_update_mini_cart', 's7upf_update_mini_cart' );
    if(!function_exists('s7upf_update_mini_cart')){
        function s7upf_update_mini_cart() {
            WC_AJAX::get_refreshed_fragments();
            die();
        }
    }
    /*********************************** END UPDATE CART  AJAX ****************************************/

    /********************************** REMOVE ITEM MINICART AJAX ************************************/

    add_action( 'wp_ajax_product_remove', 's7upf_product_remove' );
    add_action( 'wp_ajax_nopriv_product_remove', 's7upf_product_remove' );
    if(!function_exists('s7upf_product_remove')){
        function s7upf_product_remove() {
            global $wpdb, $woocommerce;
            $cart_item_key = $_POST['cart_item_key'];
            if ( $woocommerce->cart->get_cart_item( $cart_item_key ) ) {
                $woocommerce->cart->remove_cart_item( $cart_item_key );
            }
            WC_AJAX::get_refreshed_fragments();
            die();
        }
    }

	/********************************** HOOK ************************************/

	//remove woo breadcrumbs
    add_action( 'init','sv_remove_wc_breadcrumbs' );

    // Remove page title
    add_filter( 'woocommerce_show_page_title', 'sv_remove_page_title');

	// remove action wrap main content
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

    // Custom wrap main content
    add_action('woocommerce_before_main_content', 'sv_add_before_main_content', 10);
    add_action('woocommerce_after_main_content', 'sv_add_after_main_content', 10);

    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
   	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
   	remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
   	add_filter( 'woocommerce_product_single_add_to_cart_text', 'sv_custom_cart_button_text' ); 
    add_filter( 'woocommerce_product_add_to_cart_text', 'sv_custom_cart_button_text' );

    function sv_add_before_main_content() {
        $col_class = 'shop-width-'.sv_get_option('woo_shop_column',3);
        global $count_product;
        $count_product = 1;
        ?>
        <div id="main-content" class="content-shop <?php echo esc_attr($col_class);?>">
            <div class="container">            
        		<?php woocommerce_breadcrumb(array(
        			'delimiter'		=> '<span></span>',
        			'wrap_before'	=> '<div class="shop-breadcrumbs block block-breadcrumbs clearfix"><ul>',
        			'wrap_after'	=> '</ul></div>',
        			'before'		=> '<li>',
        			'after'			=> '<li>',
        			'home'			=> '<i class="fa fa-home"></i>'
        		)); ?>            	            
                <div class="row">
                	<?php sv_output_sidebar('left')?>
                	<div class="<?php echo esc_attr(sv_get_main_class()); ?>">
                        <?php sv_header_slider_shop();?>
                		<?php sv_header_filter_shop();?>
        <?php
    }

    function sv_add_after_main_content() {
        ?>
                	</div>
                	<?php sv_output_sidebar('right')?>
            	</div>
            </div>
        </div>
        <?php
    }

    function sv_remove_wc_breadcrumbs()
    {
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    }

    function sv_remove_page_title() {
        return false;
    }
	/********************************* END REMOVE ITEM MINICART AJAX *********************************/

	/********************************** FANCYBOX POPUP CONTENT ************************************/

	add_action( 'wp_ajax_product_popup_content', 'sv_product_popup_content' );
	add_action( 'wp_ajax_nopriv_product_popup_content', 'sv_product_popup_content' );
	if(!function_exists('sv_product_popup_content')){
		function sv_product_popup_content() {
			$product_id = $_POST['product_id'];
			$query = new WP_Query( array(
				'post_type' => 'product',
				'post__in' => array($product_id)
				));
			if( $query->have_posts() ):
				echo '<div class="woocommerce single-product product-popup-content"><div class="product has-sidebar">';
				while ( $query->have_posts() ) : $query->the_post();	
					global $post,$product,$woocommerce;
					sv_product_main_detai(true);
				endwhile;
				echo '</div></div>';
			endif;
			wp_reset_postdata();
		}
	}
	//Custom woo shop column
    add_filter( 'loop_shop_columns', 'sv_woo_shop_columns', 1, 10 );
    function sv_woo_shop_columns( $number_columns ) {
        $col = sv_get_option('woo_shop_column',4);
        return $col;
    }
    add_filter( 'loop_shop_per_page', 'sv_woo_shop_number', 20 );
    function sv_woo_shop_number( $number) {
        $col = sv_get_option('woo_shop_number',12);
        if(isset($_GET['number'])){
            $col = $_GET['number'];
        }
        return $col;
    }

    if(!function_exists('sv_custom_cart_button_text')){
    	function sv_custom_cart_button_text(){
    		return esc_html__( 'Buy', 'megastore' );
    	}
    }
    // Catalog mode
    add_filter( 'woocommerce_get_price_html', 'sv_change_price_html', 100, 2 );
    if(!function_exists('sv_change_price_html')){
        function sv_change_price_html($price, $product){
            // $price = str_replace('&ndash;', '<span class="slipt">&ndash;</span>', $price);
            $show_mode = s7upf_check_catelog_mode();
            $hide_price = sv_get_option('hide_price');
            if($show_mode == 'on' && $hide_price == 'on') $price = '';
            return $price;
        }
    }
    add_filter( 's7upf_tempalte_mini_cart', 's7upf_tempalte_mini_cart', 100, 2 );
    if(!function_exists('s7upf_tempalte_mini_cart')){
        function s7upf_tempalte_mini_cart($html){
            $show_mode = s7upf_check_catelog_mode();
            $hide_minicart = sv_get_option('hide_minicart');
            if($show_mode == 'on' && $hide_minicart == 'on') $html = '';
            return $html;
        }
    }
    add_filter( 'woocommerce_loop_add_to_cart_link', 's7upf_custom_add_to_cart_link' );
    if(!function_exists('s7upf_custom_add_to_cart_link')){
        function s7upf_custom_add_to_cart_link($content){
            $show_mode = s7upf_check_catelog_mode();
            if($show_mode == 'on') $content = '';
            return $content;
        }
    }
    add_action( 's7upf_template_single_add_to_cart', 'woocommerce_template_single_add_to_cart', 30 );
    add_action( 's7upf_template_single_add_to_cart', 's7upf_filter_single_add_to_cart', 20 );
    // Catalog mode function
    if(!function_exists('s7upf_check_catelog_mode')){
        function s7upf_check_catelog_mode(){
            $catelog_mode = sv_get_option('woo_catelog');
            $hide_other_page = sv_get_option('hide_other_page');
            $hide_detail = sv_get_option('hide_detail');
            $hide_admin = sv_get_option('hide_admin');
            $hide_shop = sv_get_option('hide_shop');
            $hide_price = sv_get_option('hide_price');
            $show_mode = 'off';
            if($catelog_mode == 'on'){
                if($hide_other_page == 'on' && !is_super_admin() && !is_shop() && !is_single()) $show_mode = 'on';
                if($hide_other_page == 'on' && $hide_admin == 'on' && is_super_admin() && !is_shop() && !is_single() ) $show_mode = 'on';
                if(is_shop()) {
                    if($hide_shop == 'on' && !is_super_admin()) $show_mode = 'on';
                    if($hide_shop == 'on' && $hide_admin == 'on' && is_super_admin()) $show_mode = 'on';
                }
                if(is_single()) {
                    if($hide_detail == 'on' && !is_super_admin()) $show_mode = 'on';
                    if($hide_detail == 'on' && $hide_admin == 'on' && is_super_admin()) $show_mode = 'on';
                }
            }
            return $show_mode;
        }
    }
    if(!function_exists('s7upf_filter_single_add_to_cart')){
        function s7upf_filter_single_add_to_cart(){
            $show_mode = s7upf_check_catelog_mode();
            if($show_mode == 'on'){
                remove_action( 's7upf_template_single_add_to_cart', 'woocommerce_template_single_add_to_cart', 30);
            }
        }
    }

    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
    //remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
    add_filter( 'yith_woocompare_remove_compare_link_by_cat', 's7upf_remove_compare_link', 30, 2 );
    if(!function_exists('s7upf_remove_compare_link')){
        function s7upf_remove_compare_link(){
            return true;
        }
    }

}