<?php

function medizco_import_files()
{
	return [
		[
			'import_file_name'           => esc_html__( 'Medical, Dental, SkinCare 3 style together', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/default/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/default/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/default/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/default/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/' ),
		],
		[
			'import_file_name'           => esc_html__( 'Child care', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_four/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_four/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_four/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/home_four/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/home-4/' ),
		],
		[
			'import_file_name'           => esc_html__( 'Specialist', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_five/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_five/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_five/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/home_five/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/home-5/' ),
		],
		[
			'import_file_name'           => esc_html__( 'Eye Specialist', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_six/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_six/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/home_six/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/home_six/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/home-6/' ),
		],
		[
			'import_file_name'           => esc_html__( 'Covid 19 One', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-one/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-one/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-one/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/covid_one/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/covid-one/' ),
		],
		[
			'import_file_name'           => esc_html__( 'Covid 19 Two', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-two/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-two/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/covid-two/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/covid_two/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/medizco/covid-two/' ),
		],
		[
			'import_file_name'           => esc_html__( 'RTL', 'medizco' ),
			'categories'                 => ['General'],
			'import_file_url'            => MEDIZCO_REMOTE_CONTENT . '/ocdi/rtl/content.xml',
			'import_widget_file_url'     => MEDIZCO_REMOTE_CONTENT . '/ocdi/rtl/widgets.wie',
			'import_customizer_file_url' => MEDIZCO_REMOTE_CONTENT . '/ocdi/rtl/customizer.dat',
			'import_preview_image_url'   => MEDIZCO_REMOTE_CONTENT . '/rtl/screenshot.png',
			'preview_url'                => esc_url( 'https://wp.xpeedstudio.com/rtl/medizco/' ),
		],
	];
}

add_filter( 'ocdi/import_files', 'medizco_import_files' );

/**
 * After Demo Content Import set the main manu and front page
 */
function medizco_after_import($selected_import)
{
	$main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

	if ($main_menu) {
		set_theme_mod('nav_menu_locations', [
			'primary' => $main_menu->term_id,
		]);
	}

	$front_page_title = isset($selected_import['import_file_name']) ? $selected_import['import_file_name'] : 'Home One';
	$front_page_id = get_page_by_title($front_page_title);
	$blog_page_id  = get_page_by_title('Blog');

	update_option('show_on_front', 'page');

	if( $front_page_id ) {
		update_option('page_on_front', $front_page_id->ID);
	}

	if( $blog_page_id ) {
		update_option('page_for_posts', $blog_page_id->ID);
	}

	// RevSlider import when importing the demo content.
	if ( class_exists( 'RevSliderSlider' ) ) {

		$slider_url_one = MEDIZCO_REMOTE_CONTENT . '/ocdi/slider/home-slider-0.zip';
		$slider_url_two = MEDIZCO_REMOTE_CONTENT . '/ocdi/slider/home-slider-01.zip';
		$slider_url_three = MEDIZCO_REMOTE_CONTENT . '/ocdi/slider/home-slider-02.zip';
		$slider_url_four = MEDIZCO_REMOTE_CONTENT . '/ocdi/slider/home-slider-03.zip';

		$sliders_array = array(
			download_url( $slider_url_one ),
			download_url( $slider_url_two ),
			download_url( $slider_url_three ),
			download_url( $slider_url_four )
		);

		$slider = new RevSlider();

		if(is_array( $sliders_array )) {
			foreach( $sliders_array as $filepath ) {
				$slider->importSliderFromPost( true, true, $filepath );
			}
		}
	}
}

add_action( 'pt-ocdi/after_import', 'medizco_after_import' );

function demo_license_content() {
	?>
	<div class="license-wrap">
		<h2 class="license-title"><?php esc_html_e( 'Please Activate Your License', 'medizco' ); ?></h2>
		<div class="license-desc">
			<div class="notice-icon">
				<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M8.27148 5.6001V9.80009" stroke="#FF7129" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
					<path d="M15.536 6.26402V11.736C15.536 12.632 15.056 13.464 14.28 13.92L9.52801 16.664C8.75201 17.112 7.792 17.112 7.008 16.664L2.256 13.92C1.48 13.472 1 12.64 1 11.736V6.26402C1 5.36802 1.48 4.53599 2.256 4.07999L7.008 1.336C7.784 0.888 8.74401 0.888 9.52801 1.336L14.28 4.07999C15.056 4.53599 15.536 5.36002 15.536 6.26402Z" stroke="#FF7129" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
					<path d="M8.27148 12.3599V12.4399" stroke="#FF7129" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
			</div>
			<p>
			<?php 
				echo medizco_kses('In order to get regular update, support and demo content, you must activate the theme license. Please  <a href="'. admin_url('themes.php?page=license') .'">Goto License Page</a> and activate the theme license as soon as possible.');
			?>
			</p>
		</div>
	</div>
	<?php
}

function set_license_menu() {
	if ( theme_is_valid_license() ) {
		return;
	}

	remove_submenu_page('themes.php', 'one-click-demo-import');
	$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';

	if ( 'one-click-demo-import' === $page ) {
		// wp_die('Sorry, you are not allowed to access this page', '');
		wp_redirect(admin_url("themes.php?page=license"));
	}

	add_submenu_page(
		'themes.php',
		'Import Demo Data',
		'Import Demo Data',
		'manage_options',
		'one-click-demo-import',
		'demo_license_content'
	);
}

add_action('admin_menu', 'set_license_menu', 999);
