jQuery(document).ready(function($) {
    var salesChart = null; // Declare salesChart here

    function fetchAndRenderChart(filter) {
        $.ajax({
            url: eddVendorSalesData.ajax_url,
            method: 'GET',
            data: {
                action: 'edd_vendor_sales_data',
                vendor_id: eddVendorSalesData.vendor_id,
                filter: filter
            },
            success: function(response) {
                console.log(response); // Debugging: log the response to ensure data is correct

                // Ensure values are numeric before formatting
                var totalEarnings = parseFloat(response.total_earnings);
                var totalSalesCount = parseInt(response.total_sales_count);
                var totalCommissions = parseFloat(response.total_commissions);
                var totalProductViews = parseInt(response.total_product_views);

                $('#edd-vendor-report-summary').html(
                    'Total Earnings: $' + totalEarnings.toFixed(2) + '<br>' +
                    'Total Sales: ' + totalSalesCount + '<br>' +
                    'Total Commissions: $' + totalCommissions.toFixed(2) + '<br>' +
                    'Total Product Views: ' + totalProductViews
                );

                if (response.data && response.data.length > 0) {
                    renderChart(response.data);
                } else {
                    renderEmptyChart();
                }
            }
        });
    }

    function renderChart(data) {
        var salesCanvas = document.getElementById('edd-vendor-sales-chart');
        if (salesCanvas && salesCanvas.getContext) {
            var salesCtx = salesCanvas.getContext('2d');
            var labels = [];
            var salesData = [];
            var commissionsData = [];
            var productViewsData = [];

            data.forEach(function(item) {
                labels.push(item.post_date);
                salesData.push(parseFloat(item.total_sales));
                commissionsData.push(parseFloat(item.commissions));
                productViewsData.push(parseFloat(item.total_views));
            });

            if (salesChart) {
                salesChart.destroy();
            }

            salesChart = new Chart(salesCtx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'Total Sales',
                            data: salesData,
                            borderColor: 'rgba(75, 192, 192, 1)',
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-1'
                        },
                        {
                            label: 'Total Commissions',
                            data: commissionsData,
                            borderColor: 'rgba(255, 159, 64, 1)',
                            backgroundColor: 'rgba(255, 159, 64, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-1'
                        },
                        {
                            label: 'Product Views',
                            data: productViewsData,
                            borderColor: 'rgba(153, 102, 255, 1)',
                            backgroundColor: 'rgba(153, 102, 255, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-2'
                        }
                    ]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            type: 'time',
                            time: {
                                unit: 'day',
                                tooltipFormat: 'MMM d, yyyy' // Correct date format
                            },
                            title: {
                                display: true,
                                text: 'Date'
                            }
                        },
                        'y-axis-1': {
                            type: 'linear',
                            position: 'left',
                            title: {
                                display: true,
                                text: 'Total Sales/Commissions'
                            }
                        },
                        'y-axis-2': {
                            type: 'linear',
                            position: 'right',
                            grid: {
                                drawOnChartArea: false
                            },
                            title: {
                                display: true,
                                text: 'Product Views'
                            }
                        }
                    }
                }
            });
        }
    }

    function renderEmptyChart() {
        var salesCanvas = document.getElementById('edd-vendor-sales-chart');
        if (salesCanvas && salesCanvas.getContext) {
            var salesCtx = salesCanvas.getContext('2d');
            var labels = [];
            var salesData = [];
            var commissionsData = [];
            var productViewsData = [];

            if (salesChart) {
                salesChart.destroy();
            }

            salesChart = new Chart(salesCtx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'Total Sales',
                            data: salesData,
                            borderColor: 'rgba(75, 192, 192, 1)',
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-1'
                        },
                        {
                            label: 'Total Commissions',
                            data: commissionsData,
                            borderColor: 'rgba(255, 159, 64, 1)',
                            backgroundColor: 'rgba(255, 159, 64, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-1'
                        },
                        {
                            label: 'Product Views',
                            data: productViewsData,
                            borderColor: 'rgba(153, 102, 255, 1)',
                            backgroundColor: 'rgba(153, 102, 255, 0.2)',
                            borderWidth: 2,
                            fill: false,
                            yAxisID: 'y-axis-2'
                        }
                    ]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            type: 'time',
                            time: {
                                unit: 'day',
                                tooltipFormat: 'MMM d, yyyy' // Correct date format
                            },
                            title: {
                                display: true,
                                text: 'Date'
                            }
                        },
                        'y-axis-1': {
                            type: 'linear',
                            position: 'left',
                            title: {
                                display: true,
                                text: 'Total Sales/Commissions'
                            }
                        },
                        'y-axis-2': {
                            type: 'linear',
                            position: 'right',
                            grid: {
                                drawOnChartArea: false
                            },
                            title: {
                                display: true,
                                text: 'Product Views'
                            }
                        }
                    }
                }
            });
        }
    }

    $('#edd-vendor-sales-filter').change(function() {
        var filter = $(this).val();
        fetchAndRenderChart(filter);
    });

    $('#refresh-graph').click(function() {
        var filter = $('#edd-vendor-sales-filter').val();
        fetchAndRenderChart(filter);
    });

    fetchAndRenderChart('total'); // Initial load
});
