<?php
class MayosisTemplateImporter {
    private static $instance = null;

    private function __construct() {
        add_action('admin_enqueue_scripts', [$this, 'mayosis_enqueue_admin_template_importer_scripts']);
        add_action('wp_ajax_mayosis_search_templates', [$this, 'mayosis_ajax_search_templates']);
        add_action('wp_ajax_mayosis_import_template', [$this, 'mayosis_ajax_import_template']);
        add_action('wp_ajax_mayosis_refresh_templates', [$this, 'mayosis_ajax_refresh_templates']);
        add_action('wp_ajax_mayosis_reset_templates', [$this, 'mayosis_ajax_reset_templates']);
        add_action('admin_menu', [$this, 'mayosis_add_template_importer_menu'], 999999);
        add_filter('upload_mimes', [$this, 'mayosis_enable_svg_uploads']);
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function mayosis_enable_svg_uploads($mime_types) {
        $mime_types['svg'] = 'image/svg+xml';
        return $mime_types;
    }

    public function mayosis_enqueue_admin_template_importer_scripts() {
        wp_enqueue_script('template-importer-admin', plugins_url('assets/js/template-importer-admin.js', __FILE__), array('jquery', 'masonry'), null, true);
        wp_localize_script('template-importer-admin', 'mayosistemplateImporter', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('template_importer_nonce')
        ));
        wp_enqueue_style('template-importer-admin', plugins_url('assets/css/template-importer-admin.css', __FILE__));
        
        // SweetAlert library
    wp_enqueue_script('sweetalert', 'https://cdn.jsdelivr.net/npm/sweetalert2@10', array('jquery'), null, true);
    wp_enqueue_style('sweetalert', 'https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css', array(), null);
    }

    public function mayosis_fetch_templates_from_demo_site() {
        if (class_exists('Easy_Digital_Downloads')) {
            $response = wp_remote_get('https://api.themepreview.xyz/mayosis/wp-json/custom/v1/templates');
        } elseif (class_exists('WooCommerce')) {
            $response = wp_remote_get('https://api.themepreview.xyz/mayosis/wp-json/custom/v1/wc-templates');
        } else {
            $response = wp_remote_get('https://api.themepreview.xyz/mayosis/wp-json/custom/v1/templates');
        }

        if (is_wp_error($response)) {
            error_log('Error fetching templates: ' . $response->get_error_message());
            return [];
        }

        $body = wp_remote_retrieve_body($response);
        $templates = json_decode($body, true);

        $templates = array_filter($templates, function($template) {
            return isset($template['type']) && $template['type'] !== 'kit';
        });

        return $templates;
    }

    public function mayosis_import_elementor_template($template_title, $template_content, $template_type) {
    if (!class_exists('Elementor\Plugin')) {
        error_log('Elementor is not active.');
        return false;
    }

    $data = json_decode($template_content, true);
    if (empty($data)) {
        error_log('Template content is empty or invalid.');
        return false;
    }

    
    $template_post = [
        'post_title' => $template_title . ' - Imported',
        'post_type' => 'elementor_library',
        'post_status' => 'publish',
        'meta_input' => [
            '_elementor_data' => json_encode($data),
            '_elementor_edit_mode' => 'builder',
            '_elementor_template_type' => $template_type,
            '_elementor_version' => ELEMENTOR_VERSION,
            '_elementor_page_settings' => [
                'elementor_disable_color_schemes' => 'yes',
                'elementor_disable_typography_schemes' => 'yes',
                'elementor_page_title' => 'hidden'
            ],
            '_wp_page_template' => 'elementor_header_footer'
        ],
    ];

    $post_id = wp_insert_post($template_post);

    if (is_wp_error($post_id)) {
        error_log('Error inserting template post: ' . $post_id->get_error_message());
        return false;
    }

    

    return get_post_meta($post_id, '_elementor_data', true);
}

    public function mayosis_ajax_search_templates() {
        check_ajax_referer('template_importer_nonce', 'nonce');

        $search_query = isset($_POST['search']) ? sanitize_text_field($_POST['search']) : '';
        $filter_type = isset($_POST['type']) ? sanitize_text_field($_POST['type']) : '';

        $templates = get_option('cached_templates', $this->mayosis_fetch_templates_from_demo_site());

        $filtered_templates = array_filter($templates, function ($template) use ($search_query, $filter_type) {
            $matches_search = empty($search_query) || stripos($template['name'], $search_query) !== false;
            $matches_type = empty($filter_type) || $template['type'] === $filter_type;
            return $matches_search && $matches_type;
        });

        if (empty($filtered_templates)) {
            wp_send_json_success(['templates' => '<p>No Template Found</p>']);
        } else {
            ob_start();
            foreach ($filtered_templates as $template) {
                echo '<div class="template-item">';
                echo '<input type="radio" name="template_id" value="' . esc_attr($template['id']) . '" id="template_' . esc_attr($template['id']) . '">';
                echo '<label for="template_' . esc_attr($template['id']) . '">';
                echo '<img src="' . esc_url($template['thumbnail']) . '" alt="' . esc_attr($template['name']) . '">';
                echo '<br><span class="msx_templ_type"> ' . esc_html(ucfirst($template['type'])) . '</span>';
                echo '<span class="msx_templ_title">' . esc_html($template['name']) . '</span>';
                
                echo '</label>';
                echo '</div>';
            }
            $templates_html = ob_get_clean();
            wp_send_json_success(['templates' => $templates_html]);
        }

        wp_die();
    }

    public function mayosis_ajax_import_template() {
        check_ajax_referer('template_importer_nonce', 'nonce');

        $template_id = isset($_POST['template_id']) ? intval($_POST['template_id']) : 0;

        $templates = get_option('cached_templates', $this->mayosis_fetch_templates_from_demo_site());
        $template_content = array_filter($templates, function ($template) use ($template_id) {
            return $template['id'] === $template_id;
        });

        if (!empty($template_content)) {
            $template_content = reset($template_content);
            $template_title = $template_content['name'];
            $template_data = $template_content['content'];
            $template_type = $template_content['type'];

            $imported_template = $this->mayosis_import_elementor_template($template_title, $template_data, $template_type);
            if ($imported_template) {
                wp_send_json_success(['content' => $imported_template]);
            }
        }

        wp_send_json_error();
    }

    public function mayosis_ajax_refresh_templates() {
        check_ajax_referer('template_importer_nonce', 'nonce');

        $templates = $this->mayosis_fetch_templates_from_demo_site();
        update_option('cached_templates', $templates);

        ob_start();
        foreach ($templates as $template) {
            echo '<div class="template-item">';
            echo '<input type="radio" name="template_id" value="' . esc_attr($template['id']) . '" id="template_' . esc_attr($template['id']) . '">';
            echo '<label for="template_' . esc_attr($template['id']) . '">';
            echo '<img src="' . esc_url($template['thumbnail']) . '" alt="' . esc_attr($template['name']) . '">';
            echo '<br><span class="msx_templ_type"> ' . esc_html(ucfirst($template['type'])) . '</span>';
                echo '<span class="msx_templ_title">' . esc_html($template['name']) . '</span>';
            echo '</label>';
            echo '</div>';
        }
        $templates_html = ob_get_clean();

        wp_send_json_success(['templates' => $templates_html]);
    }

    public function mayosis_ajax_reset_templates() {
        check_ajax_referer('template_importer_nonce', 'nonce');

        $templates = get_option('cached_templates', $this->mayosis_fetch_templates_from_demo_site());

        ob_start();
        foreach ($templates as $template) {
            echo '<div class="template-item">';
            echo '<input type="radio" name="template_id" value="' . esc_attr($template['id']) . '" id="template_' . esc_attr($template['id']) . '">';
            echo '<label for="template_' . esc_attr($template['id']) . '">';
            echo '<img src="' . esc_url($template['thumbnail']) . '" alt="' . esc_attr($template['name']) . '">';
            echo '<br><span class="msx_templ_type"> ' . esc_html(ucfirst($template['type'])) . '</span>';
                echo '<span class="msx_templ_title">' . esc_html($template['name']) . '</span>';
            echo '</label>';
            echo '</div>';
        }
        $templates_html = ob_get_clean();

        wp_send_json_success(['templates' => $templates_html]);
    }

    public function mayosis_render_template_importer_page() {
        $templates = get_option('cached_templates', $this->mayosis_fetch_templates_from_demo_site());

        echo '<div class="wrap mayosis_elementor_importer_wrap">';
        echo '<div class="mayosis_elementor_importer_header">';
        echo '<h1>Elementor Template Importer</h1>';
        echo '<button id="refresh-templates-button" class="button">Refresh Templates</button>';
        echo '</div>';
        echo '<form id="template-search-form">';
        echo '<input type="text" id="template-search" name="s" placeholder="Search templates...">';
        echo '<select id="template-type" name="type">';
        echo '<option value="">All Types</option>';
        echo '<option value="section">Section</option>';
        echo '<option value="page">Page</option>';
        echo '</select>';
        echo '<button type="submit" class="button">Search</button>';
        echo '<button id="reset-filters-button" type="button" class="button">Reset</button>';
        echo '</form>';
        echo '<div id="loader" style="display:none;">Loading...</div>';
         echo '<div id="loader2" style="display:none;">Importing...</div>';
        echo '<div class="template-grid">';
        foreach ($templates as $template) {
            echo '<div class="template-item">';
            echo '<input type="radio" name="template_id" value="' . esc_attr($template['id']) . '" id="template_' . esc_attr($template['id']) . '">';
            echo '<label for="template_' . esc_attr($template['id']) . '">';
            echo '<img src="' . esc_url($template['thumbnail']) . '" alt="' . esc_attr($template['name']) . '">';
           echo '<br><span class="msx_templ_type"> ' . esc_html(ucfirst($template['type'])) . '</span>';
                echo '<span class="msx_templ_title">' . esc_html($template['name']) . '</span>';
            echo '</label>';
            echo '</div>';
        }
        echo '</div>';
        echo '<button class="button import-template-button">Import Template</button>';
        echo '</div>';
    }

    public function mayosis_add_template_importer_menu() {
        add_submenu_page(
            'mayosis-admin-menu',
            'Template Importer',
            'Template Importer(beta)',
            'manage_options',
            'template-importer',
            [$this, 'mayosis_render_template_importer_page']
        );
    }

   
}

// Initialize the class
MayosisTemplateImporter::get_instance();



