jQuery(document).ready(function($) {
    // Initialize Masonry after the templates are loaded
    var $grid = $('.template-grid').masonry({
        itemSelector: '.template-item',
        columnWidth: '.template-item',
        percentPosition: true
    });

    function reloadMasonry() {
        $grid.masonry('reloadItems');
        $grid.masonry('layout');
    }

    // AJAX search
    $('#template-search-form').on('submit', function(e) {
        e.preventDefault();

        var searchQuery = $('#template-search').val();
        var filterType = $('#template-type').val();

        console.log('Searching templates:', searchQuery, filterType);

        $.ajax({
            url: mayosistemplateImporter.ajax_url,
            type: 'POST',
            data: {
                action: 'mayosis_search_templates',
                nonce: mayosistemplateImporter.nonce,
                search: searchQuery,
                type: filterType
            },
            beforeSend: function() {
                $('#loader').show();
            },
            success: function(response) {
                $('#loader').hide();
                console.log('Search response:', response);
                $('.template-grid').html(response.data.templates);
                reloadMasonry();
            }
        });
    });

    // Import template
    $(document).on('click', '.import-template-button', function(e) {
        e.preventDefault();

        var templateId = $('input[name="template_id"]:checked').val();

        if (!templateId) {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Please select a template to import.',
            });
            return;
        }

        console.log('Importing template:', templateId);

        $.ajax({
            url: mayosistemplateImporter.ajax_url,
            type: 'POST',
            data: {
                action: 'mayosis_import_template',
                nonce: mayosistemplateImporter.nonce,
                template_id: templateId
            },
            beforeSend: function() {
                $('#loader2').show();
            },
            success: function(response) {
                $('#loader2').hide();
                console.log('Import response:', response);
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Template imported successfully!',
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Failed to import template.',
                    });
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $('#loader2').hide();
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Failed to import template due to network error.',
                });
                console.log('Error:', textStatus, errorThrown);
            }
        });
    });

    // Refresh templates
    $(document).on('click', '#refresh-templates-button', function(e) {
        e.preventDefault();

        console.log('Refreshing templates');

        $.ajax({
            url: mayosistemplateImporter.ajax_url,
            type: 'POST',
            data: {
                action: 'mayosis_refresh_templates',
                nonce: mayosistemplateImporter.nonce
            },
            beforeSend: function() {
                $('#loader').show();
            },
            success: function(response) {
                $('#loader').hide();
                console.log('Refresh response:', response);
                if (response.success) {
                    $('.template-grid').html(response.data.templates);
                    reloadMasonry();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Failed to refresh templates.',
                    });
                }
            }
        });
    });

    // Reset search and filter
    $(document).on('click', '#reset-filters-button', function(e) {
        e.preventDefault();
        $('#template-search').val('');
        $('#template-type').val('');

        console.log('Resetting templates');

        $.ajax({
            url: mayosistemplateImporter.ajax_url,
            type: 'POST',
            data: {
                action: 'mayosis_reset_templates',
                nonce: mayosistemplateImporter.nonce
            },
            beforeSend: function() {
                $('#loader').show();
            },
            success: function(response) {
                $('#loader').hide();
                console.log('Reset response:', response);
                $('.template-grid').html(response.data.templates);
                reloadMasonry();
            }
        });
    });
});

jQuery(document).ready(function($) {
	function loadKeywords(page = 1, search = '') {
		$('#mayosisPsearchKeywordsTable').html('<p>' + mayosisPsearch.loadingMessage + '</p>');
		$.ajax({
			url: ajaxurl,
			method: 'POST',
			data: {
				action: 'mayosisPsearchGetKeywords',
				page: page,
				search: search
			},
			success: function(response) {
				$('#mayosisPsearchKeywordsTable').html(response.data.keywords_html);
			}
		});
	}

	$('#mayosisPsearchSearchInput').on('keyup', function() {
		loadKeywords(1, $(this).val());
	});

	$(document).on('click', '.pagination .page-numbers', function(e) {
		e.preventDefault();
		var page = $(this).data('page');
		loadKeywords(page, $('#mayosisPsearchSearchInput').val());
	});

	loadKeywords();
});
