<?php
/**
 * Add Custom Fields to Dokan Product Submission Form
 */

// Demo Link Field
add_action( 'dokan_new_product_after_product_tags', 'mayosis_dokan_demo_link_field', 10 );
add_action( 'dokan_product_edit_after_product_tags', 'mayosis_dokan_demo_link_field', 10, 2 );
function mayosis_dokan_demo_link_field( $post = null, $post_id = 0 ) {
    $value = $post_id ? get_post_meta( $post_id, 'woo_demo_link', true ) : '';
    ?>
    <div class="dokan-form-group">
        <label><?php esc_html_e( 'Demo Link', 'mayosis' ); ?></label>
        <input type="text" name="woo_demo_link" class="dokan-form-control" value="<?php echo esc_attr( $value ); ?>" placeholder="Enter Demo Link">
    </div>
    <?php
}

// Video Preview Field
add_action( 'dokan_new_product_after_product_tags', 'mayosis_dokan_video_upload_field', 20 );
add_action( 'dokan_product_edit_after_product_tags', 'mayosis_dokan_video_upload_field', 20, 2 );
function mayosis_dokan_video_upload_field( $post = null, $post_id = 0 ) {
    $value = $post_id ? get_post_meta( $post_id, 'woo_video_url', true ) : '';
    ?>
    <div class="dokan-form-group">
        <label><?php esc_html_e( 'Video Preview File', 'mayosis' ); ?></label>
        <div style="display: flex; gap: 10px; align-items: center;">
            <input type="text" name="woo_video_url" id="woo_video_url" class="dokan-form-control" value="<?php echo esc_attr( $value ); ?>" placeholder="Upload Video">
            <button type="button" class="button button-primary mayosis-upload-button" data-target="woo_video_url"><?php esc_html_e( 'Upload Video', 'mayosis' ); ?></button>
        </div>
    </div>
    <?php
}

// Audio Preview Field
add_action( 'dokan_new_product_after_product_tags', 'mayosis_dokan_audio_upload_field', 30 );
add_action( 'dokan_product_edit_after_product_tags', 'mayosis_dokan_audio_upload_field', 30, 2 );
function mayosis_dokan_audio_upload_field( $post = null, $post_id = 0 ) {
    $value = $post_id ? get_post_meta( $post_id, 'woo_audio_url', true ) : '';
    ?>
    <div class="dokan-form-group">
        <label><?php esc_html_e( 'Audio Preview File', 'mayosis' ); ?></label>
        <div style="display: flex; gap: 10px; align-items: center;">
            <input type="text" name="woo_audio_url" id="woo_audio_url" class="dokan-form-control" value="<?php echo esc_attr( $value ); ?>" placeholder="Upload Audio">
            <button type="button" class="button button-primary mayosis-upload-button" data-target="woo_audio_url"><?php esc_html_e( 'Upload Audio', 'mayosis' ); ?></button>
        </div>
    </div>
    <?php
}

// Generic Text Fields for Version, File Included, File Size, Compatible With, and Documentation
add_action( 'dokan_new_product_after_product_tags', 'mayosis_dokan_other_fields', 40 );
add_action( 'dokan_product_edit_after_product_tags', 'mayosis_dokan_other_fields', 40, 2 );
function mayosis_dokan_other_fields( $post = null, $post_id = 0 ) {
    $fields = array(
        'woo_product_version' => __( 'Version', 'mayosis' ),
        'woo_file_type'       => __( 'File Included', 'mayosis' ),
        'woo_file_size'       => __( 'File Size', 'mayosis' ),
        'woo_compatible_with' => __( 'Compatible With', 'mayosis' ),
        'woo_documentation'   => __( 'Documentation', 'mayosis' ),
    );

    foreach ( $fields as $key => $label ) {
        $value = $post_id ? get_post_meta( $post_id, $key, true ) : '';
        ?>
        <div class="dokan-form-group">
            <label><?php echo esc_html( $label ); ?></label>
            <input type="text" name="<?php echo esc_attr( $key ); ?>" class="dokan-form-control" value="<?php echo esc_attr( $value ); ?>" placeholder="<?php echo esc_attr( $label ); ?>">
        </div>
        <?php
    }
}

/**
 * Save Custom Fields When Adding or Updating Products
 */
add_action( 'dokan_new_product_added', 'mayosis_dokan_save_custom_fields', 10, 2 );
add_action( 'dokan_product_updated', 'mayosis_dokan_save_custom_fields', 10, 2 );
function mayosis_dokan_save_custom_fields( $product_id, $postdata ) {
    $fields = array(
        'woo_demo_link',
        'woo_video_url',
        'woo_audio_url',
        'woo_product_version',
        'woo_file_type',
        'woo_file_size',
        'woo_compatible_with',
        'woo_documentation',
    );

    foreach ( $fields as $key ) {
        if ( isset( $postdata[ $key ] ) ) {
            update_post_meta( $product_id, $key, sanitize_text_field( $postdata[ $key ] ) );
        }
    }
}

/**
 * Inline JavaScript for Media Uploader (Footer)
 */
add_action( 'wp_footer', 'mayosis_dokan_media_uploader_js' );
function mayosis_dokan_media_uploader_js() {
    if ( dokan_is_seller_dashboard() ) {
        wp_enqueue_media();
        ?>
        <script>
            jQuery(document).ready(function ($) {
                $('.mayosis-upload-button').on('click', function (e) {
                    e.preventDefault();

                    var targetField = $(this).data('target');
                    var fileFrame = wp.media({
                        title: 'Select or Upload File',
                        button: { text: 'Use this file' },
                        multiple: false
                    });

                    fileFrame.on('select', function () {
                        var attachment = fileFrame.state().get('selection').first().toJSON();
                        $('#' + targetField).val(attachment.url);
                    });

                    fileFrame.open();
                });
            });
        </script>
        <?php
    }
}
