<?php 

function teconce_audio_related_products($settings){ ?>

<?php 
global $post;
$mayosis_audio = get_post_meta($post->ID, 'audio_url', true);
$wavecolor = "#FB3C29";
$primaryopcitywave = mayosis_hexto_rgb($wavecolor, 0.25);
$feat_image = wp_get_attachment_url(get_post_thumbnail_id($post->ID));
$peakpath = plugins_url('/', __FILE__);
$recent_section_title = $settings['title'];
$listlayout = $settings['list_layout'];
$pstyle = $settings['product_style'];

$row = '';
$msvrowclass = match ($listlayout) {
    '2' => 'col-12 col-md-6',
    '3' => 'col-12 col-md-4',
    '4' => 'col-12 col-md-4',
    '5' => 'col',
    '6' => 'col-12 col-md-2',
    default => 'col-12 col-md-12'
};

?>
<style>
    .mayosis-normal-audio-player-msb .awp-player-wrap {
    display: flex
;
    flex-direction: row;
    flex-wrap: wrap;
    margin: 15px 0;
    margin: 15px 0;
    background: #262626;
    box-shadow: 0 1px 3px 0 rgb(0 0 0 / 10%), 0 1px 2px -1px rgb(0 0 0 / 10%);
    padding: 15px;
    border-radius: 5px;
}
.mayosis-normal-audio-player-msb .awp-player-thumb-wrapper {
    position: relative;
    width: 90px;
    height: 90px;
    background-color: #222;
    overflow: hidden;
    border-radius: 50%;
}
.mayosis-normal-audio-player-msb .awp-player-holder {
    position: relative;
    top: 0px;
    height: 90px;
    overflow: hidden;
    background-color: transparent;
    flex: 1;
}
.mayosis-normal-audio-player-msb .awp-waveform-wrap {
    position: relative;
    height: 100%;
}
.mayosis-normal-audio-player-msb .awp-media-time-total {
    position: absolute;
    right: 5px;
    bottom: 0;
    margin: 0 !important;
    padding: 3px !important;
    color: #222;
    font-size: 13px !important;
    width: auto;
    pointer-events: none;
}
.mayosis-normal-audio-player-msb .msb-ad-post-content {
    width: 100%;
    margin-top: 15px;
    border-top: 1px solid #f3f0f0;
    padding-top: 15px;
}
.mayosis-normal-audio-player-msb .product-audio-meta-titlebar h3 {
    margin-bottom: 0;
    font-size: 18px;
    line-height: 1.4;
}
.mayosis-normal-audio-player-msb .msb-alt-metas {
    margin-top: -3px;
    font-size: 14px;
}
.mayosis-normal-audio-player-msb .awp-playlist-holder{ 
    display:none !important;
}
.mayosis-normal-audio-player-msb .awp-playback-toggle{
    background:transparent !important;
}
.mayosis-normal-audio-player-msb .msb-inner-meta-price {
    text-align: right;
}
</style>
<div class="mayosis-normal-audio-player-msb">
    <div class="row">
        <?php 
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $term = get_the_terms($post->ID, 'download_category');
        $CatTerms = $term ? wp_list_pluck($term, 'slug') : [];
        
        $args = [
            'order' => 'DESC',
            'post_type' => 'download',
            'post__not_in' => [$post->ID],
            'posts_per_page' => 3
        ];
        
        $wp_query = new WP_Query($args);
        $player_data = [];
        
        if ($wp_query->have_posts()) :
            while ($wp_query->have_posts()) : $wp_query->the_post();
                $postidx = get_the_ID();
                $mayosis_audio = get_post_meta($postidx, 'audio_url', true);
                $featured_img_url = wp_get_attachment_image_src(get_post_thumbnail_id($postidx), 'mayosis-audio-list-thumbnail');  
                $author_id = get_the_author_meta('ID');
                $download_cats = get_the_term_list($postidx, 'download_category', '', ', ', '');
                $price = edd_get_download_price($postidx);
                
                if ($mayosis_audio) {
                    $player_data[] = [
                        'post_id' => $postidx,
                        'audio_url' => esc_url($mayosis_audio),
                        'image_url' => esc_url($featured_img_url[0]),
                    ];
                }
                ?>
               
        <div id="awp_player_archive<?php echo $postidx;?>" class="<?php echo $msvrowclass;?> mayosis-awp-player-box-msb">

            <div class="awp-player-wrap">

                <div class="awp-player-thumb-wrapper">
    			
        			<div class="awp-player-thumb"></div>

                    <div class="awp-playback-controls">

                        
            			
            			<div class="awp-playback-toggle awp-contr-btn">
                            <div class="awp-btn awp-btn-play">
                                <i class="fa fa-play"></i>
                            </div>
                            <div class="awp-btn awp-btn-pause">
                                <i class="fa fa-pause"></i>
                            </div>
                        </div>


                    </div>

                   

                </div>

                <div class="awp-player-holder">

                    <div class="awp-waveform-wrap">
                        <div class="awp-waveform awp-hidden"></div>  
                        <div class="awp-waveform-img awp-hidden"><!-- image waveform backup -->
                            <div class="awp-waveform-img-load"></div>
                            <div class="awp-waveform-img-progress-wrap"><div class="awp-waveform-img-progress"></div></div>
                        </div>
                        <span class="awp-waveform-preloader"></span>
                    </div>  

                    <div class="awp-media-time-total awp-hidden">0:00</div>
                    <div class="awp-media-time-current awp-hidden">0:00</div>
                    
                  

                </div>
                
                
                  <div class="msb-ad-post-content">
                      <div class="row">
                         <div class="product-audio-meta-titlebar col-12 col-md-8">
                            <h3><a href="<?php the_permalink();?>"><?php echo esc_html( get_the_title() );?></a></h3>
                            <div class="msb-alt-metas">
                            <span class="opacitydown75"><?php esc_html_e("by","mayosis"); ?></span> <a href="<?php echo mayosis_fes_author_url( get_the_author_meta( 'ID',$author_id ) ) ?>">


                <?php echo get_the_author_meta( 'display_name',$author_id);?>
            </a>
            <?php if ($download_cats){?>
             <span class="opacitydown75"><?php esc_html_e("in","mayosis"); ?></span> <span><?php echo '<span>' . $download_cats . '</span>'; ?></span>
            <?php } ?>
            </div>
                        </div>
                        <div class="col-12 col-md-4">
                            <div class="msb-inner-meta-price">
                    
                             
                                    <?php if( $price == "0.00"  ){ ?>
                                        <?php if ($productfreeoptins=='none'): ?>
                                            <span><?php edd_price(get_the_ID()); ?></span>
                                        <?php else: ?>
                                            <span><?php echo esc_html($productcustomtext); ?></span>
                                        <?php endif;?>
                    
                    
                                    <?php } else { ?>
                                        <div class="product-price promo_price"><?php edd_price(get_the_ID()); ?></div>
                                    <?php } ?>
                              
                    
                            </div>
                            </div>
                            </div>
                    </div>
                    

            </div>
              
            <div class="awp-playlist-holder">
                <div class="awp-playlist-filter-msg"><p>NOTHING FOUND!</p></div>
                <div class="awp-playlist-inner">
                    <div class="awp-playlist-content">
                        <!-- playlist items are appended here! --> 
                    </div>
                </div>
                
                <div class="awp-preloader"></div>

                

            </div>

          

          

            <div class="awp-tooltip"></div>
        
        </div>  



        <!-- PLAYLIST LIST -->
        <div id="awp-playlist-list-archive<?php echo $postidx;?>">

             <!-- audio playlist -->
             <div id="playlist-audio-archive<?php echo $postidx;?>">

          
                 
                 <div class="awp-playlist-item mayosis-plylist-list-style-mws" data-type="audio" data-mp3="<?php echo esc_url($mayosis_audio);?>" 
                 data-thumb="<?php echo $featured_img_url[0];?>"
                 >
                    <div class="product-audio-meta-fwall row align-items-center">
                       
                      
                        
                        <div class="mayosis-purchase-btn-audio col-md-3">
                                <?php echo  edd_get_purchase_link( array( 'download_id' => get_the_ID() ) );?>
                            </div>
                        
                        </div> 
                     
                 </div>
          
          
        
                
           

             </div>

        </div>    
            <?php endwhile; wp_reset_postdata(); ?>
            
            <?php
        // Now inject the JavaScript using the `$jsxarchive` variable
$jsxarchive = "<script type='text/javascript'>
jQuery(document).ready(function($){
    var playerData = " . json_encode($player_data) . ";

    playerData.forEach(function(item){
        var awp_player_archive = '#awp_player_archive' + item.post_id;
        
        var settings = {
            instanceName: 'defaultarhive' + item.post_id,
            sourcePath: '$peakpath',
            playlistList: '#awp-playlist-list-archive' + item.post_id,
            activePlaylist: '#playlist-audio-archive' + item.post_id,
            activeItem: 0,
            volume: 0.5,
            autoPlay: false,
            drawWaveWithoutLoad: false,
            randomPlay: false,
            loopingOn: true,
            autoAdvanceToNextMedia: false,
            mediaEndAction: 'pause',
            useKeyboardNavigationForPlayback: true,
            usePlaylistScroll: true,
            playlistScrollOrientation: 'vertical',
            playlistScrollTheme: 'light',
            useNumbersInPlaylist: true,
            wavesurfer: {
                waveColor: '$primaryopcitywave',
                progressColor: '$wavecolor',
                barWidth: 0,
                barRadius: 0,
                cursorColor: '#0000ff',
                cursorWidth: 0,
                height: 90,
                barGap: 0
            }
        };

        $(awp_player_archive).awp(settings);
    });

    // Handle AJAX Pagination
    $(document).on('click', '.pagination-link', function(event) {
        event.preventDefault();

        var pageUrl = $(this).attr('href');
        $('.row').fadeOut(200, function() {
            $(this).load(pageUrl + ' .row > *', function() {
                $(this).fadeIn(200);

                // Reinitialize all players after pagination
                playerData.forEach(function(item) {
                    var awp_player_archive = '#awp_player_archive' + item.post_id;
                    $(awp_player_archive).awp(settings);
                });
            });
        });

        window.history.pushState(null, null, pageUrl);
    });
});
</script>";

// Compress and output the script
echo mayosis_compress_js_lines($jsxarchive);
        ?>
        
       
        <?php else : ?>
            <h4 class="msv-no-p-title">No products Available in this category</h4>
        <?php endif; ?>
    </div>
    
    </div>

<?php }

function teconce_audio_related_shortcode($atts) {
    $default_settings = [
        'product_wave_color' => '#000000',
        'title' => 'Related Products',
        'list_layout' => '3',
        'product_style' => 'two'
    ];
    $settings = shortcode_atts($default_settings, $atts);
    ob_start();
    teconce_audio_related_products($settings);
    return ob_get_clean();
}
add_shortcode('teconce_audio_related', 'teconce_audio_related_shortcode');