<?php
// Prevent direct access
defined( 'ABSPATH' ) || exit;

// Allow only logged-in users (optional, but good practice for admin-only use)
// if ( ! is_user_logged_in() ) {
//     wp_send_json_error( 'Unauthorized access', 403 );
// }

if ( ! isset( $_POST['title'] ) || empty( $_POST['title'] ) ) {
    exit( 'Missing title.' );
}

if ( ! isset( $_POST['id'] ) || empty( $_POST['id'] ) ) {
    exit( 'Missing file URL.' );
}

$title = sanitize_file_name( wp_unslash( $_POST['title'] ) );
$url   = esc_url_raw( wp_unslash( $_POST['id'] ) );

// Only allow MP3 URLs
if ( ! preg_match( '/\.mp3$/i', $url ) ) {
    exit( 'Only MP3 files are allowed.' );
}

// Restrict to safe directories
$upload_dir = wp_upload_dir();
$target_dir = trailingslashit( $upload_dir['basedir'] ) . 'wave-audio/peaks/';
wp_mkdir_p( $target_dir );

$path = $target_dir . $title . '.mp3';

// Perform the download
if ( downloadFile( $url, $path ) ) {
    $file_url = trailingslashit( $upload_dir['baseurl'] ) . 'wave-audio/peaks/' . $title . '.mp3';
    wp_send_json_success( esc_url_raw( $file_url ) );
} else {
    wp_send_json_error( 'Download failed.' );
}

function downloadFile( $url, $path ) {
    $file = fopen( $url, 'rb' );
    if ( ! $file ) {
        return false;
    }

    $newf = fopen( $path, 'wb' );
    if ( ! $newf ) {
        fclose( $file );
        return false;
    }

    while ( ! feof( $file ) ) {
        fwrite( $newf, fread( $file, 1024 * 8 ), 1024 * 8 );
    }

    fclose( $file );
    fclose( $newf );

    return true;
}
