<?php
/**
 * Admin License & Update Page (Mayosis submenu)
 * - Places page under 'mayosis-admin-menu' if present; otherwise under Settings.
 * - Uses proper sanitization and escaping.
 * - Keeps CSRF protection with nonces.
 *
 * @package Mayosis
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register License page under Mayosis parent menu.
 * Falls back to Settings if parent isn't found.
 */
add_action( 'admin_menu', 'teconce_register_license_page', 20 );
function teconce_register_license_page() {
	$parent_slug = 'mayosis-admin-menu'; // Mayosis main menu slug.
	$page_title  = __( 'License & Updates', 'mayosis' );
	$menu_title  = __( 'License & Updates', 'mayosis' );
	$capability  = 'manage_options';
	$menu_slug   = 'licensebox-test';
	$callback    = 'licensebox_test_plugin_page';

	// If Mayosis parent exists, add as submenu; else fallback to Settings.
	if ( teconce_admin_menu_exists( $parent_slug ) ) {
		add_submenu_page( $parent_slug, $page_title, $menu_title, $capability, $menu_slug, $callback );
	} else {
		add_options_page( $page_title, $menu_title, $capability, $menu_slug, $callback );
	}
}

/**
 * Check if a top-level admin menu with a given slug exists.
 *
 * @param string $slug Menu slug.
 * @return bool
 */
function teconce_admin_menu_exists( $slug ) {
	global $menu;

	if ( empty( $menu ) || ! is_array( $menu ) ) {
		return false;
	}
	foreach ( $menu as $item ) {
		// $item[2] holds the slug.
		if ( isset( $item[2] ) && $item[2] === $slug ) {
			return true;
		}
	}
	return false;
}

/**
 * Render the License & Updates admin page.
 * Assumes a global $lbapi with LicenseBoxExternalAPI-like methods.
 */
function licensebox_test_plugin_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'mayosis' ) );
	}

	// Ensure $lbapi is available (fallback instantiation if needed).
	global $lbapi;
	if ( ! isset( $lbapi ) || ! is_object( $lbapi ) ) {
		if ( class_exists( 'LicenseBoxExternalAPI' ) ) {
			$lbapi = new LicenseBoxExternalAPI();
		} else {
			echo '<div class="notice notice-error"><p>' . esc_html__( 'License API class not found.', 'mayosis' ) . '</p></div>';
			return;
		}
	}

	// Initialize state.
	$lb_activate_res   = null;
	$lb_deactivate_res = null;

	// Always have a verification snapshot to use for UI.
	$lb_verify_res = $lbapi->verify_license();

	// Handle activation.
	if ( ! empty( $_POST['client_name'] ) && ! empty( $_POST['license_code'] ) ) {
		check_admin_referer( 'lb_update_license', 'lb_update_license_sec' );

		$license_code = sanitize_text_field( wp_unslash( (string) $_POST['license_code'] ) );
		$client_name  = sanitize_text_field( wp_unslash( (string) $_POST['client_name'] ) );

		$lb_activate_res = $lbapi->activate_license( $license_code, $client_name );
		$lb_verify_res   = $lbapi->verify_license();
	}

	// Handle deactivation.
	if ( ! empty( $_POST['lb_deactivate'] ) ) {
		check_admin_referer( 'lb_deactivate_license', 'lb_deactivate_license_sec' );

		$lb_deactivate_res = $lbapi->deactivate_license();
		$lb_verify_res     = $lbapi->verify_license();
	}

	// Update check (do not rely on transient; the download step clears it).
	$lb_update_data = $lbapi->check_update();

	// Handle update download/install.
	if ( ! empty( $_POST['update_id'] ) ) {
		check_admin_referer( 'lb_update_download', 'lb_update_download_sec' );

		$update_id = sanitize_text_field( wp_unslash( (string) $_POST['update_id'] ) );
		$has_sql   = sanitize_text_field( wp_unslash( (string) $_POST['has_sql'] ) );
		$version   = sanitize_text_field( wp_unslash( (string) $_POST['version'] ) );

		$lbapi->download_update( $update_id, $has_sql, $version );

		// Force next update check fresh.
		if ( false !== get_transient( 'licensebox_next_update_check' ) ) {
			delete_transient( 'licensebox_next_update_check' );
		}

		// Refresh update info for UI.
		$lb_update_data = $lbapi->check_update();
	}

	// UI starts.
	?>
	<div class="wrap about-wrap mayosis-wrap">
	    	<?php $mayosistheme = wp_get_theme(); ?>
	     <h1><?php _e( 'Welcome to Mayosis', 'mayosis-core' ); ?></h1>

    <div class="about-text"><?php echo esc_html__( 'mayosis theme is now installed and ready to use!', 'mayosis-core' ); ?></div>
<div class="mayosis-badge">
 <img src="<?php echo MAYOSIS_THEMEPATH .'/images/icon.svg'; ?>" alt="mayosis admin logo">
    
    <p><?php echo esc_html($mayosistheme->get( 'Version' )); ?></p>
</div>


		 <h2 class="nav-tab-wrapper">
        <?php
        printf( '<a href="admin.php?page=mayosis-admin-menu" class="nav-tab">%s</a>', __( 'Welcome', 'mayosis-core' ) );
        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'customize.php' ), __( 'Theme Options', 'mayosis-core' ) );
         printf( '<a href="admin.php?page=mayosis" class="nav-tab nav-tab-active">%s</a>', __( 'License', 'mayosis-core' ) );
       
        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=mayosis-wizard&step=content' ), __( 'Demo Import', 'mayosis-core' ) );
        
        printf( '<a href="admin.php?page=mayosis-recommandation" class="nav-tab">%s</a>', __( 'Recommandations', 'mayosis-core' ) );
        ?>
    </h2>
    
		<h4 class="lcs_title_box"><?php echo esc_html__( 'License & Updates', 'mayosis' ); ?></h4>

		<?php if ( ! empty( $lb_activate_res ) && isset( $lb_activate_res['message'] ) ) : ?>
			<div class="notice notice-info"><p><?php echo esc_html( (string) $lb_activate_res['message'] ); ?></p></div>
		<?php endif; ?>

		<?php if ( isset( $lb_verify_res['status'] ) && $lb_verify_res['status'] ) : ?>
			<div class="notice notice-success"><p><?php echo esc_html__( 'Activated! Your license is valid.', 'mayosis' ); ?></p></div>
		<?php else : ?>
			<div class="notice notice-error">
				<p>
				<?php
				$msg = ( ! empty( $lb_activate_res['message'] ) ) ? (string) $lb_activate_res['message'] : __( 'No license has been provided yet or the provided license is invalid.', 'mayosis' );
				echo esc_html( $msg );
				?>
				</p>
			</div>
		<?php endif; ?>

<?php if ( empty( $lb_verify_res['status'] ) || ! $lb_verify_res['status'] ) : ?>
 <div class="lb_dfg_form">
	<form action="" method="post">
		<?php wp_nonce_field( 'lb_update_license', 'lb_update_license_sec' ); ?>

		<div class="form-group">
			<label for="lb_license_code"><?php esc_html_e( 'License code', 'mayosis' ); ?></label>
			<?php
			$lc_placeholder = ( isset( $lb_verify_res['status'] ) && $lb_verify_res['status'] )
				? __( 'Enter the license code here to update', 'mayosis' )
				: __( 'Enter the license code here', 'mayosis' );
			?>
			<input type="text" id="lb_license_code" name="license_code" class="regular-text" placeholder="<?php echo esc_attr( $lc_placeholder ); ?>" required />
		</div>

		<div class="form-group">
			<label for="lb_client_name"><?php esc_html_e( 'Your name', 'mayosis' ); ?></label>
			<?php
			$nm_placeholder = ( isset( $lb_verify_res['status'] ) && $lb_verify_res['status'] )
				? __( 'Enter your Envato username /licensee\'s name here to update', 'mayosis' )
				: __( 'Enter your  Envato username/licensee\'s name here', 'mayosis' );
			?>
			<input type="text" id="lb_client_name" name="client_name" class="regular-text" placeholder="<?php echo esc_attr( $nm_placeholder ); ?>" required />
		</div>

		<p><input type="submit" class="button button-primary" value="<?php echo esc_attr__( 'Activate', 'mayosis' ); ?>" /></p>
	</form>
</div>

<?php endif;?>
		<?php if ( isset( $lb_verify_res['status'] ) && $lb_verify_res['status'] ) : ?>
		<div class="lb_deac_theme">
			<h2 class="title"><?php echo esc_html__( 'Deactivate License', 'mayosis' ); ?></h2>
			<p style="max-width: 450px;"><?php echo esc_html__( 'If you wish to use this license on a different server, first release it by deactivating below.', 'mayosis' ); ?></p>

			<?php if ( empty( $lb_deactivate_res ) ) : ?>
				<form action="" method="post">
					<?php wp_nonce_field( 'lb_deactivate_license', 'lb_deactivate_license_sec' ); ?>
					<input type="hidden" name="lb_deactivate" value="yes" />
					<input type="submit" class="button" value="<?php echo esc_attr__( 'Deactivate', 'mayosis' ); ?>" />
				</form>
			<?php endif; ?>
			
			</div>
			
			<div class="lb_mpd_theme">

			<h2 class="title" style="padding-top:10px;"><?php echo esc_html__( 'Theme Updates', 'mayosis' ); ?></h2>

			<?php if ( isset( $lb_update_data['message'] ) ) : ?>
				<p><strong><?php echo esc_html( (string) $lb_update_data['message'] ); ?></strong></p>
			<?php endif; ?>

			<?php if ( ! empty( $lb_update_data['status'] ) ) : ?>
				<?php
				// Allow safe HTML in changelog.
				$allowed_tags = array(
					'ol'        => array(),
					'ul'        => array(),
					'li'        => array(),
					'i'         => array(),
					'b'         => array(),
					'strong'    => array(),
					'p'         => array(),
					'br'        => array(),
					'blockquote'=> array(),
					'a'         => array(
						'href'   => array(),
						'target' => array(),
						'rel'    => array(),
					),
				);
				?>
				<p style="max-width: 700px;">
					<?php
					echo wp_kses( (string) $lb_update_data['changelog'], $allowed_tags );
					?>
				</p>

				<form action="" method="post">
					<?php wp_nonce_field( 'lb_update_download', 'lb_update_download_sec' ); ?>
					<input type="hidden" name="update_id" value="<?php echo isset( $lb_update_data['update_id'] ) ? esc_attr( (string) $lb_update_data['update_id'] ) : ''; ?>" />
					<input type="hidden" name="has_sql" value="<?php echo isset( $lb_update_data['has_sql'] ) ? esc_attr( (string) $lb_update_data['has_sql'] ) : ''; ?>" />
					<input type="hidden" name="version" value="<?php echo isset( $lb_update_data['version'] ) ? esc_attr( (string) $lb_update_data['version'] ) : ''; ?>" />
					<p><input type="submit" class="button button-secondary" value="<?php echo esc_attr__( 'Download and Install Update', 'mayosis' ); ?>" /></p>
				</form>
			<?php endif; ?>
			</div>
		<?php endif; ?>

		
		
	</div>
	<?php
}


