<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

function search_plugin_scripts_styles(){
    if (class_exists("Woocommerce")) {
        wp_register_script( 'mayosis-ajax-search', plugins_url('/js/mayosis-ajax-search.js', __FILE__ ), array('jquery'), '', true);
        wp_localize_script(
            'mayosis-ajax-search',
            'opt',
            array(
                'ajaxUrl'   => admin_url('admin-ajax.php'),
                'noResults' => esc_html__( 'No products found', 'mayosis' ),
            )
        );
    }
}
add_action( 'wp_enqueue_scripts', 'search_plugin_scripts_styles' );

/*  Get taxonomy hierarchy
/*-------------------*/

    function get_taxonomy_hierarchy( $taxonomy, $parent = 0, $exclude = 0) {
        $taxonomy = is_array( $taxonomy ) ? array_shift( $taxonomy ) : $taxonomy;
        $terms = get_terms( $taxonomy, array( 'parent' => $parent, 'hide_empty' => false, 'exclude' => $exclude) );

        $children = array();
        foreach ( $terms as $term ){
            $term->children = get_taxonomy_hierarchy( $taxonomy, $term->term_id, $exclude);
            $children[ $term->term_id ] = $term;
        }
        return $children;
    }

/*  List taxonomy hierarchy
/*-------------------*/

    function list_taxonomy_hierarchy_no_instance( $taxonomies) {
    ?>
        <?php foreach ( $taxonomies as $taxonomy ) { ?>
            <?php $children = $taxonomy->children; ?>
            <option value="<?php echo $taxonomy->term_id; ?>"><?php echo $taxonomy->name; ?></option>
            <?php if (is_array($children) && !empty($children)): ?>
                <optgroup>
                    <?php list_taxonomy_hierarchy_no_instance($children); ?>
                </optgroup>
            <?php endif ?>
        <?php } ?>

    <?php
    }

/*  Product categories transient
/*-------------------*/

    function get_product_categories_hierarchy() {

        if ( false === ( $categories = get_transient( 'product-categories-hierarchy' ) ) ) {

            $categories = get_taxonomy_hierarchy( 'product_cat', 0, 0);

            // do not set an empty transient - should help catch private or empty accounts.
            if ( ! empty( $categories ) ) {
                $categories = base64_encode( serialize( $categories ) );
                set_transient( 'product-categories-hierarchy', $categories, apply_filters( 'null_categories_cache_time', 0 ) );
            }
        }

        if ( ! empty( $categories ) ) {

            return unserialize( base64_decode( $categories ) );

        } else {

            return new WP_Error( 'no_categories', esc_html__( 'No categories.', 'mayosis' ) );

        }
    }

/*  Delete product categories transient
/*-------------------*/

    function edit_product_term($term_id, $tt_id, $taxonomy) {
        $term = get_term($term_id,$taxonomy);
        if (!is_wp_error($term) && is_object($term)) {
            $taxonomy = $term->taxonomy;
            if ($taxonomy == "product_cat") {
                delete_transient( 'product-categories-hierarchy' );
            }
        }
    }

    function delete_product_term($term_id, $tt_id, $taxonomy, $deleted_term) {
        if (!is_wp_error($deleted_term) && is_object($deleted_term)) {
            $taxonomy = $deleted_term->taxonomy;
            if ($taxonomy == "product_cat") {
                delete_transient( 'product-categories-hierarchy' );
            }
        }
    }
    add_action( 'create_term', 'edit_product_term', 99, 3 );
    add_action( 'edit_term', 'edit_product_term', 99, 3 );
    add_action( 'delete_term', 'delete_product_term', 99, 4 );

    add_action( 'save_post', 'save_post_action', 99, 3);
    function save_post_action( $post_id ){

        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
        if (!current_user_can( 'edit_page', $post_id ) ) return;

        $post_info = get_post($post_id);

        if (!is_wp_error($post_info) && is_object($post_info)) {
            $content   = $post_info->post_content;
            $post_type = $post_info->post_type;

            if ($post_type == "product"){
                delete_transient( 'enovathemes-product-categories' );
            }
        }

    }

/*  Search action
/*-------------------*/

    function search_product() {
    if ( isset( $_POST['keyword'] ) && ! empty( $_POST['keyword'] ) ) {
        $keyword  = sanitize_text_field( $_POST['keyword'] );
        $category = isset( $_POST['category'] ) ? absint( $_POST['category'] ) : '';

        $args = [
            'post_type'      => 'product',
            'post_status'    => 'publish',
            'posts_per_page' => 12,
            's'              => $keyword,
        ];

        if ( ! empty( $category ) ) {
            $args['tax_query'] = [
                [
                    'taxonomy'         => 'product_cat',
                    'field'            => 'term_id',
                    'terms'            => $category,
                    'include_children' => true,
                ],
            ];
        }

        $query = new WP_Query( $args );

        if ( $query->have_posts() ) {
            $spstyle = get_theme_mod( 'search_product_style_woo', 'list' );
            $pcol    = get_theme_mod( 'search_product_grid_count_woo', '3' );

            $spgrid = ( $spstyle === 'list' ) ? 'mayosis-ajax-list-search' : 'mayosis-ajax-grid-search row row-cols-1 row-cols-md-' . esc_attr( $pcol );
            $spli   = ( $spstyle === 'list' ) ? '' : 'col';

            $output = '<ul class="' . esc_attr( $spgrid ) . '">';

            while ( $query->have_posts() ) {
                $query->the_post();
                $product = wc_get_product( get_the_ID() );

                $output .= '<li class="' . esc_attr( $spli ) . '">';
                $output .= '<div class="mayosis-ajax-product-image">';
                $output .= '<a href="' . esc_url( get_permalink() ) . '">';
                $output .= get_the_post_thumbnail( get_the_ID(), 'full' );
                $output .= '</a></div>';

                $output .= '<div class="mayosis-ajax-product-data">';
                $output .= '<div class="mayosis-ajax-category-data">' . wc_get_product_category_list( get_the_ID() ) . '</div>';
                $output .= '<h3><a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a></h3>';
                $output .= '<div class="mayosis-ajax-product-price">' . wp_kses_post( $product->get_price_html() ) . '</div>';
                $output .= '</div></li>';
            }

            wp_reset_postdata();
            $output .= '</ul>';

            echo $output;
        }
    }

    wp_die();
}

    add_action( 'wp_ajax_search_product', 'search_product' );
    add_action( 'wp_ajax_nopriv_search_product', 'search_product' );

/*  Widget
/*-------------------*/

   function mayosis_live_search() {

    		wp_enqueue_script('mayosis-ajax-search');
                $catfilter = get_theme_mod('search_category_ds','show');
                $search_style_ds = get_theme_mod('search_style_ds', 'one');
                $search_placeholder= get_theme_mod('search_woo_placeholder_m', 'Search for Product...');
                
                
               if ($catfilter=="show"){
                   $catfilcls="mayosis-filter-available";
               } else {
               $catfilcls="mayosis-filter-not-available";
               }
               
                ?>

    			<div class="product-search <?php echo esc_html($catfilcls);?> mayosis-search-style-<?php echo esc_html($search_style_ds);?>">
    				<form name="product-search" method="get" class="mayosis-search-box" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    				    <?php if ($catfilter=="show"){?>
                        <?php $categories = get_product_categories_hierarchy(); ?>
                        <?php if ($categories): ?>
                        <div class="mayosis-ajax-search-bar category-wrapper d-none">
                            <select name="category" class="category">
                                <option class="default" value=""><?php echo esc_html__( 'All Categories', 'mayosis' ); ?></option>
                                <?php list_taxonomy_hierarchy_no_instance( $categories); ?>
                            </select>
                        </div>
                        <?php endif ?>
                        <?php } ?>
                        <div class="search-wrapper">
                            <input type="text" name="s" class="search" placeholder="<?php echo $search_placeholder; ?>" value="<?php the_search_query(); ?>">
                         
                           <button type="submit" value="Search" class="mayosis-ajax-search-btn">
                          <i class="isax icon-search-normal-11"></i>
                            <input type="hidden" name="post_type" value="product" />
                        </button> 
                            
                        </div>
    	            </form>
                    <div class="search-results mayosis-search-result"></div>
        		</div>

    		<?php
    	}
    	
    	
    	
    	function mayosis_live_search_elementor($settings) {

    		wp_enqueue_script('mayosis-ajax-search');
                $catfilter = $settings['ebl_search_filter'];
                $search_style_ds = $settings['search-style'];
                $search_placeholder= $settings['placeholder_text'];
                
                
               if ($catfilter=="enable"){
                   $catfilcls="mayosis-filter-available";
               } else {
               $catfilcls="mayosis-filter-not-available";
               }
               
                ?>

    			<div class="product-search <?php echo esc_html($catfilcls);?> mayosis-search-style-<?php echo esc_html($search_style_ds);?>">
    				<form name="product-search" method="get" class="mayosis-search-box" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    				    <?php if ($catfilter=="enable"){?>
                        <?php $categories = get_product_categories_hierarchy(); ?>
                        <?php if ($categories): ?>
                        <div class="mayosis-ajax-search-bar category-wrapper">
                            <select name="category" class="category">
                                <option class="default" value=""><?php echo esc_html__( 'All Categories', 'mayosis' ); ?></option>
                                <?php list_taxonomy_hierarchy_no_instance( $categories); ?>
                            </select>
                        </div>
                        <?php endif ?>
                        <?php } ?>
                        <div class="search-wrapper">
                            <input type="text" name="s" class="search" placeholder="<?php echo $search_placeholder; ?>" value="<?php the_search_query(); ?>">
                         
                           <button type="submit" value="Search" class="mayosis-ajax-search-btn">
                          <i class="isax icon-search-normal-11"></i>
                            <input type="hidden" name="post_type" value="product" />
                        </button> 
                           
                        </div>
    	            </form>
                    <div class="search-results mayosis-search-result"></div>
        		</div>

    		<?php
    	}
?>
