<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

class Mayosis_MBW_LRB_Auth {
    
    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'mayosis_mbw_lrb_enqueue_scripts'));
        add_action('wp_ajax_nopriv_mayosis_mbw_lrb_ajax_login', array($this, 'mayosis_mbw_lrb_ajax_login'));
        add_action('wp_ajax_nopriv_mayosis_mbw_lrb_ajax_register', array($this, 'mayosis_mbw_lrb_ajax_register'));
        add_action('wp_ajax_nopriv_mayosis_mbw_lrb_ajax_lost_password', array($this, 'mayosis_mbw_lrb_ajax_lost_password'));
        add_shortcode('mayosis_mbw_lrb_login_form', array($this, 'mayosis_mbw_lrb_login_form_shortcode'));
        add_shortcode('mayosis_mbw_lrb_register_form', array($this, 'mayosis_mbw_lrb_register_form_shortcode'));
        add_shortcode('mayosis_mbw_lrb_lost_password_form', array($this, 'mayosis_mbw_lrb_lost_password_form_shortcode'));
    }
    
    public function mayosis_mbw_lrb_enqueue_scripts() {
        wp_enqueue_script('jquery');
        wp_enqueue_script('mayosis-mbw-lrb-ajax-auth', plugin_dir_url(__FILE__) . 'js/mayosis-mbw-lrb-ajax-auth.js', array('jquery'), '1.0', true);
        wp_localize_script('mayosis-mbw-lrb-ajax-auth', 'mayosis_mbw_lrb_ajax_auth', array('ajax_url' => admin_url('admin-ajax.php')));
    }
    
    public function mayosis_mbw_lrb_ajax_login() {
        check_ajax_referer('mayosis_mbw_lrb_ajax_login_nonce', 'security');

        $info = array();
        $info['user_login'] = $_POST['username'];
        $info['user_password'] = $_POST['password'];
        $info['remember'] = true;

        $user_signon = wp_signon($info, false);
        if (is_wp_error($user_signon)) {
            echo json_encode(array('loggedin' => false, 'message' => __('Wrong username or password.')));
        } else {
            $redirect_url = get_user_meta($user_signon->ID, 'mayosis-mbw-login-redirection', true);
            $redirect_url = $redirect_url ? $redirect_url : home_url();
            echo json_encode(array('loggedin' => true, 'message' => __('Login successful, redirecting...'), 'redirect' => $redirect_url));
        }

        wp_die();
    }

    public function mayosis_mbw_lrb_ajax_register() {
        check_ajax_referer('mayosis_mbw_lrb_ajax_register_nonce', 'security');

        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];
        
        if ($password !== $confirm_password) {
            echo json_encode(array('registered' => false, 'message' => __('Passwords do not match.')));
            wp_die();
        }

        $info = array();
        $info['user_login'] = $_POST['username'];
        $info['user_email'] = $_POST['email'];
        $info['user_pass'] = $password;

        $user_register = wp_insert_user($info);
        if (is_wp_error($user_register)) {
            echo json_encode(array('registered' => false, 'message' => $user_register->get_error_message()));
        } else {
            wp_set_current_user($user_register);
            wp_set_auth_cookie($user_register);
            $redirect_url = get_user_meta($user_register, 'mayosis-mbw-login-redirection', true);
            $redirect_url = $redirect_url ? $redirect_url : home_url();
            echo json_encode(array('registered' => true, 'message' => __('Registration complete, redirecting...'), 'redirect' => $redirect_url));
        }

        wp_die();
    }

    public function mayosis_mbw_lrb_ajax_lost_password() {
        check_ajax_referer('mayosis_mbw_lrb_ajax_lost_password_nonce', 'security');

        $email = $_POST['email'];
        if (empty($email)) {
            echo json_encode(array('reset' => false, 'message' => __('Please enter an email address.')));
            wp_die();
        }

        $user = get_user_by('email', $email);
        if (!$user) {
            echo json_encode(array('reset' => false, 'message' => __('No user found with that email address.')));
            wp_die();
        }

        $reset_key = get_password_reset_key($user);
        if (is_wp_error($reset_key)) {
            echo json_encode(array('reset' => false, 'message' => __('Failed to generate reset key.')));
            wp_die();
        }

        $reset_url = network_site_url("wp-login.php?action=rp&key=$reset_key&login=" . rawurlencode($user->user_login), 'login');
        $message = "Someone has requested a password reset for the following account:\n\n";
        $message .= "Site Name: " . get_bloginfo('name') . "\n\n";
        $message .= "Username: " . $user->user_login . "\n\n";
        $message .= "If this was a mistake, just ignore this email and nothing will happen.\n\n";
        $message .= "To reset your password, visit the following address:\n\n";
        $message .= $reset_url . "\n\n";

        $headers = array('Content-Type: text/plain; charset=UTF-8');

        if (wp_mail($email, 'Password Reset Request', $message, $headers)) {
            echo json_encode(array('reset' => true, 'message' => __('Password reset email sent.')));
        } else {
            echo json_encode(array('reset' => false, 'message' => __('Failed to send password reset email.')));
        }

        wp_die();
    }

    public function mayosis_mbw_lrb_login_form_shortcode() {
        ob_start();
        ?>
        <form id="mayosis_mbw_lrb_login_form" action="" method="post">
           
            <input type="text" name="username" id="mayosis_mbw_lrb_login_username" placeholder="<?php esc_html_e('Username','mayosis-core');?>" required>
            
            
            <input type="password" name="password" id="mayosis_mbw_lrb_login_password" placeholder="<?php esc_html_e('Password','mayosis-core');?>" required>
            
            <input type="hidden" name="security" id="mayosis_mbw_lrb_login_security" value="<?php echo wp_create_nonce('mayosis_mbw_lrb_ajax_login_nonce'); ?>">
            
            <button type="submit" class="button masyosis-ajax-login-register"><?php esc_html_e('Login','mayosis-core');?></button>
            
            <div id="mayosis_mbw_lrb_login_message" class="message"></div>
        </form>
        <?php
        return ob_get_clean();
    }

    public function mayosis_mbw_lrb_register_form_shortcode() {
        ob_start();
        ?>
        <form id="mayosis_mbw_lrb_register_form" action="" method="post">
            <input type="text" name="username" id="mayosis_mbw_lrb_register_username" placeholder="<?php esc_html_e('Username','mayosis-core');?>" required>
            
           
            <input type="email" name="email" id="mayosis_mbw_lrb_register_email" placeholder="<?php esc_html_e('Email','mayosis-core');?>" required>
            
         
            <input type="password" name="password" id="mayosis_mbw_lrb_register_password" placeholder="<?php esc_html_e('Password','mayosis-core');?>" required>
            
            <input type="password" name="confirm_password" id="mayosis_mbw_lrb_register_confirm_password" placeholder="<?php esc_html_e('Confirm Password','mayosis-core');?>" required>
            
            <input type="hidden" name="security" id="mayosis_mbw_lrb_register_security" value="<?php echo wp_create_nonce('mayosis_mbw_lrb_ajax_register_nonce'); ?>">
            
            <button type="submit" class="button masyosis-ajax-login-register"><?php esc_html_e('Register','mayosis-core');?></button>
            
            <div id="mayosis_mbw_lrb_register_message" class="message"></div>
        </form>
        <?php
        return ob_get_clean();
    }

    public function mayosis_mbw_lrb_lost_password_form_shortcode() {
        ob_start();
        ?>
        <form id="mayosis_mbw_lrb_lost_password_form" action="" method="post">
            <label for="mayosis_mbw_lrb_lost_password_email">Email</label>
            <input type="email" name="email" id="mayosis_mbw_lrb_lost_password_email" required>
            
            <input type="hidden" name="security" id="mayosis_mbw_lrb_lost_password_security" value="<?php echo wp_create_nonce('mayosis_mbw_lrb_ajax_lost_password_nonce'); ?>">
            
            <button type="submit">Reset Password</button>
            
            <div id="mayosis_mbw_lrb_lost_password_message" class="message"></div>
        </form>
        <?php
        return ob_get_clean();
    }
}

new Mayosis_MBW_LRB_Auth();
?>
