jQuery(document).ready(function($) {
    // Perform AJAX login on form submit
    $('#mayosis_mbw_lrb_login_form').on('submit', function(e) {
        e.preventDefault();
        var username = $('#mayosis_mbw_lrb_login_username').val();
        var password = $('#mayosis_mbw_lrb_login_password').val();
        var security = $('#mayosis_mbw_lrb_login_security').val();

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: mayosis_mbw_lrb_ajax_auth.ajax_url,
            data: {
                'action': 'mayosis_mbw_lrb_ajax_login',
                'username': username,
                'password': password,
                'security': security
            },
            success: function(response) {
                var messageContainer = $('#mayosis_mbw_lrb_login_message');
                messageContainer.show();
                if (response.loggedin == true) {
                    messageContainer.removeClass('error').addClass('success').text(response.message);
                    setTimeout(function() {
                        document.location.href = response.redirect;
                    }, 2000);
                } else {
                    messageContainer.removeClass('success').addClass('error').text(response.message);
                }
            }
        });
    });

    // Perform AJAX registration on form submit
    $('#mayosis_mbw_lrb_register_form').on('submit', function(e) {
        e.preventDefault();
        var username = $('#mayosis_mbw_lrb_register_username').val();
        var email = $('#mayosis_mbw_lrb_register_email').val();
        var password = $('#mayosis_mbw_lrb_register_password').val();
        var confirm_password = $('#mayosis_mbw_lrb_register_confirm_password').val();
        var security = $('#mayosis_mbw_lrb_register_security').val();

        if (password !== confirm_password) {
            var messageContainer = $('#mayosis_mbw_lrb_register_message');
            messageContainer.show();
            messageContainer.removeClass('success').addClass('error').text('Passwords do not match.');
            return;
        }

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: mayosis_mbw_lrb_ajax_auth.ajax_url,
            data: {
                'action': 'mayosis_mbw_lrb_ajax_register',
                'username': username,
                'email': email,
                'password': password,
                'confirm_password': confirm_password,
                'security': security
            },
            success: function(response) {
                var messageContainer = $('#mayosis_mbw_lrb_register_message');
                messageContainer.show();
                if (response.registered == true) {
                    messageContainer.removeClass('error').addClass('success').text(response.message);
                    setTimeout(function() {
                        document.location.href = response.redirect;
                    }, 2000);
                } else {
                    messageContainer.removeClass('success').addClass('error').text(response.message);
                }
            }
        });
    });

    // Perform AJAX lost password on form submit
    $('#mayosis_mbw_lrb_lost_password_form').on('submit', function(e) {
        e.preventDefault();
        var email = $('#mayosis_mbw_lrb_lost_password_email').val();
        var security = $('#mayosis_mbw_lrb_lost_password_security').val();

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: mayosis_mbw_lrb_ajax_auth.ajax_url,
            data: {
                'action': 'mayosis_mbw_lrb_ajax_lost_password',
                'email': email,
                'security': security
            },
            success: function(response) {
                var messageContainer = $('#mayosis_mbw_lrb_lost_password_message');
                messageContainer.show();
                if (response.reset == true) {
                    messageContainer.removeClass('error').addClass('success').text(response.message);
                } else {
                    messageContainer.removeClass('success').addClass('error').text(response.message);
                }
            }
        });
    });
});
