jQuery(document).ready(function($) {
    $('#upload-gallery-button').on('click', function(e) {
        e.preventDefault();

        var image_frame;
        if (image_frame) {
            image_frame.open();
        }

        // Create a new media frame
        image_frame = wp.media({
            title: 'Select Images',
            button: { text: 'Add to Gallery' },
            multiple: true
        });

        // When images are selected
        image_frame.on('select', function() {
            var images = image_frame.state().get('selection').map(function(attachment) {
                attachment = attachment.toJSON();
                $('#custom-gallery-wrapper').append('<img src="' + attachment.url + '" />');
                return attachment.id;
            });

            // Append the image IDs to the hidden input
            var image_ids = $('#custom-gallery-images').val().split(',');
            image_ids = image_ids.concat(images);
            $('#custom-gallery-images').val(image_ids.join(','));
        });

        image_frame.open();
    });
});
