<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 15.2
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');
$bgtype = get_theme_mod('woo_archive_bg_type', 'color');
$productbredtypearc = get_theme_mod('woos_bredcrumb_type_archive', 'full-width');

$prlayout = get_theme_mod('woo_archive_type', 'one');
$sidebarpos = get_theme_mod('woot_sidebar_position_ls', 'left');


if ($bgtype == "featured") {
    global $wp_query;
    $cat = $wp_query->get_queried_object();
    $thumbnail_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
    $catimage = wp_get_attachment_url($thumbnail_id);
} else {
    $catimage = '';
}
?>
<div class="<?php echo esc_html($productbredtypearc); ?>">
<?php if ($bgtype == "featured"){ ?>
    <div class="product-archive-breadcrumb-woo woo-archive-breadcrumb-<?php echo esc_html($bgtype); ?> container-fluid has_mayosis_dark_alt_bg"
         style="background:url(<?php echo esc_url($catimage); ?>)">
    <?php } else { ?>
    <div class="product-archive-breadcrumb-woo woo-archive-breadcrumb-<?php echo esc_html($bgtype); ?> container-fluid has_mayosis_dark_alt_bg">
<?php } ?>
    <div class="container">
        <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
            <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
        <?php endif; ?>
        <?php woocommerce_breadcrumb() ?>

        <?php
        /**
         * Hook: woocommerce_archive_description.
         *
         * @hooked woocommerce_taxonomy_archive_description - 10
         * @hooked woocommerce_product_archive_description - 10
         */
        do_action('woocommerce_archive_description');
        ?>
    </div>
    </div>
    </div>
    <div class="container mayosis-archive-woo-container has_mayosis_dark_bg">
		<div class="row">
		<?php if ($prlayout == "two" && $sidebarpos =="left"){ ?>

			<div class="col-12 col-md-3 mayosis-woo-ac-sidebr">
				<?php dynamic_sidebar('product-archive-sidebar');?>
		     </div>

			<?php } ?>



		<?php if ($prlayout == "two"){ ?>
			<div class="col-12 col-md-9 mayosis-archive-woo-container-main">
		<?php } else { ?>
			<div class="col-12 mayosis-archive-woo-container-main">
		<?php } ?>
		

				<div class="mayosis-toparchive-filter-content">
					<div class="row align-items-center">
						<div class="col-12 col-md-6">
							<?php woocommerce_result_count(); ?>
						</div>
						<div class="col-12 col-md-6">
							<?php woocommerce_catalog_ordering(); ?>
						</div>
					</div>

				</div>
			<?php
			if (woocommerce_product_loop()) {

				/**
				 * Hook: woocommerce_before_shop_loop.
				 *
				 * @hooked woocommerce_output_all_notices - 10
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action('woocommerce_before_shop_loop');

				woocommerce_product_loop_start();

				if (wc_get_loop_prop('total')) {
					while (have_posts()) {
						the_post();

						/**
						 * Hook: woocommerce_shop_loop.
						 */
						do_action('woocommerce_shop_loop');

						wc_get_template_part('content', 'product');
					}
				}

				woocommerce_product_loop_end();

				/**
				 * Hook: woocommerce_after_shop_loop.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action('woocommerce_after_shop_loop');
			} else {
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action('woocommerce_no_products_found');
			}

			/**
			 * Hook: woocommerce_after_main_content.
			 *
			 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
			 */
			do_action('woocommerce_after_main_content');  ?>

</div>
<?php if ($prlayout == "two" && $sidebarpos =="right"){ ?>

<div class="col-12 col-md-4 mayosis-woo-ac-sidebr">
	<?php dynamic_sidebar('product-archive-sidebar');?>
 </div>

<?php } ?>
      </div>
	</div>

<?php

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
//do_action( 'woocommerce_sidebar' );

get_footer('shop');
