<?php
$mode = isset ( $_GET ["mode"] ) ? $_GET ["mode"] : "1";
$month = isset ( $_GET ['essb_month'] ) ? $_GET ['essb_month'] : '';
$date = isset ( $_GET ['date'] ) ? $_GET ['date'] : '';
$position = isset($_GET['position']) ? $_GET['position'] : '';

$overall_stats = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_networks ( '', '', $date, $position );
$position_stats = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_position ( '', '', $date, $position );


$best_position_value = 0;
$best_position_key = "";
$best_position_percent = 0;

$best_network_value = 0;
$best_network_key = "";
$best_network_percent = 0;

if (isset ( $overall_stats )) {
  foreach ( ESSBSocialShareAnalyticsBackEnd::$positions as $k ) {

    $key = "position_" . $k;

    $single = intval ( $position_stats->{$key} );

    if ($single > $best_position_value) {
      $best_position_value = $single;
      $best_position_key = $k;
    }
  }

  foreach ( $essb_networks as $k => $v ) {

    $single = intval ( $overall_stats->{$k} );

    if ($single > $best_network_value) {
      $best_network_value = $single;
      $best_network_key = $v["name"];
    }
  }
}


$device_stats = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_device ( $month, '', $date, $position );
$desktop = 0;
$mobile = 0;
$calculated_total = 0;
if (isset ( $device_stats )) {
  $desktop = $device_stats->desktop;
  $mobile = $device_stats->mobile;

  $calculated_total = $device_stats->cnt;

  if ($calculated_total != 0) {
    $percentd = $desktop * 100 / $calculated_total;
  } else {
    $percentd = 0;
  }
  $print_percentd = round ( $percentd, 2 );

  if ($calculated_total != 0) {
    $percentm = $mobile * 100 / $calculated_total;
  } else {
    $percentm = 0;
  }
  $print_percentm = round ( $percentm, 2 );
}

$period_today = date('Y-m-d');
$period_7days = date('Y-m-d', strtotime('-7 day', strtotime(date("Y-m-d"))));
$period_30days = date('Y-m-d', strtotime('-30 day', strtotime(date("Y-m-d"))));

$value7_days = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_position_for_period($best_position_key, $period_7days, $period_today);
$value30_days = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_position_for_period($best_position_key, $period_30days, $period_today);

if ($calculated_total != 0) {
  $best_position_percent = $best_position_value * 100 / $calculated_total;
  $best_position_percent = round ( $best_position_percent, 1 );
}

$nvalue7_days = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_network_for_period($best_network_key, $period_7days, $period_today);
$nvalue30_days = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_network_for_period($best_network_key, $period_30days, $period_today);
if ($calculated_total != 0) {
  $best_network_percent = $best_network_value * 100 / $calculated_total;
  $best_network_percent = round ( $best_network_percent, 1 );
}

?>

<div class="stats-head">
  <div class="panel">
    <h4>Total Share Button Clicks</h4>

    <div class="bold-value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($calculated_total); ?></div>

    <div class="footer">
      <label class="desc">Desktop:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($desktop); ?> (<?php echo $print_percentd; ?> %)</label>

      <label class="desc">Mobile:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($mobile); ?> (<?php echo $print_percentm; ?> %)</label>
    </div>
  </div>
  <div class="panel">
    <h4>Best Position: <strong><?php echo ESSBSocialShareAnalyticsBackEnd::position_name ($best_position_key); ?></strong></h4>

    <div class="bold-value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($best_position_value); ?>
      <a href="<?php echo esc_url( admin_url('admin.php?page=essb_redirect_analytics&tab=analytics&mode=positions') );?>" class="essb-btn essb-btn-green1" style="float: right; padding: 6px 12px;">View All</a>
    </div>

    <div class="footer">
      <label class="value" style="margin-right: 0px;"><?php echo $best_position_percent; ?> %</label>
      <label class="desc" style="margin-right: 10px;">Of all clicks</label>

      <label class="desc">Last 7 days:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($value7_days->cnt); ?></label>

      <label class="desc">Last 30 days:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($value30_days->cnt); ?></label>
    </div>
  </div>
  <div class="panel">
    <h4>Best Social Network: <strong><?php echo $best_network_key; ?></strong></h4>

    <div class="bold-value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($best_network_value); ?>
	<a href="<?php echo esc_url( admin_url('admin.php?page=essb_redirect_analytics&tab=analytics&mode=networks') ); ?>" class="essb-btn essb-btn-green1" style="float: right; padding: 6px 12px;">View All</a>
    </div>

    <div class="footer">
      <label class="value" style="margin-right: 0px;"><?php echo $best_network_percent; ?> %</label>
      <label class="desc" style="margin-right: 10px;">Of all clicks</label>

      <label class="desc">Last 7 days:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($nvalue7_days->cnt); ?></label>

      <label class="desc">Last 30 days:</label>
      <label class="value"><?php echo ESSBSocialShareAnalyticsBackEnd::prettyPrintNumber($nvalue30_days->cnt); ?></label>
    </div>

  </div>
</div>

<div class="stat-welcome-graph">
	<div class="dashboard-head">
		<h4>Activity for the last 30 days</h4>
		<p>View the number of share button clicks in the past 30 days. By clicking on date you can also start a detailed date report.</p>
	</div>
	
	<?php 
	$essb_date_to = "";
	$essb_date_from = "";
	
	if ($essb_date_to == '') {
		$essb_date_to = date ( "Y-m-d" );
	}
	
	if ($essb_date_from == '') {
		$essb_date_from = date ( "Y-m-d", strtotime ( date ( "Y-m-d", strtotime ( date ( "Y-m-d" ) ) ) . "-1 month" ) );
	}
	
	$sqlObject = ESSBSocialShareAnalyticsBackEnd::getDateRangeRecords ( $essb_date_from, $essb_date_to );
	
	$dataPeriodObject = ESSBSocialShareAnalyticsBackEnd::sqlDateRangeRecordConvert ( $essb_date_from, $essb_date_to, $sqlObject );
	
	$sqlMonthsData = ESSBSocialShareAnalyticsBackEnd::essb_stats_by_networks_by_months ();

	?>
	
	<div class="essb-dashboard-panel-content" id="essb-changes-graph"
			style="height: 380px;"></div>
</div>

<div class="stat-welcome-month-content">
	<div class="one-half">
		<!-- Month Report -->
		<div class="dashboard-head">
			<h4>Monthly Report</h4>
			<p>You can start a detailed report by clicking on each month.</p>
		</div>
		
		<?php ESSBSocialShareAnalyticsBackEnd::show_month_details ($sqlMonthsData); ?>
	</div>
	<div class="one-half">
	
	<!-- Posts Report -->
		<div class="dashboard-head">
			<h4>Leading Posts</h4>
			<p>View your most popular content since analytics activation.</p>
		</div>
		
		<?php ESSBSocialShareAnalyticsBackEnd::essb_slim_stat_admin_detail_by_post( '', '', $date, $position );?>
	</div>
</div>


<script type="text/javascript">
jQuery(document).ready(function($){
    <?php
		echo ESSBSocialShareAnalyticsBackEnd::keyObjectToMorrisLineGraph ( 'essb-changes-graph', $dataPeriodObject, 'Social activity' );
	?>

	if (jQuery("#table-month").length)
		jQuery('#table-month').DataTable({ pageLength: 50, scrollX: true, order: [[0, 'desc']], fixedColumns: true});

	if (jQuery("#table-posts").length)
		jQuery('#table-posts').DataTable({ pageLength: 50, scrollX: true, order: [[1, 'desc']], fixedColumns: true});

	var essb_analytics_date_report = window.essb_analytics_date_report = function(date) {

		window.location='admin.php?page=essb_redirect_analytics&tab=analytics&mode=date&date='+date;

	}

	var essb_analytics_position_report = function(position) {

		window.location='admin.php?page=essb_redirect_analytics&tab=analytics&mode=5&position='+position;

	}
});
	
</script>
