<?php 

if (function_exists('essb_advancedopts_settings_group')) {
	essb_advancedopts_settings_group('essb_options');
}

essb_advancedopts_section_open('ao-small-values');

essb_advanced_options_relation('facebook_counter_api', 'value', array('api2' => array('facebook_counter_token'), 'sharedcount' => array('sharedcount_token')));

essb5_draw_heading(esc_html__('General', 'essb'), '6');
essb5_draw_switch_option('counter_remove_query_string', esc_html__('Don\'t use query string in URLs when updating share counters', 'essb'), '');

essb5_draw_heading(esc_html__('Facebook', 'essb'), '6');
$listOfOptions = array ("api2" => "Facebook API (Require Token)", 'sharedcount' => 'SharedCount.com (Require Token)');
essb5_draw_select_option('facebook_counter_api', esc_html__('Facebook counter update API', 'essb'), esc_html__('Select the counter update source. No matter which you choose (Facebook API or ShareCount API) you need to complete the steps and create an access token key.', 'essb'), $listOfOptions);
essb5_draw_field_group_open();
essb5_draw_input_option('facebook_counter_token', esc_html__('Facebook access token key', 'essb'), sprintf(esc_html__('To generate your access token key please visit %s and follow instructions to generate application based token', 'essb'), '<a href="https://tools.creoworx.com/facebook/" target="_blank">https://tools.creoworx.com/facebook/</a>'), true);
essb5_draw_input_option('sharedcount_token', esc_html__('SharedCount.com access token key', 'essb'), sprintf( esc_html__('Can the key from your profile %s. You can refer to SharedCount.com documentation for more details.', 'essb'), '<a href="https://www.sharedcount.com/app/account-info" target="_blank">https://www.sharedcount.com/app/account-info</a>') , true);
essb5_draw_field_group_close();

essb5_draw_switch_option('facebook_likebtn_counter', esc_html__('Enable display of counter on the static Facebook Like button', 'essb'), esc_html__('Show the Facebook counter to the static like button generated by the plugin. As Facebook does not have a separate counter for likes and shares both buttons will show the same value if you enable the option.', 'essb'));

essb5_draw_heading(esc_html__('Twitter', 'essb'), '6');
$listOfOptions = array ("self" => "Self-hosted counter (internally counted by click on buttons)", "twitcount" => "Using twitcount.com",  "newsc" => "Using NewShareCounts.com", "opensc" => "Using OpenShareCount.com", "no" => "No counter for Twitter button" );
essb5_draw_select_option('twitter_counters', esc_html__('Twitter share counter', 'essb'), esc_html__('Select Twitter counter source. If you choose an external service don\'t forget to check their website for additional instructions on the activation. If you select the self-hosted option the value will increase with a click over the share buttons and stored inside the post meta table.', 'essb'), $listOfOptions);

essb5_draw_heading(esc_html__('LinkedIn', 'essb'), '6');
$listOfOptions = array ("" => "Self-hosted counter (internally counted by click on buttons)", "no" => "Without share counter");
essb5_draw_select_option('linkedin_counter_type', esc_html__('LinkedIn share counter', 'essb'), esc_html__('LinkedIn does not have a counter API. You can choose between a self-hosted counter (with a click on the button) or without a share counter.', 'essb'), $listOfOptions);

essb5_draw_heading(esc_html__('AddThis', 'essb'), '6');
essb5_draw_switch_option('cache_counter_addthis', esc_html__('AddThis internal counter support', 'essb'), esc_html__('If you have used in the past AddThis you can enable the option. The internal counters stored by AddThis will be added to the total value of shares (internal value does not have a network split).', 'essb'));

essb_advancedopts_section_close();