<?php
namespace KeyStone\Modules;
use KeyStone\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Portfolio {

	const CPT_SLUG = 'keystone-portfolio';
	const TAXONOMY_CATEGORY_SLUG = 'keystone-portfolio-category';

	public function register_data() {

		$labels = apply_filters( 'keystone_portfolio_labels', [
			'name' => esc_html_x( 'Portfolio', 'Portfolio', 'keystone-framework' ),
			'singular_name' => esc_html_x( 'Portfolio', 'Portfolio', 'keystone-framework' ),
			'menu_name' => esc_html_x( 'Portfolio', 'Portfolio', 'keystone-framework' ),
			'name_admin_bar' => esc_html__( 'Portfolio Item', 'keystone-framework' ),
			'archives' => esc_html__( 'Portfolio Item Archives', 'keystone-framework' ),
			'parent_item_colon' => esc_html__( 'Parent Item:', 'keystone-framework' ),
			'all_items' => esc_html__( 'All Items', 'keystone-framework' ),
			'add_new_item' => esc_html__( 'Add New Portfolio', 'keystone-framework' ),
			'add_new' => esc_html__( 'Add New', 'keystone-framework' ),
			'new_item' => esc_html__( 'New Portfolio', 'keystone-framework' ),
			'edit_item' => esc_html__( 'Edit Portfolio', 'keystone-framework' ),
			'update_item' => esc_html__( 'Update Portfolio', 'keystone-framework' ),
			'view_item' => esc_html__( 'View Portfolio', 'keystone-framework' ),
			'search_items' => esc_html__( 'Search Portfolios', 'keystone-framework' ),
			'not_found' => esc_html__( 'Not found', 'keystone-framework' ),
			'not_found_in_trash' => esc_html__( 'Not found in Trash', 'keystone-framework' ),
			'featured_image' => esc_html__( 'Featured Image', 'keystone-framework' ),
			'set_featured_image' => esc_html__( 'Set featured image', 'keystone-framework' ),
			'remove_featured_image' => esc_html__( 'Remove featured image', 'keystone-framework' ),
			'use_featured_image' => esc_html__( 'Use as featured image', 'keystone-framework' ),
			'insert_into_item' => esc_html__( 'Insert into Portfolio', 'keystone-framework' ),
			'uploaded_to_this_item' => esc_html__( 'Uploaded to this Portfolio', 'keystone-framework' ),
			'items_list' => esc_html__( 'Items list', 'keystone-framework' ),
			'items_list_navigation' => esc_html__( 'Items list navigation', 'keystone-framework' ),
			'filter_items_list' => esc_html__( 'Filter items list', 'keystone-framework' ),
		] );

		$portfolio_slug = apply_filters( 'keystone_portfolio_slug', 'portfolio' );

		$rewrite = [
			'slug' => $portfolio_slug,
			'with_front' => false,
		];

		$args = [
			'labels' => $labels,
			'public' => true,
			'menu_position' => 25,
			'menu_icon' => 'dashicons-format-image',
			'capability_type' => 'post',
			'supports' => [ 'title', 'editor', 'thumbnail', 'author', 'excerpt', 'comments', 'revisions', 'page-attributes', 'custom-fields', 'elementor' ],
			'has_archive' => true,
			'rewrite' => $rewrite,
		];

		register_post_type( self::CPT_SLUG, $args );

		// Categories
		$portfolio_category_slug = apply_filters( 'keystone_portfolio_category_slug', 'portfolio-category' );

		$rewrite = [
			'slug' => $portfolio_category_slug,
			'with_front' => false,
		];

		$args = [
			'hierarchical' => true,
			'show_ui' => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => true,
			'labels' => $labels,
			'rewrite' => $rewrite,
			'public' => true,
			'labels' => [
				'name' => esc_html_x( 'Categories', 'Portfolio', 'keystone-framework' ),
				'singular_name' => esc_html_x( 'Category', 'Portfolio', 'keystone-framework' ),
				'all_items' => esc_html_x( 'All Categories', 'Portfolio', 'keystone-framework' ),
			],
		];
		register_taxonomy( self::TAXONOMY_CATEGORY_SLUG, self::CPT_SLUG, $args );
	}

	public function __construct() {
		$portfolio_switch = Utils::get_option( 'portfolio_cpt_switch' );
		if ( $portfolio_switch != 'disable' ) {
			add_action( 'init', [ $this, 'register_data' ], 1 );
			require_once KEYSTONE_MODULES_PATH . '/portfolio/portfolio-functions.php';
		}
	}
}
