<?php
namespace KeyStone;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use KeyStone\Utils;

$theme_name = Utils::get_parent_theme_name();
$theme_version = Utils::get_parent_theme_version();
$license_key = License\Admin::get_license_key();
?>

<div class="keystone-menu-panel">
    <div class="keystone-dashboard-tabs">
        <ul class="keystone-dashboard-tabs-list">
            <li class="dashboard-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=keystone-dashboard' ) ); ?>"><?php echo esc_html__( 'Dashboard', 'keystone-framework' ); ?></a></li>
            <li class="theme-options-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=theme-options' ) ); ?>"><?php echo esc_html__( 'Theme Options', 'keystone-framework' ); ?></a></li>
			<?php if ( defined( 'ELEMENTOR_VERSION' ) && is_callable( '\Elementor\Plugin::instance' ) ) : ?>
            	<li class="site-settings-tab"><a href="<?php echo esc_url_raw( Compatibility\KeyStone_Elementor::get_site_settings_link() ); ?>"><?php echo esc_html__( 'Site Settings', 'keystone-framework' ); ?></a></li>
			<?php endif; ?>
            <li class="plugins-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=install-required-plugins' ) ); ?>"><?php echo esc_html__( 'Plugins', 'keystone-framework' ); ?></a></li>
            <li class="demos-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=one-click-demo-import' ) ); ?>"><?php echo esc_html__( 'Demo Import', 'keystone-framework' ); ?></a></li>
            <li class="system-status-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=keystone-system-status' ) ); ?>"><?php echo esc_html__( 'System Info', 'keystone-framework' ); ?></a></li>
            <li class="help-tab"><a href="<?php echo esc_url_raw( admin_url( 'admin.php?page=keystone-help' ) ); ?>"><?php echo esc_html__( 'Help', 'keystone-framework' ); ?></a></li>
        </ul>
    </div>

</div>
