<?php

namespace KeyStone;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$license_key = License\Admin::get_license_key();

if ( ! $license_key ) {
    return;
}

$license_data = License\API::get_license_data();
$support_status = false;
$support_message = '';
$disable_button = false;
$support_remaining = '';

if ( $license_data['status'] ) {
	$support_expiry = $license_data['data'];

    $current_time = current_time( 'timestamp' );
    $expiry_time = strtotime( $support_expiry );

	$support_remaining = human_time_diff( $current_time, $expiry_time );

	if ( $expiry_time > $current_time ) {
		$support_status = true;
        
        // Calculate the difference in months
        $diff_in_seconds = $expiry_time - $current_time;
        $diff_in_months = $diff_in_seconds / (30 * 24 * 60 * 60); // 30 days * 24 hours * 60 minutes * 60 seconds
        
        if ( $diff_in_months > 6 ) {
            $support_message = esc_html__( 'Thanks for securing your website with extended support.', 'keystone-framework' );
            $disable_button = true; // Disable the buttons
        }
	}
}

?>





