<?php
/**
 * Demo Import Page.
 *
 * @package SigmaDevs\EasyDemoImporter
 */

require_once KEYSTONE_PATH . 'includes/admin/views/welcome-panel.php';

$license_status = \KeyStone\License\Admin::get_license_key();

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! $license_status ) {
	require_once KEYSTONE_PATH . 'includes/admin/views/register-notice.php';
} else {
	?>
	<div class="ksadmin-dashboard ksadmin-import">
		<div class="ksadmin-welcome-box postbox">
			<div class="ksadmin-intro-text">
				<h2><?php echo esc_html__( 'Import a Starter Site', 'keystone-framework' ); ?></h2>
				<p><?php echo esc_html__( 'Import any of the starter sites below. We recommend using this feature for fresh installations.', 'keystone-framework' ); ?></p>
				<p><?php echo sprintf( esc_html__( 'Please check the %1$s page to verify that your server meets all the requirements for a successful import.', 'keystone-framework' ),
						'<a href="' . esc_url_raw( admin_url( 'admin.php?page=keystone-system-status' ) ) . '">' . esc_html( 'System Info', 'keystone-framework' ) . '</a>',
					); ?></p>
			</div>
			<div class="keystone-notice keystone-import-notice">
				<p><strong><?php esc_html_e( 'Important Note:', 'keystone-framework' ); ?></strong> <?php esc_html_e( 'Importing a demo site will replace the colors and fonts in your Elementor Site Settings panel.', 'keystone-framework' ); ?></p>
			</div>
		</div>
	
	<div id="sd-edi-demo-import-container"></div>
	</div>
	<?php
}
?>
