<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'general_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'General', 'keystone-framework' ),
            'submenu' => esc_html__( 'General', 'keystone-framework' ),
        ),
		'link_effect' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Link Effect', 'keystone-framework' ),
            'description' => esc_html__( 'Select hover effects for simple text links.', 'keystone-framework' ),
            'options' => array(
                'default-link-effect' => esc_html__( 'Default', 'keystone-framework' ),
                'underline-link-effect' => esc_html__( 'Underline', 'keystone-framework' ),
				'overlay-link-effect' => esc_html__( 'Overlay', 'keystone-framework' ),
            ),
            'submenu' => esc_html__( 'General', 'keystone-framework' ),
            'value' => 'default-link-effect',
        ),
        'button_effect' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Button Effect', 'keystone-framework' ),
            'description' => esc_html__( 'Select hover effects for button elements.', 'keystone-framework' ),
            'options' => array(
                'default-button-effect' => esc_html__( 'Default', 'keystone-framework' ),
                'zoom-button-effect' => esc_html__( 'Zoom', 'keystone-framework' ),
                'flip-button-effect' => esc_html__( 'Flip', 'keystone-framework' ),
            ),
            'submenu' => esc_html__( 'General', 'keystone-framework' ),
            'value' => 'default-button-effect',
        ),
        'integrations_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Integrations', 'keystone-framework' ),
            'submenu' => esc_html__( 'Integrations', 'keystone-framework' ),
        ),
		'typekit_id' => array(
            'type' => 'text',
            'label' => esc_html__( 'Adobe Fonts', 'keystone-framework' ),
            'description' => sprintf(
				esc_html__( 'Enter your Adobe Fonts Project ID. %1$sLearn how to get the code%2$s.', 'keystone-framework' ),
				'<a href="https://help.keystonethemes.com/knowledge-base/using-adobe-typekit-fonts/" target="_blank">',
				'</a>'
			),
			'submenu' => esc_html__('Integrations', 'keystone-framework'),
        ),
        'google_maps_api' => array(
            'type' => 'text',
            'label' => esc_html__( 'Google Maps', 'keystone-framework' ),
            'description' => esc_html__( 'Enter your Google Maps API key.', 'keystone-framework' ),
            'description' => sprintf(
				esc_html__( 'Enter your Google Maps API key for map functionality. %1$sLearn how to generate the API key%2$s.', 'keystone-framework' ),
				'<a href="https://help.keystonethemes.com/knowledge-base/generate-a-google-maps-api-key/" target="_blank">',
				'</a>'
			),
			'submenu' => esc_html__('Integrations', 'keystone-framework'),
        ),
        'elementor_group_options' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Elementor Settings', 'keystone-framework' ),
            'group' => 'started',
            'submenu' => esc_html__( 'Integrations', 'keystone-framework' ),
        ),
        'elementor_default_library' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Template Library', 'keystone-framework' ),
            'description' => esc_html__( 'Toggle between Elementor and KeyStone Template Library.', 'keystone-framework' ),
            'options' => array(
                'keystone-library' => esc_html__( 'Keystone Library', 'keystone-framework' ),
                'default-library' => esc_html__( 'Elementor Library', 'keystone-framework' ),
            ),
            'value' => 'keystone-library',
            'group' => 'ended',
            'submenu' => esc_html__( 'Integrations', 'keystone-framework' ),
        ),
        'back_to_top_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Back to Top', 'keystone-framework' ),
            'description' => esc_html__( 'Display a back to top button that becomes visible when the user starts to scroll the page.', 'keystone-framework' ),
            'submenu' => esc_html__( 'Back to Top', 'keystone-framework' ),
        ),
        'go_top_button' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Back to Top', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to enable the Back to Top button which adds the scrolling to top functionality.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Back to Top', 'keystone-framework' ),
        ),
        'go_top_button_position' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Back to Top Position', 'keystone-framework' ),
            'description' => esc_html__( 'Select the Back to Top button position.', 'keystone-framework' ),
            'options' => array(
                'left-aligned' => esc_html__( 'Left', 'keystone-framework' ),
                'right-aligned' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'right-aligned',
            'dependency' => array(
                'key' => 'go_top_button',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Back to Top', 'keystone-framework' ),
        ),
        'go_top_button_color' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Back to Top Color', 'keystone-framework' ),
            'description' => esc_html__( 'Select the Back to Top button color scheme.', 'keystone-framework' ),
            'options' => array(
                'primary-color' => esc_html__( 'Primary', 'keystone-framework' ),
                'secondary-color' => esc_html__( 'Secondary', 'keystone-framework' ),
            ),
            'value' => 'primary-color',
            'dependency' => array(
                'key' => 'go_top_button',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Back to Top', 'keystone-framework' ),
        ),
        'go_top_button_style' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Back to Top Style', 'keystone-framework' ),
            'description' => esc_html__( 'Select the Back to Top button style. The Scroll progress option shows a page scroll progress bar.', 'keystone-framework' ),
            'options' => array(
                'classic-style' => esc_html__( 'Classic', 'keystone-framework' ),
                'scroll-progress-style' => esc_html__( 'Scroll progress', 'keystone-framework' ),
            ),
            'value' => 'scroll-progress-style',
            'dependency' => array(
                'key' => 'go_top_button',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Back to Top', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'Global Options', 'keystone-framework' ),
        'icon' => 'lnricons-cog',
        'fields' => $fields
    );

    $setup[ 'global-options' ] = $customFields;

    return $setup;

}, 10, 1 );
