<?php 

function ocdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');
    
    if ($main_menu && isset($main_menu->term_id)) {
        set_theme_mod('nav_menu_locations', [
            'main-menu' => intval($main_menu->term_id), // Ensure 'main-menu' matches your register_nav_menu() ID.
        ]);
    }

    // Get the front page.
    $front_page = get_page_by_title('Home');
    if ($front_page && isset($front_page->ID)) {
        update_option('page_on_front', intval($front_page->ID));
        update_option('show_on_front', 'page');
    }

    // Get the blog page.
    $blog_page = get_page_by_title('Blog');
    if ($blog_page && isset($blog_page->ID)) {
        update_option('page_for_posts', intval($blog_page->ID));
    }

    // Get the imported Elementor kit (assuming it's imported with the demo content)
    $elementor_kit = get_page_by_title('Default Kit', OBJECT, 'elementor_library');
    if ($elementor_kit && isset($elementor_kit->ID)) {
        // Set the imported kit as the active Elementor kit
        update_option('elementor_active_kit', intval($elementor_kit->ID));
        
        // Clear Elementor cache after setting the active kit
        \Elementor\Plugin::instance()->files_manager->clear_cache();
    }

    // Set permalink structure.
    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('/%postname%/');
    flush_rewrite_rules();
}
add_action('ocdi/after_import', 'ocdi_after_import_setup');
