<?php
namespace KeyStone\Admin;

use KeyStone\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Loader {
    public function __construct() {

		add_action( 'admin_menu', [ $this, 'register_admin_menu' ], -1 );
        add_action( 'admin_bar_menu', [ $this, 'register_admin_bar_menu' ], 99 );

		add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_styles' ] );
    }

	public static function admin_enqueue_styles() {

		$current_screen = get_current_screen();

		wp_enqueue_style(
			'keystone-admin',
			KEYSTONE_ASSETS_URL . 'css/keystone-admin.css',
			[],
			KEYSTONE_VERSION
		);

		if ( strpos( $current_screen->base, 'theme-options' ) === false ) {
        	return;
    	} else {
			wp_enqueue_style(
				'keystone-admin-theme-options',
				KEYSTONE_ASSETS_URL . 'css/keystone-admin-theme-options.css',
				[],
				KEYSTONE_VERSION
			);
		}
	}

	private function check_permissions() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die(
				esc_html(__('You do not have sufficient permissions to access this page.', 'keystone-framework'))
			);
		}
	}

    private function render_page_template( $template ) {
        $this->check_permissions();
        require_once KEYSTONE_PATH . 'includes/admin/views/' . $template . '-view.php';
    }

	public function dashboard_page_template() {
		$this->render_page_template( 'dashboard' );
	}

	public function system_status_page_template() {
		$this->render_page_template( 'system-status' );
	}

	public function help_page_template() {
		$this->render_page_template( 'help' );
	}

    public function register_admin_menu() {
		if ( ! \KeyStone\Utils::is_keystone_theme() ) {
			return;
		}

		$capability = 'manage_options';
		$parent_menu_item = 'keystone-dashboard';

		if ( ! current_user_can( $capability ) ) {
			return;
		}

        add_menu_page(
            __( 'Keystone Dashboard', 'keystone-framework' ),
            __( 'KeyStone', 'keystone-framework' ),
            $capability,
            $parent_menu_item,
            '',
            'none',
            2
        );

        add_submenu_page(
            $parent_menu_item,
            __( 'Keystone Dashboard', 'keystone-framework' ),
            __( 'Dashboard', 'keystone-framework' ),
            $capability,
            $parent_menu_item,
            [ $this, 'dashboard_page_template' ],
            0
        );

		add_submenu_page(
            $parent_menu_item,
            __( 'System Info', 'keystone-framework' ),
            __( 'System Info', 'keystone-framework' ),
            $capability,
            'keystone-system-status',
            [ $this, 'system_status_page_template' ],
            10
        );

		add_submenu_page(
            $parent_menu_item,
            __( 'Help', 'keystone-framework' ),
            __( 'Help', 'keystone-framework' ),
            $capability,
            'keystone-help',
            [ $this, 'help_page_template' ],
            15
        );
    }

    public static function register_admin_bar_menu( $wp_admin_bar ) {

		if ( ! current_user_can( 'edit_theme_options' ) ) {
		    return;
		}
		$parent_menu_item = 'keystone-dashboard';

		$args = [
			'id'    => $parent_menu_item,
			'title' => Utils::get_parent_theme_name(),
			'href'  => admin_url( 'admin.php?page=keystone-dashboard' ),
		];
		$wp_admin_bar->add_node( $args );

		$args = [
			'id' => 'keystone-admin',
			'title' => esc_html__( 'Dashboard', 'keystone-framework' ),
			'href' => admin_url( 'admin.php?page=keystone-dashboard' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );

		$args = [
			'id' => 'theme-options',
			'title' => esc_html__( 'Theme Options', 'viva-addon' ),
			'href' => admin_url( 'admin.php?page=theme-options' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );

		if ( defined( 'ELEMENTOR_VERSION' ) && is_callable( '\Elementor\Plugin::instance' ) ) {
			$args = [
				'id' => 'keystone-site-settings',
				'title' => esc_html__( 'Site Settings', 'keystone-framework' ),
				'href' => \KeyStone\Compatibility\KeyStone_Elementor::get_site_settings_link(),
				'parent' => $parent_menu_item,
			];
			$wp_admin_bar->add_node( $args );
		}

		$args = [
			'id' => 'install-required-plugins',
			'title' => 'Plugins',
			'href' => admin_url( 'admin.php?page=install-required-plugins' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );

    	$args = [
			'id' => 'import-demos',
			'title' => esc_html__( 'Demo Import', 'keystone-framework' ),
			'href' => admin_url( 'admin.php?page=one-click-demo-import' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );

		$args = [
			'id' => 'keystone-system-status',
			'title' => esc_html__( 'System Info', 'keystone-framework' ),
			'href' => admin_url( 'admin.php?page=keystone-system-status' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );

		$args = [
			'id' => 'keystone-help',
			'title' => esc_html__( 'Help', 'keystone-framework' ),
			'href' => admin_url( 'admin.php?page=keystone-help' ),
			'parent' => $parent_menu_item,
		];
		$wp_admin_bar->add_node( $args );
	}
}
