<?php
/**
 * The sidebar containing the main widget area.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 */

defined( 'ABSPATH' ) || exit;

$sidebar_name = apply_filters( 'keystone_get_sidebar', 'sidebar-1' );
$sidebar_switch = apply_filters( 'keystone_show_sidebar', true );

if ( ! is_active_sidebar( $sidebar_name ) || $sidebar_switch == false ) {
	return;
}
?>
<aside id="secondary" class="widget-area keystone-sidebar" role="complementary">
	<?php
		keystone_sidebars_before();
		if ( is_active_sidebar( $sidebar_name ) ) {
			dynamic_sidebar( $sidebar_name );
		}
		keystone_sidebars_after();
	?>
</aside><!-- #secondary -->
