<?php
/**
 * Blog Helper Functions
 *
 * @package Astra
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'keystone_blog_body_classes' ) ) {
	function keystone_blog_body_classes( $classes ) {
		$classes[] = '';

		// Single blog post layout class
		if ( is_single() && get_post_type() === 'post' ) {
			$blog_single_layout = apply_filters( 'keystone_hook_blog_single_layout', keystone_get_option( 'blog_single_layout' ) );

			// Use classic post layout if thumbnail not loaded
			if ( has_post_thumbnail() || wp_get_attachment_image_src( get_post_thumbnail_id() ) ) {
				$classes[] = $blog_single_layout;
			} else {
				$classes[] = 'blog-single-layout-classic';
			}
		}

		return $classes;
	}
}
add_filter( 'body_class', 'keystone_blog_body_classes' );

// Center align page title if sidebar is disabled
if ( ! function_exists( 'keystone_blog_no_sidebar' ) ) {
	function keystone_blog_no_sidebar( $classes ) {
		$blog_sidebar = apply_filters( 'keystone_hook_blog_sidebar', keystone_get_option( 'blog_sidebar' ) );

		if ( false == $blog_sidebar ) {
			$classes = 'title-bar-text-center';
		}

		return $classes;
	}
}

add_filter( 'keystone_hook_page_header_text_alignment', 'keystone_blog_no_sidebar' );

if ( ! function_exists( 'keystone_blog_classes' ) ) {
	function keystone_blog_classes( $classes ) {
		$blog_layout = 'blog-layout-classic';
		$sidebar_display = $single_sidebar = true;
		$sidebar_position = $single_sidebar_position = 'sidebar-right';
		
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$blog_layout = keystone_get_option( 'blog_article_layout' );
			$sidebar_display = keystone_get_option( 'blog_sidebar' );
			$sidebar_position = keystone_get_option( 'blog_sidebar_position' );
			
			$single_sidebar = keystone_get_option( 'blog_single_sidebar' );
			$single_sidebar_position = keystone_get_option( 'blog_single_sidebar_position' );
		}
			
			
		if ( keystone_is_blog_archive() ) {
			$article_layout = apply_filters( 'keystone_hook_blog_article_layout', $blog_layout );
			$blog_sidebar = apply_filters( 'keystone_hook_blog_sidebar', $sidebar_display );
			$blog_sidebar_position = apply_filters( 'keystone_hook_blog_sidebar_position', $sidebar_position );
			$blog_sticky_sidebar = apply_filters( 'keystone_hook_blog_sticky_sidebar', keystone_get_option( 'blog_sticky_sidebar' ) );

			$classes[] = 'blog-content-area';
			$classes[] = $article_layout;

			if ( true == $blog_sidebar ) {
				$classes[] = 'with-sidebar';
				$classes[] = $blog_sidebar_position;

				if ( $blog_sticky_sidebar ) {
					$classes[] = 'sticky-sidebar';
				}
			} else {
				$classes[] = 'no-sidebar';
			}
		}

		if ( is_singular( 'post' ) ) {
			$blog_single_sidebar = apply_filters( 'keystone_hook_blog_sidebar', $single_sidebar );
			$blog_single_sidebar_position = apply_filters( 'keystone_hook_blog_single_sidebar_position', $single_sidebar_position );
			$blog_single_sticky_sidebar = apply_filters( 'keystone_hook_blog_single_sticky_sidebar', keystone_get_option( 'blog_single_sticky_sidebar' ) );

			if ( true == $blog_single_sidebar ) {
				$classes[] = 'with-sidebar';
				$classes[] = $blog_single_sidebar_position;

				if ( $blog_single_sticky_sidebar ) {
					$classes[] = 'sticky-sidebar';
				}
			} else {
				$classes[] = 'no-sidebar';
			}
		}

		return $classes;
	}
}

add_filter( 'keystone_container_class', 'keystone_blog_classes' );

if ( ! function_exists( 'keystone_blog_sidebar_switch' ) ) {
	function keystone_blog_sidebar_switch() {
		$blog_sidebar_display = $blog_single_sidebar_display = true;
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$blog_sidebar_display = keystone_get_option( 'blog_sidebar' );
			$blog_single_sidebar_display = keystone_get_option( 'blog_single_sidebar' );
		}
		
		if ( keystone_is_blog_archive() ) {
			$blog_sidebar = apply_filters( 'keystone_hook_blog_sidebar', $blog_sidebar_display );
			
			if ( false == $blog_sidebar ) {
				add_filter( 'keystone_show_sidebar', '__return_false' );
			}
		}

		if ( is_singular( 'post' ) ) {
			$blog_single_sidebar = apply_filters( 'keystone_hook_blog_single_sidebar', $blog_single_sidebar_display );
			
			if ( false == $blog_single_sidebar ) {
				add_filter( 'keystone_show_sidebar', '__return_false' );
			}
		}
	}
}
add_action( 'wp', 'keystone_blog_sidebar_switch' );

if ( ! function_exists( 'keystone_display_post_categories' ) ) {
	function keystone_display_post_categories() {
		get_template_part( 'template-parts/post/category' );
	}
}
add_action( 'keystone_single_entry_content_top', 'keystone_display_post_categories', 5 );
add_action( 'keystone_entry_wrapper_top', 'keystone_display_post_categories', 5 );

if ( ! function_exists( 'keystone_display_post_title' ) ) {
	function keystone_display_post_title() {
		if ( is_single() ) {
			if ( apply_filters( 'keystone_blog_single_show_page_title', true ) ) : ?>
		        <h1 class="single-post-title"><?php the_title(); ?></h1>
		    <?php endif;
		} else { ?>
			<h2 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
		<?php }
	}
}
add_action( 'keystone_single_entry_content_top', 'keystone_display_post_title', 10 );
add_action( 'keystone_entry_wrapper_top', 'keystone_display_post_title', 10 );

if ( ! function_exists( 'keystone_display_post_meta' ) ) {
	function keystone_display_post_meta() {
		get_template_part( 'template-parts/post/meta' );
	}
}
add_action( 'keystone_single_entry_content_top', 'keystone_display_post_meta', 15 );
add_action( 'keystone_entry_wrapper_top', 'keystone_display_post_meta', 15 );

if ( ! function_exists( 'keystone_author_box_markup' ) ) {
	function keystone_author_box_markup() {
		if ( keystone_get_option( 'blog_single_author' ) && is_singular( 'post' ) ) {
			get_template_part( 'template-parts/post/author' );
		}
	}
}
add_action( 'keystone_single_entry_content_bottom', 'keystone_author_box_markup', 15 );

if ( ! function_exists( 'keystone_blog_related_posts' ) ) {
	function keystone_blog_related_posts() {
		if ( is_singular( 'post' ) && keystone_get_option( 'blog_single_related_switch' ) ) {
			get_template_part( 'template-parts/post/related' );
		}
	}
}
add_action( 'keystone_content_bottom', 'keystone_blog_related_posts' );

// Add container classes for search page options
if ( ! function_exists( 'keystone_search_classes' ) ) {
	function keystone_search_classes( $classes ) {
		$search_sidebar = true;
		$search_sidebar_position = 'sidebar-right';
		$search_sidebar_sticky = keystone_get_option( 'search_page_sticky_sidebar' );
		
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$search_sidebar_switch = keystone_get_option( 'search_page_sidebar' );
			$sidebar_position = keystone_get_option( 'search_page_sidebar_position' );
		}

		if ( is_search() ) {
			$classes[] = 'blog-layout-horizontal';
			if ( true == $search_sidebar ) {
				$classes[] = 'with-sidebar';
				$classes[] = $search_sidebar_position;
			}
			if ( $search_sidebar_sticky ) {
				$classes[] = 'sticky-sidebar';
			}
		}

		return $classes;
	}
}
add_action( 'keystone_container_class', 'keystone_search_classes' );

// Control the display of the search page sidebar
if ( ! function_exists( 'keystone_search_sidebar_switch' ) ) {
	function keystone_search_sidebar_switch() {
		$search_sidebar = true;
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$search_sidebar = keystone_get_option( 'search_page_sidebar' );
		}

		if ( is_search() ) {
			if ( false == $search_sidebar ) {
				add_filter( 'keystone_show_sidebar', '__return_false' );
			}
		}
	}
}
add_action( 'wp', 'keystone_search_sidebar_switch' );

// Search page title
if ( ! function_exists( 'keystone_overwrite_search_page_title' ) ) {
	function keystone_overwrite_search_page_title( $page_title ) {
		if ( '' != keystone_get_option( 'search_page_title' ) ) {
			$page_title = keystone_get_option( 'search_page_title' ) . ' <span>' . get_search_query() . '</span>';
		}
		return $page_title;
	}
}
add_filter( 'keystone_search_page_title', 'keystone_overwrite_search_page_title', 10, 2 );

if ( ! function_exists( 'keystone_single_post_tags' ) ) {
    function keystone_single_post_tags() {
		if ( ! has_tag() ) {
			return;
		}
		
		$post_tags = true;
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$post_tags = keystone_get_option( 'blog_single_tags' );
		}
		
		if ( is_single() && $post_tags == true ) {
			echo '<div class="entry-footer">';
			if ( 'post' === get_post_type() ) :
				$tags_list = get_the_tag_list( '', esc_attr_x( ', ', 'list item separator', 'maxreach' ) );
				if ( $tags_list ) {
				  the_tags( '<ul class="tags"><li>', '</li><li>', '</li></ul>' );
				}
			endif;
			echo '</div>';
		}
    }
}
add_action( 'keystone_single_entry_content_bottom', 'keystone_single_post_tags', 10 );

if ( ! function_exists( 'keystone_single_post_navigation' ) ) {
	function keystone_single_post_navigation() {
		$post_pagination = true;
		if ( class_exists( '\KeyStone\Plugin' ) ) {
			$post_pagination = keystone_get_option( 'blog_single_pagination' );
		}

        if ( is_single() && $post_pagination == true ) {

            $next_text = __( 'Next', 'maxreach' );
			$prev_text = __( 'Previous', 'maxreach' );

			the_post_navigation(
				apply_filters(
					'keystone_single_post_navigation',
					array(
						'next_text' => $next_text,
						'prev_text' => $prev_text,
					)
				)
			);
        }
    }
}
add_action( 'keystone_single_entry_content_bottom', 'keystone_single_post_navigation', 20 );

if ( ! function_exists( 'keystone_comment_form' ) ) {
	function keystone_comment_form() {
		if ( comments_open() || get_comments_number() ) {
            comments_template();
        }
    }
}
add_action( 'keystone_single_entry_content_bottom', 'keystone_comment_form', 25 );
add_action( 'keystone_entry_bottom', 'keystone_comment_form', 25 );

if ( ! function_exists( 'keystone_blog_featured_item' ) ) {
	function keystone_blog_featured_item() {
		$post_format = get_post_format();
		$has_thumbnail = has_post_thumbnail();
	
		if ( ( ( is_archive() || is_home() ) && $has_thumbnail ) || ( is_single() && $has_thumbnail && !in_array( $post_format, array( 'video', 'audio', 'gallery' ) ) ) ) {
			if ( is_single() ) {
				?>
				<div class="entry-image">
					<?php the_post_thumbnail( 'large' ); ?>
				</div>
				<?php
			} else {
				?>
				<div class="entry-image">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'large' ); ?></a>
				</div>
				<?php
			}
		}
	}
}
add_action( 'keystone_single_entry_content_top', 'keystone_blog_featured_item', 20 );
add_action( 'keystone_entry_top', 'keystone_blog_featured_item', 10 );

// Add modern single blog header markup
if ( ! function_exists( 'keystone_display_modern_blog_page_title' ) ) {
	function keystone_display_modern_blog_page_title() {
		if ( is_single() && get_post_type() === 'post' ) {
			$layout_output = '';
			$has_post_thumbnail = false;
			$blog_single_layout = apply_filters( 'keystone_hook_blog_single_layout', keystone_get_option( 'blog_single_layout' ) );
			if ( has_post_thumbnail() || wp_get_attachment_image_src( get_post_thumbnail_id() ) ) {
				$has_post_thumbnail = true;
			}

			if ( 'blog-single-layout-modern' == $blog_single_layout && $has_post_thumbnail ) {
				echo '<header id="page-header" class="page-header modern-entry-image"></header>';
			}
		}
	}
}
add_action( 'keystone_content_top', 'keystone_display_modern_blog_page_title' );

// Add class on post_class if no thumbnail
if ( ! function_exists( 'keystone_single_post_class' ) ) {
	function keystone_single_post_class( $classes ) {
		if ( is_single() ) {
			if ( ! has_post_thumbnail() || ! wp_get_attachment_image_src( get_post_thumbnail_id() ) ) {
				$classes[] = 'no-thumbnail';
			}
		}
		return $classes;
	}
}
add_filter( 'post_class', 'keystone_single_post_class' );

// Remove archive title prefix
add_filter( 'get_the_archive_title_prefix', '__return_empty_string' );
