<?php
/**
 * Theme header
 *
 * This is the template that displays all of the <head> section.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 */
 
 use KeyStone\Utils;

defined( 'ABSPATH' ) || exit;

?><!DOCTYPE html>
<?php keystone_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
    <?php keystone_head_top(); ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php wp_head(); ?>
    <?php keystone_head_bottom(); ?>
</head>

<body <?php body_class();?>>
<?php keystone_body_top(); ?>
<?php wp_body_open(); ?>
    <div id="page" class="site">
        <?php
            keystone_header_before();
            keystone_header();
            keystone_header_after();
            keystone_content_before();
    	?>
        <div id="content" class="site-content">
            <?php keystone_content_top(); ?>
