<?php
function maxcv_projects( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_style' => 'one', 'sc_columns' => 'col1', 'sc_layout' => 'fixed', 'posts_display' => '' ), $atts ) );
	
	$ow_post_type = 'maxcv_portfolio';
	$ow_post_tax = 'maxcv_portfolio_tax';
	
	$tax_args = array(
		'hide_empty' => false
	);
	
	if( '' === $posts_display ) :
		$posts_display = 9;		
	endif;
	
	$args = array(
		'post_type' => $ow_post_type,
		'posts_per_page' => $posts_display,
	);

	$qry = new WP_Query( $args );
	
	$colcss = "";	
	if( $sc_columns == "col1" ){
		$colcss = " col-md-4";
	}
	elseif( $sc_columns == "col2" ){
		$colcss = " col-md-3";
	}
	
	$layout_start = $layout_end = "";
	if( $sc_layout != "full") {
		$layout_start = '<div class="container">';
		$layout_end = '</div>';
	}
	
	ob_start();
	
	if( $sc_style == "one" ) {
		?>
		<?php echo html_entity_decode( $layout_start ); ?>
		<!-- Portfolio Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding portfolio-section portfolio-grid-page">
			<?php 
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title != "") { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle != "") { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php
				}
			?>
			<ul id="filters" class="portfolio-category">
				<li><a data-filter="*" class="active" href="#" title="Show All"><?php esc_html_e('Show All',"maxcv-toolkit"); ?></a></li>
				<?php
					$terms = get_terms( $ow_post_tax, $tax_args );
					if ( count( $terms > 0 ) && is_array( $terms ) ) {
						foreach ( $terms as $term ) {
							$termname = strtolower($term->name);
							$unexpected_str = array(" ","&","amp;",",",".","/");
							$termname = str_replace( $unexpected_str, '-', $termname);
							?>
							<li><a href="#" data-filter=".<?php echo esc_attr( $termname ); ?>" title="<?php echo esc_attr( $termname ); ?>"><?php echo esc_attr ( $term->name ); ?></a></li>						
							<?php
						}
					}
				?>
			</ul>
			<div class="portfolio-list portfolio-fitrow">
				<?php
				while ( $qry->have_posts() ) : $qry->the_post();
					$terms = get_the_terms( get_the_ID(), $ow_post_tax );
					$termsname = array();
					$terms_dashed = array();
					if ( count( $terms > 0 ) && is_array( $terms ) ) {
						foreach ( $terms as $term ) {
							$termsname[] = strtolower( $term->name );
							$unexpected_str = array(" ","&","amp;",",",".","/");
							$terms_dashed[] = str_replace( $unexpected_str, '-', strtolower( $term->name ) );
							}
						$taxonomies = implode(" ", $terms_dashed );
						$taxonomies_plus = implode(" + ", $termsname );
					}
					?>
					<div class="portfolio-box<?php echo esc_attr( $colcss ); ?> col-sm-4 col-xs-6 no-padding <?php echo esc_attr($taxonomies); ?>">
						<div class="portfolio-content-box">
							<?php the_post_thumbnail( 'maxcv_476_476' ); ?>
							<div class="portfolio-content">
								<span>
									<?php if(get_post_meta( get_the_ID(),"maxcv_cf_portfolio_url", true ) != "" ) { ?><a href="<?php echo esc_url(get_post_meta( get_the_ID(),"maxcv_cf_portfolio_url", true ) ); ?>" title="Link"><i class="icon icon-Linked"></i></a><?php } ?>
									<a class="zoom-in" href="<?php echo esc_url(wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ) ); ?>" title="<?php the_title(); ?>"><i class="icon icon-Search"></i></a>
								</span>
								<h3>
									<?php echo esc_attr($taxonomies); ?>
									<span><?php the_title(); ?></span>
								</h3>
							</div>
						</div>
					</div>
					<?php
				endwhile;
				
				// Reset Post Data
				wp_reset_postdata();
				?>	
			</div>
		</div><!-- Portfolio Section /- -->
		<?php echo html_entity_decode( $layout_end ); ?>
		<?php
	}
	elseif( $sc_style == "two" ) {
		?>
		<?php echo html_entity_decode( $layout_start ); ?>
		<!-- Portfolio Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding portfolio-section portfolio-fullwidth-page">
			<?php 
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title) { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle) { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php
				}
			?>

			<ul id="filters" class="portfolio-category">
				<li><a data-filter="*" class="active" href="#" title="Show All"><?php esc_html_e('Show All',"maxcv-toolkit"); ?></a></li>
				<?php
					$terms = get_terms( $ow_post_tax, $tax_args );
					if ( count( $terms > 0 ) && is_array( $terms ) ) {
						foreach ( $terms as $term ) {
							$termname = strtolower($term->name);
							$unexpected_str = array(" ","&","amp;",",",".","/");
							$termname = str_replace( $unexpected_str, '-', $termname);
							?>
							<li><a href="#" data-filter=".<?php echo esc_attr( $termname ); ?>" title="<?php echo esc_attr( $termname ); ?>"><?php echo esc_attr ( $term->name ); ?></a></li>						
							<?php
						}
					}
				?>
			</ul>
			
			<div class="portfolio-list portfolio-fitrow">
				<?php
					while ( $qry->have_posts() ) : $qry->the_post();
						$terms = get_the_terms( get_the_ID(), $ow_post_tax );
						$termsname = array();
						$terms_dashed = array();
						if ( count( $terms > 0 ) && is_array( $terms ) ) {
							foreach ( $terms as $term ) {
								$termsname[] = strtolower( $term->name );
								$unexpected_str = array(" ","&","amp;",",",".","/");
								$terms_dashed[] = str_replace( $unexpected_str, '-', strtolower( $term->name ) );
								}
							$taxonomies = implode(" ", $terms_dashed );
							$taxonomies_plus = implode(" + ", $termsname );
						}
						?>
						<div class="portfolio-box<?php echo esc_attr( $colcss ); ?> col-sm-4 col-xs-6 no-padding <?php echo esc_attr($taxonomies); ?>">
							<div class="portfolio-content-box">
								<?php the_post_thumbnail( 'maxcv_476_476' ); ?>
								<div class="portfolio-content">
									<span>
										<?php if(get_post_meta( get_the_ID(),"maxcv_cf_portfolio_url", true ) != "" ) { ?><a href="<?php echo esc_url(get_post_meta( get_the_ID(),"maxcv_cf_portfolio_url", true ) ); ?>" title="Link"><i class="icon icon-Linked"></i></a><?php } ?>
										<a class="zoom-in" href="<?php echo esc_url(wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ) ); ?>" title="<?php the_title(); ?>"><i class="icon icon-Search"></i></a>
									</span>
									<h3><?php echo esc_attr($taxonomies); ?><span><?php the_title(); ?></span></h3>
								</div>
							</div>
						</div>
						<?php
					endwhile;
					
					// Reset Post Data
					wp_reset_postdata();
				?>	
			</div>
		</div><!-- Portfolio Section /- -->
		<?php echo html_entity_decode( $layout_end ); ?>
		<?php
	}
	return ob_get_clean();
}
add_shortcode('maxcv_projects', 'maxcv_projects');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_projects',
		'name' => __( 'Our Project', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => __( 'Number of columns', "maxcv-toolkit" ),
				'param_name' => 'sc_columns',
				'value' => array(
					__( '3 Columns', "maxcv-toolkit" ) => 'col1',
					__( '4 Columns', "maxcv-toolkit" ) => 'col2',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Grid Layout', "maxcv-toolkit" ),
				'param_name' => 'sc_layout',
				'value' => array(
					__( 'Fixed', "maxcv-toolkit" ) => 'fixed',
					__( 'Full', "maxcv-toolkit" ) => 'full',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Grid Style', "maxcv-toolkit" ),
				'param_name' => 'sc_style',
				'value' => array(
					__( 'Style 1', "maxcv-toolkit" ) => 'one',
					__( 'Style 2', "maxcv-toolkit" ) => 'two',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
			
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Post Per Page Display", "maxcv-toolkit"),
				"param_name" => "posts_display",
				"holder" => "div",
			),
		),
	) );
}
?>