<?php
function maxcv_testimonials( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_bg' => ''), $atts ) );
	
	if( $sc_bg != '' ) {
		$style = " style='background-image: url(".wp_get_attachment_url( $sc_bg ).");'";
	}
	else {
		$style = "";
	}
	
	ob_start();
	
	?>

	<!-- Testimonial Section -->
	<div  <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding testimonial-section"<?php echo html_entity_decode( $style ); ?>>
		<!-- Container -->
		<div class="container">
			<?php	
				if($sc_title != "" || $sc_subtitle != "") { 
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title) { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle) { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php
				}
				if( maxcv_options("opt_testimonials") != "" ) {
					?>
					<!-- Testimonial -->
					<div id="testimonial-carousel" class="carousel slide" data-ride="carousel">
						<!-- Wrapper for slides -->
						<div class="carousel-inner" role="listbox">
							<?php
								$i = 0;
								foreach( maxcv_options("opt_testimonials") as $single_item ) {
									?>
									<div class="item<?php if($i == 0) { echo " active"; } ?>">
										<?php echo wpautop($single_item["description"] ); ?>
										<div class="testi-img">
											<?php 
												if($single_item["attachment_id"] !="" ) {
													?>
													<i>
														<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'maxcv_60_60' ); ?>
													</i>
													<?php
												}
											?>
										</div>
										<div class="testi-title">
											<?php if($single_item["title"] != "" ) { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php } ?>
											<?php if($single_item["textOne"] != "" ) { ?><p><?php echo esc_attr($single_item["textOne"] ); ?></p><?php } ?>
										</div>
									</div>
									<?php
									$i++;
								}
							?>
						</div>
						
						<!-- Indicators -->
						<ol class="carousel-indicators">
							<?php
								for( $j=0; $j < $i; $j++ ) {
									?>
									<li data-target="#testimonial-carousel" data-slide-to="<?php echo esc_attr( $j ); ?>"<?php if( $j == 0 ) { echo ' class="active"'; } ?>></li>
									<?php
								}
							?>
						</ol>
						<!-- Controls -->
						<a class="left carousel-control" href="#testimonial-carousel" role="button" data-slide="prev">
							<div class="num"></div>
							<i class="arrow_carrot-left"></i>
						</a>
						<a class="right carousel-control" href="#testimonial-carousel" role="button" data-slide="next">
							<div class="num"></div>
							<i class="arrow_carrot-right"></i>
						</a>						
					</div><!-- Testimonial /- -->
					<?php
				}
			?>
		</div><!-- Container /- -->
	</div><!-- Testimonial Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_testimonials', 'maxcv_testimonials');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_testimonials',
		'name' => __( 'Testimonials', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			
			array(
				'type' => 'attach_image',
				'heading' => __( 'Background Image', "maxcv-toolkit" ),
				'param_name' => 'sc_bg',
			),
			
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
		),
	) );
}
?>