<?php
function maxcv_services( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_image' => ''), $atts ) );
	
	ob_start();
	
	?>

	<!-- Services Section -->
	<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding services-section">
		<!-- Container -->
		<div class="container">
			<?php 
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title) { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle) { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php 
					
				}
			?>
			<!-- Row -->
			<div class="row">
				<?php
				if( maxcv_options("opt_servicesleft") != "" ) {
					?>
					<div class="col-md-4 col-sm-6 srv srv-left">
						<?php 
							foreach( maxcv_options("opt_servicesleft") as $single_item ) {
								?>
								<div class="srv-box">
									<?php 
										if($single_item["attachment_id"] != "" ) { 
											?>
											<i>
												<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'full' ); ?>
											</i>
											<?php
										}
										if($single_item["title"] != "" ) { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php }
										echo wpautop($single_item["description"] ); 
									?>
								</div>
								<?php
							}
						?>
					</div>
					<?php
				}
				if($sc_image != "" ) {
					?>
					<div class="col-md-4 col-sm-6 srv-img">
						<?php echo wp_get_attachment_image($sc_image,'maxcv_335_500'); ?>
					</div>
					<?php
				}
				if( maxcv_options("opt_servicesright") != "" ) {
					?>
					<div class="col-md-4 col-sm-6 srv srv-right">
						<?php 
							foreach( maxcv_options("opt_servicesleft") as $single_item ) {
								?>
								<div class="srv-box">
									<?php
										if($single_item["attachment_id"] != "" ) { 
											?>
											<i><?php echo wp_get_attachment_image( $single_item["attachment_id"], 'full' ); ?></i>
											<?php
										}
										if($single_item["title"] != "" ) { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php }
										echo wpautop($single_item["description"] );
									?>
								</div>
								<?php
							}
						?>
					</div>
					<?php
				}?>
			</div><!-- Row /- -->
		</div><!-- Container /- -->
	</div><!-- Services Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_services', 'maxcv_services');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_services',
		'name' => __( 'Services', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Image', "maxcv-toolkit" ),
				'param_name' => 'sc_image',
			),
		),
	) );
}
?>