<?php
function maxcv_pricetable( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => ''), $atts ) );

	ob_start();
		
	?>
	
	<!-- Pricing Section -->
	<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding pricing-section">
		<!-- Container -->
		<div class="container">
			<?php 
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title != "") { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle != "") { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php 
					
				}
			?>
			<!-- Row -->
			<div class="row">
				<?php
					if( maxcv_options("opt_pricetable") != "" ) {
						foreach( maxcv_options("opt_pricetable") as $single_item ) {
							?>
							<!-- Pricing -->
							<div class="col-md-4 col-sm-6 pricing">
								<div class="pricing-box">
									<div class="pricing-top">
										<?php 
											if($single_item["textOne"] != "") {
												?>
												<h3>
													<sup><?php esc_html_e('$',"maxcv-toolkit"); ?></sup>
													<?php echo esc_attr($single_item["textOne"] ); ?>
													<sub><?php esc_html_e('hr',"maxcv-toolkit"); ?></sub>
												</h3>
												<?php
											}
										if($single_item["title"] != "") { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php } ?>
									</div>
									<div class="pricing-center">
										<?php 
											if($single_item["attachment_id"] != "") { 
													?>
												<i>
													<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'full' ); ?>
												</i>
												<?php
											}
										?>
										<ul>
											<?php if($single_item["textTwo"] != "") { ?><li><?php echo esc_attr($single_item["textTwo"] ); ?></li><?php } ?>
											<?php if($single_item["textThree"] != "") { ?><li><?php echo esc_attr($single_item["textThree"] ); ?></li><?php } ?>
											<?php if($single_item["textFour"] != "") { ?><li><?php echo esc_attr($single_item["textFour"] ); ?></li><?php } ?>
											<?php if($single_item["textFive"] != "") { ?><li><?php echo esc_attr($single_item["textFive"] ); ?></li><?php } ?>
											<?php if($single_item["textSix"] != "") { ?><li><?php echo esc_attr($single_item["textSix"] ); ?></li><?php } ?>
											<?php if($single_item["textSeven"] != "") { ?><li><?php echo esc_attr($single_item["textSeven"] ); ?></li><?php } ?>
										</ul>
									</div>
									<div class="pricing-bottom">
										<?php if($single_item["url"] != "") { ?><a href="<?php echo esc_attr($single_item["url"] ); ?>" title="<?php echo esc_attr($single_item["textEight"] ); ?>"><?php echo esc_attr($single_item["textEight"] ); ?></a><?php } ?>
										<?php if($single_item["textNine"] != "") { ?><p><?php echo esc_attr($single_item["textNine"] ); ?></p><?php } ?>
									</div>
								</div>
							</div><!-- Pricing /- -->
							<?php
						}
					}
				?>
			</div><!-- Row /- -->
		</div><!-- Container /- -->
	</div><!-- Pricing Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_pricetable', 'maxcv_pricetable');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_pricetable',
		'name' => __( 'Price Table', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),

		),
	) );
}
?>