<?php
function maxcv_newsletter( $atts, $content = null ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_bg' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_newslattertxt' => ''), $atts ) );
	
	if( $sc_bg != '' ) {
		$style = " style='background-image: url(".wp_get_attachment_url( $sc_bg ).");'";
	}
	else {
		$style = "";
	}
	
	ob_start();
	
	?>
	<!-- Newsletter Section -->
	<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding newsletter-section"<?php echo html_entity_decode( $style ); ?>>
		<!-- Container -->
		<div class="container">
			<?php 
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header section-header2">
						<?php if( $sc_title != "" ) { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if( $sc_subtitle != "" ) { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php
				}
			?>
			<div class="col-md-8 newsletter-box">
				<?php echo do_shortcode( $content ); ?>
				<?php if($sc_newslattertxt != "") { ?><p><?php echo esc_attr($sc_newslattertxt); ?></p><?php } ?>
			</div>
		</div><!-- Container /- -->
	</div><!-- Newsletter Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_newsletter', 'maxcv_newsletter');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_newsletter',
		'name' => __( 'Our Newsletter', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Background Image', "maxcv-toolkit" ),
				'param_name' => 'sc_bg',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
			array(
				"type" => "textarea_html",
				"class" => "",
				"heading" => esc_html("Contact Form Shortcode", "maxcv-toolkit"),
				"description" => esc_html('e.g : [mc4wp_form id="71"]', "maxcv-toolkit"),
				"param_name" => "content",
				"holder" => "div",
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Newsletter Text', "maxcv-toolkit" ),
				'param_name' => 'sc_newslattertxt',
			),
		),
	) );
}
?>