<?php
function maxcv_blog( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_posts' => '', 'sc_layout' => 'one'  ), $atts ) );

	$ow_post_type = 'post';

	if( '' === $sc_posts ) :
		$sc_posts = 3;	
	endif;

	$qry = new WP_Query( array(
	
		'post_type' => $ow_post_type,
		'posts_per_page' => $sc_posts,
		
	) );

	ob_start();
	
	if($sc_layout == 'one'){
		?>
		<!-- Latest News -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding latest-news">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "" || $sc_subtitle != "" ) {
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title != "") { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle != "") { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
				?>
				<!-- Row -->
				<div class="row">
					<?php
					while ( $qry->have_posts() ) : $qry->the_post();
						$css = "";
						if( ! has_post_thumbnail() ) {
							$css = ' no_post_thumb';
						} 
						?>
						<!-- Latest Post -->
						<div class="col-md-4 col-sm-6 col-xs-6 latest-post<?php echo html_entity_decode( $css ); ?>">
							<article class="type-post">
								<div class="entry-cover">
									<a href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail('maxcv_370_250'); ?>
									</a>
									<h3 class="entry-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>
								</div>
								<div class="entry-header">
									<div class="entry-meta">
										<div class="post-date">
											<a href="<?php the_permalink(); ?>"><b><?php echo get_the_date( 'd', get_the_ID() ); ?></b> <b><?php echo get_the_date( 'M', get_the_ID() );?> </b> <?php echo get_the_date( 'Y', get_the_ID() ); ?></a>
										</div>
										<div class="post-comment">
											<a href="<?php comments_link(); ?>" title="Comment"><i class="fa fa-comment-o"></i>
												<?php 
													comments_number( __( '(0)', "maxcv-toolkit" ),
													__( '(1)', "maxcv-toolkit" ),
													__( '(%)', "maxcv-toolkit" )); 
												?>
											</a>
										</div>
										<div class="post-likes">
											<?php if( function_exists('maxcv_get_simple_likes_button') ) { echo maxcv_get_simple_likes_button( get_the_ID() ); } ?>
										</div>
										<div class="byline">
											<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" title="<?php echo get_the_author(); ?>"><i class="icon icon-User"></i> <?php esc_html_e('By ',"maxcv-toolkit"); ?><?php echo get_the_author(); ?></a>
										</div>
									</div>
								</div>
								<div class="entry-content">
									<p><?php echo wp_html_excerpt( strip_shortcodes( get_the_content() ), 100, ' [...]' ); ?></p>
									<a href="<?php the_permalink(); ?>"><?php esc_html_e('Read more ',"maxcv-toolkit"); ?><i class="arrow_right"></i></a>
								</div>
							</article>
						</div><!-- Latest Post -->
						<?php
					endwhile;
							
					// Reset Post Data
					wp_reset_postdata();
					?>	
				</div><!-- Row /- -->
			</div><!-- Container /- -->
		</div><!-- Latest News /- -->
		<?php
	}
	elseif( $sc_layout == "two" ) {
		query_posts('posts_per_page='.get_option('posts_per_page').'&paged='. get_query_var('paged'));
		if ( have_posts() ) {
			?>
			<div class="blog-listing">
				<?php
				// Start the loop.
				while ( have_posts() ) : the_post();

					// Include the page content template.
					get_template_part( "template-parts/content",get_post_format());

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				// End the loop.
				endwhile;
				
				// Previous/next page navigation.				
				the_posts_pagination( array(
					'prev_text'          => wp_kses( __( '<i class="fa fa-angle-left"></i> Previous', "maxcv-toolkit" ), array( 'i' => array( 'class' => array() ) ) ),
					'next_text'          => wp_kses( __( 'Next <i class="fa fa-angle-right"></i>', "maxcv-toolkit" ), array( 'i' => array( 'class' => array() ) ) ),
					'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html( 'Page', "maxcv-toolkit" ) . ' </span>',
				) );		
				
				// Reset Query
				wp_reset_query();		
				?>
			</div>
			<?php
		}
	}

	return ob_get_clean();
}
add_shortcode('maxcv_blog', 'maxcv_blog');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_blog',
		'name' => __( 'Blog', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => __( 'Select a Layout', "maxcv-toolkit" ),
				'param_name' => 'sc_layout',
				'value' => array(
					__( 'Layout 1', "maxcv-toolkit" ) => 'one',
					__( 'Layout 2', "maxcv-toolkit" ) => 'two',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'No of Posts', "maxcv-toolkit" ),
				'param_name' => 'sc_posts',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one' ) ),
			),
			array(
				"type" => "label",
				"class" => "",
				"heading" => __("No Need Of Settings", "maxcv-toolkit"),
				"param_name" => "label_blog",
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two' ) ),
			),
		),
	) );
}
?>