<?php
function maxcv_contactmap( $atts, $content = null ) {

	extract( shortcode_atts(
	
		array(
			'sc_id' => '',
			'vc_map_lati' => '',
			'vc_map_longi' => '',
			'vc_marker' => '',
			'sc_bg' => '',
			'vc_address' => '',
			'sc_phoneone' => '',	
			'sc_phonetwo' => '',	
			'sc_addressone' => '',	
			'sc_addresstwo' => '',
			'sc_worktimeone' => '',
			'sc_worktimetwo' => '',
			
		), $atts )
	);
	
	if( $sc_bg != '' ) {
		$style = " style='background-image: url(".wp_get_attachment_url( $sc_bg ).");'";
	}
	else {
		$style = "";
	}

	ob_start();
	
	?>

	<!-- Map Section -->
	<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding map-section">
		<div id="map-canvas-contact" class="map-canvas"  data-lat="<?php echo esc_html( $vc_map_lati ); ?>" data-lng="<?php echo esc_html( $vc_map_longi ); ?>" data-string="<?php echo esc_html( $vc_address ); ?>" data-marker="<?php if($vc_marker !=''){ echo esc_url(wp_get_attachment_url($vc_marker,"")); } else { echo esc_url( MAXCV_LIB ).'images/marker.png'; }?>" data-zoom="10"></div>	
		<!-- Get In Touch -->
		<div class="col-md-6 get-in-touch"<?php echo html_entity_decode( $style ); ?>>
			<!-- Section Header -->
			<div class="section-header">
				<h3><?php esc_html_e('GET IN TOUCH',"maxcv-toolkit"); ?></h3>
			</div><!-- Section Header /- -->
			<?php
				if($sc_phoneone != "" || $sc_phonetwo != "" ) {
					?>
					<div class="get-in-touch-box">
						<div class="get-in-touch-detail">
							<i class="icon icon-Phone"></i>
							<h4><?php esc_html_e('CALL ME',"maxcv-toolkit"); ?></h4>
							<?php if($sc_phoneone != "") { ?><p><a href="tel:<?php echo esc_html(str_replace(' ', '-', $sc_phoneone) ); ?>" title="<?php echo esc_html(str_replace(' ', '-', $sc_phoneone) ); ?>"><?php esc_html_e('Office : ',"maxcv-toolkit"); ?><?php echo esc_html($sc_phoneone); ?></a></p><?php } ?>
							<?php if($sc_phonetwo != "") { ?><p><a href="tel:<?php echo esc_html(str_replace(' ', '-', $sc_phonetwo) ); ?>" title="<?php echo esc_html(str_replace(' ', '-', $sc_phonetwo) ); ?>"><?php esc_html_e('Cell : ',"maxcv-toolkit"); ?><?php echo esc_html($sc_phonetwo); ?></a></p><?php } ?>
						</div>
					</div>
					<?php
				}
				if($sc_addressone != "" || $sc_addresstwo != "") {
					?>
					<div class="get-in-touch-box">
						<div class="get-in-touch-detail">
							<i class="icon icon-Pointer"></i>
							<h4><?php esc_html_e('ADDRESS',"maxcv-toolkit"); ?></h4>
							<?php if($sc_addressone != "") { ?><p><?php echo esc_attr($sc_addressone); ?></p><?php } ?>
							<?php if($sc_addresstwo != "") { ?><p><?php echo esc_attr($sc_addresstwo); ?></p><?php } ?>
						</div>
					</div>
					<?php
				}
				if($sc_worktimeone != "" || $sc_worktimetwo != "") {
					?>
					<div class="get-in-touch-box">
						<div class="get-in-touch-detail">
							<i class="icon icon-Time"></i>
							<h4><?php esc_html_e('WORKING HOURS',"maxcv-toolkit"); ?></h4>
							<?php if($sc_worktimeone != "") { ?><p><?php esc_html_e('Monday - Friday : ',"maxcv-toolkit"); ?><?php echo esc_attr($sc_worktimeone); ?></p><?php } ?>
							<?php if($sc_worktimetwo != "") { ?><p><?php esc_html_e('Saturday : ',"maxcv-toolkit"); ?><?php echo esc_attr($sc_worktimetwo); ?></p><?php } ?>
						</div>
					</div>
					<?php
				}
			?>
		</div><!-- Get In Touch /- -->
	</div><!-- Map Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_contactmap', 'maxcv_contactmap');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_contactmap',
		'name' => __( 'Contact Map', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Latitude :", "maxcv-toolkit"),
				"param_name" => "vc_map_lati",
				"description" => esc_html("Example :-37.910102", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Longitude :", "maxcv-toolkit"),
				"param_name" => "vc_map_longi",
				"description" => esc_html("Example :144.764911", "maxcv-toolkit"),
			),
			array(
				"type" => "attach_image",
				"class" => "",
				"heading" => esc_html("Marker Image :", "maxcv-toolkit"),
				"param_name" => "vc_marker",
			),
			
			array(
				'type' => 'attach_image',
				'heading' => __( 'Contact Background Image', "maxcv-toolkit" ),
				'param_name' => 'sc_bg',
			),
			
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Marker Address :", "maxcv-toolkit"),
				"param_name" => "vc_address",
				"description" => esc_html("Example:1234 Street Road City Name, IN 567 890.", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Phone Number 1:", "maxcv-toolkit"),
				"param_name" => "sc_phoneone",
				"description" => esc_html("Example:+ 123-456-789-456", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Phone Number 2 :", "maxcv-toolkit"),
				"param_name" => "sc_phonetwo",
				"description" => esc_html("Example:+ 126-156-489-756", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Address Line 1:", "maxcv-toolkit"),
				"param_name" => "sc_addressone",
				"description" => esc_html("Example:1234 Street Road", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Address Line 2:", "maxcv-toolkit"),
				"param_name" => "sc_addresstwo",
				"description" => esc_html("Example:City Name, IN 567 890.", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Monday To Friday :", "maxcv-toolkit"),
				"param_name" => "sc_worktimeone",
				"description" => esc_html("Example:09am - 18pm", "maxcv-toolkit"),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html("Monday To Friday :", "maxcv-toolkit"),
				"param_name" => "sc_worktimetwo",
				"description" => esc_html("Example:09am - 1pm", "maxcv-toolkit"),
			),
		),
	) );
}
?>