<?php
function maxcv_content_block( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '','sc_subtitle' => '', 'sc_firsttxt' => '', 'sc_secondtxt' => '', 'sc_lasttxt' => '', 'sc_btntxt' => '', 'sc_btnurl' => '', 'sc_secbtntxt' => '', 'sc_secbtnurl' => '', 'sc_layout' => 'one' ), $atts ) );
	
	ob_start();
	
	if($sc_layout == 'one') {
		?>
		<!-- Work Experiance Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding work-experiance-section">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "") { 
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title != "") { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle != "") { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
					if( maxcv_options("opt_workexp") != "" ) {
						?>
						<div class="row">
							<?php
								$i = 1;
								foreach( maxcv_options("opt_workexp") as $single_item ) {
								?>
								<div class="col-md-4 col-sm-6 col-xs-6 work-experiance">
									<div class="work-experiance-box">
										<h2><?php echo sprintf('%02d', $i); ?></h2>
										<?php if($single_item['title'] != "" ) { ?><h3><?php echo esc_attr($single_item['title'] ); ?></h3><?php } ?>
										<?php if($single_item['textOne'] != "" || $single_item['textTwo'] != "" ) { ?><h4><?php echo esc_attr($single_item['textOne'] ); ?> <span><?php echo esc_attr($single_item['textTwo'] ); ?></span></h4><?php } ?> 
										<?php echo wpautop( $single_item["description"] ); ?>
									</div>
								</div>
								<?php
								$i++;
								}
							?>
						</div>
						<?php
					}
				?>
			</div><!-- Container /- -->
		</div><!-- Work Experiance Section /- -->
		<?php 
	}
	elseif($sc_layout == 'two') {
		?>
		<!-- What We Do -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding what-do-section">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "" || $sc_subtitle != "") {
						?>
						<!-- Section Header -->
						<div class="section-header section-header2">
							<?php if($sc_title) { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle) { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
				?>
				<!-- Row -->
				<div class="row">
					<?php
						if( maxcv_options("opt_workdo") != "" ) {
							foreach( maxcv_options("opt_workdo") as $single_item ) {
								?>
								<div class="col-md-4 col-sm-4 col-xs-6 what-do-box">
									<?php 
										if($single_item["title"] !="" ) { 
											?>	
											<i>
												<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'full' ); ?>
											</i>
											<?php
										}	
										if($single_item["title"] !="" ) { ?><h3><?php echo esc_attr($single_item["title"] ); ?></h3><?php }
										echo wpautop($single_item["description"] ); 
									?>
								</div>
								<?php
							}
						}
					?>
				</div><!-- Row /- -->
			</div><!-- Container /- -->
		</div><!-- What We Do /- -->
		<?php 
	}
	elseif($sc_layout == "three") {
		?>
		<!-- Education Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding education-section">
			<!-- Container -->
			<div class="container">
				<?php
					if($sc_title != "" || $sc_subtitle != "" ) {
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title != ""){ ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle != ""){ ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
				?>
				<!-- Row -->
				<div class="row">
					<?php
						if( maxcv_options("opt_education") != "" ) {
							foreach( maxcv_options("opt_education") as $single_item ) {
								?>
								<!-- Education Box -->
								<div class="col-md-12 education-box">
									<?php if( $single_item["title"] != "" || $single_item["textOne"] != "" ) { ?><h3><?php echo esc_attr($single_item["title"] ); ?> <span><?php echo esc_attr($single_item["textOne"] ); ?></span></h3><?php } ?>
									<div class="education-left">
										<div class="education-content">
											<h4><a href="<?php echo esc_attr($single_item["url"] ); ?>" title="<?php echo esc_attr($single_item["textTwo"] ); ?>"><?php echo esc_attr($single_item["textTwo"] ); ?></a></h4>
											<?php if( $single_item["textThree"] != "" ) { ?><h6><?php echo esc_attr($single_item["textThree"] ); ?></h6><?php } ?>
											<?php echo wpautop($single_item["description"] ); ?>
										</div>
									</div>
								</div><!-- Education Box /- -->
								<?php
							}
						}
					?>
				</div><!-- Row /- -->
			</div><!-- Container /- -->
		</div><!-- Education Section /- -->
		<?php
	}
	elseif($sc_layout == 'four') {
		if( maxcv_options("opt_stacounter") != "" ) {
			?>
			<!-- Counter Section -->
			<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?>  class="container-fluid no-padding statistics-section">
				<!-- Container -->
				<div class="container">
					<?php
						$i = 1;
						foreach( maxcv_options("opt_stacounter") as $single_item ) {
							?>
							<div class="col-md-3 col-sm-6 col-xs-6 counter-box">
								<div class="counter-details">
									<?php
										if($single_item["attachment_id"] != "" ) {
											?>
											<i>
												<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'full' ); ?>
											</i>
											<?php
										}
										if($single_item["textOne"] != "" || $single_item["title"] != "" ) {
											?>
											<h3>
												<span id="statistics_count-<?php echo esc_attr($i); ?>" data-statistics_percent="<?php echo esc_attr($single_item["textOne"] ); ?>"></span> 
												<?php echo esc_attr($single_item["title"] ); ?>
											</h3>
											<?php
										}
									?>
								</div>
							</div>
							<?php
						$i++;
						}
					?>
				</div><!-- Container /- -->
			</div><!-- Counter Section /- -->
			<?php
		}
	}
	elseif($sc_layout == 'five') {
		?>
		<!-- Award Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding award-section">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "" || $sc_subtitle != "" ) {
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title != "" ) {  ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle != "" ) {  ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
				?>
				<div class="row">
					<?php
						if( maxcv_options("opt_award") != "" ) {
							foreach( maxcv_options("opt_award") as $single_item ) {
							?>
							<div class="col-md-4 col-sm-6 award-box">
								<div class="award-detail">
									<?php
										if($single_item["textOne"] != "" || $single_item["title"] ) {
											?>
											<h6><b><?php echo esc_attr($single_item["textOne"] ); ?></b> <span><?php echo esc_attr($single_item["title"] ); ?></span></h6>
											<?php
										}
										if($single_item["textTwo"] != "" || $single_item["textThree"] ) {
											?>
											<div class="award-detail-box">
												<h5><?php echo esc_attr($single_item["textTwo"] ); ?><span><?php echo esc_attr($single_item["textThree"] ); ?></span></h5>
											</div>
											<?php
										}
										if($single_item["textFour"] != "" || $single_item["textFive"] ) {
											?>
											<div class="award-detail-box">
												<h5><?php echo esc_attr($single_item["textFour"] ); ?><span><?php echo esc_attr($single_item["textFive"] ); ?></span></h5>
											</div>
											<?php
										}
										if($single_item["textSix"] != "" || $single_item["textSeven"] ) {
											?>
											<div class="award-detail-box">
												<h5><?php echo esc_attr($single_item["textSix"] ); ?><span><?php echo esc_attr($single_item["textSeven"] ); ?></span></h5>
											</div>
											<?php
										}
										if($single_item["textEight"] != "" || $single_item["textNine"] ) {
											?>
											<div class="award-detail-box">
												<h5><?php echo esc_attr($single_item["textEight"] ); ?><span><?php echo esc_attr($single_item["textNine"] ); ?></span></h5>
											</div>
											<?php
										}
									?>
								</div>
							</div>
							<?php
							}
						}
					?>
				</div>
			</div><!-- Container /- -->
		</div><!-- Award Section /- -->
		<?php
	}
	elseif($sc_layout == 'six'){
		?>
		<!-- Callout Section -->
		<div class="container-fluid no-padding callout-section">
			<!-- Container -->
			<div class="container">
				<?php if($sc_firsttxt != "" || $sc_secondtxt != "" || $sc_lasttxt != "") { ?><h5><?php echo esc_attr($sc_firsttxt); ?> <span><?php echo esc_attr($sc_secondtxt); ?></span> <?php echo esc_attr($sc_lasttxt); ?></h5><?php } ?>
				<?php if($sc_btnurl != "") { ?><a href="<?php echo esc_url($sc_btnurl); ?>" class="btn1" title="<?php echo esc_attr($sc_btntxt); ?>"><?php echo esc_attr($sc_btntxt); ?></a><?php } ?>
				<?php if($sc_secbtnurl != "") { ?><a href="<?php echo esc_url($sc_secbtnurl); ?>" title="<?php echo esc_attr($sc_secbtntxt); ?>"><?php echo esc_attr($sc_secbtntxt); ?></a><?php } ?>
			</div><!-- Container /- -->
		</div><!-- Callout Section /- -->
		<?php
	}
	return ob_get_clean();
}
add_shortcode('maxcv_content_block', 'maxcv_content_block');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_content_block',
		'name' => __( 'Content Block', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => __( 'Select a Layout', "maxcv-toolkit" ),
				'param_name' => 'sc_layout',
				'value' => array(
					__( 'Layout 1 Work Experience', "maxcv-toolkit" ) => 'one',
					__( 'Layout 2 What We Do', "maxcv-toolkit" ) => 'two',
					__( 'Layout 3 Education', "maxcv-toolkit" ) => 'three',
					__( 'Layout 4 Counter', "maxcv-toolkit" ) => 'four',
					__( 'Layout 5 Awards Section', "maxcv-toolkit" ) => 'five',
					__( 'Layout 6', "maxcv-toolkit" ) => 'six',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one','two','three','four','five') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one','two','three','five') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one','two','three','five' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title First Text', "maxcv-toolkit" ),
				'param_name' => 'sc_firsttxt',
				'holder' => 'div',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Second Text', "maxcv-toolkit" ),
				'param_name' => 'sc_secondtxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Last Text', "maxcv-toolkit" ),
				'param_name' => 'sc_lasttxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button Text 1', "maxcv-toolkit" ),
				'param_name' => 'sc_btntxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button URL 1', "maxcv-toolkit" ),
				'param_name' => 'sc_btnurl',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button Text 2', "maxcv-toolkit" ),
				'param_name' => 'sc_secbtntxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button URL 2', "maxcv-toolkit" ),
				'param_name' => 'sc_secbtnurl',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'six' ) ),
			),
		),
	) );
}
?>