<?php
function maxcv_contactform( $atts ) {

	extract( shortcode_atts(
		array(
			
			'sc_id' => '',
			'id' => '',
			'sc_title' => '',
			'sc_subtitle' => '',
			
		), $atts )
	);

	ob_start();	
	
	?>
	<!-- Contact Section -->
	<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding contact-section">
		<!-- Container -->
		<div class="container">
			<?php
				if($sc_title != "" || $sc_subtitle != "" ) {
					?>
					<!-- Section Header -->
					<div class="section-header">
						<?php if($sc_title != "") { ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
						<?php if($sc_subtitle != "") { ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
					</div><!-- Section Header /- -->
					<?php 
					
				}
			?>
			<!-- Contact Form -->
			<div class="col-md-8 no-padding contact-form">
				<?php echo do_shortcode('[contact-form-7 id="'.esc_attr( $id ).'"]'); ?>
			</div><!-- Contact Form /- -->
		</div><!-- Container /- -->
	</div><!-- Contact Section /- -->
	<?php
	return ob_get_clean();
}
add_shortcode('maxcv_contactform', 'maxcv_contactform');

if( function_exists('vc_map') ) {
	
	/**
	 * Add Shortcode To Visual Composer
	*/
	$maxcv_cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

	$maxcv_contactforms = array();
	
	if ( $maxcv_cf7 ) {
		foreach ( $maxcv_cf7 as $cform ) {
			$maxcv_contactforms[ $cform->post_title ] = $cform->ID;
		}
	} else {
		$maxcv_contactforms[ __( 'No contact forms found', 'maxcv-toolkit' ) ] = 0;
	}
	
	vc_map( array(
		'base' => 'maxcv_contactform',
		'name' => __( 'Contact Form', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
			
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				'holder' => 'div',
			),
			
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
			
			array(
				'type' => 'dropdown',
				'heading' => __( 'Select contact form', 'maxcv-toolkit' ),
				'param_name' => 'id',
				'value' => $maxcv_contactforms,
				'save_always' => true,
				'description' => __( 'Choose previously created contact form from the drop down list.', 'maxcv-toolkit' ),
			),
				
		),
	) );
}
?>