<?php
function maxcv_clients( $atts ) {

	extract( shortcode_atts( array('sc_id' => '' ), $atts ) );

	ob_start();
	
	if( maxcv_options("opt_clients") != "" ) {
		?>
		<!-- Client Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding client-section">
			<!-- Container -->
			<div class="container">
				<div class="client-carousel">
					<?php
						foreach( maxcv_options("opt_clients") as $single_item ) {
							if($single_item["url"] != "") {
								?>
								<div class="item col-md-12 col-sm-12 col-xs-12">
									<a href="<?php echo esc_url($single_item["url"]); ?>">
										<?php echo wp_get_attachment_image( $single_item["attachment_id"], 'maxcv_110_65' ); ?>
									</a>
								</div>
								<?php
							}
							elseif($single_item["attachment_id"] != ""){
								echo wp_get_attachment_image( $single_item["attachment_id"], 'maxcv_110_65' );
							}
							else {
								// Do nothing
							}
						}
						?>
				</div>
			</div><!-- Container /- -->
			<div class="client-control">
				<a href="javascript:void(0)" class="prev"><i class="fa fa-angle-left"></i></a>
				<a href="javascript:void(0)" class="next"><i class="fa fa-angle-right"></i></a>
			</div>
		</div><!-- Client Section /- -->
		<?php
	}
	return ob_get_clean();
}
add_shortcode('maxcv_clients', 'maxcv_clients');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_clients',
		'name' => __( 'Clients', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
				'holder' => 'div',
			),
		),
	) );
}
?>