<?php
function maxcv_aboutus( $atts ) {

	extract( shortcode_atts( array( 'sc_id' => '', 'sc_title' => '', 'sc_subtitle' => '', 'sc_images' => '','f_name' => '', 'b_date' => '', 'desgination' => '', 'website' => '', 'email' => '', 'skype' => '', 'sc_imagestwo' => '', 'firsttxt' => '', 'secondtxt' => '', 'secondtxt' => '', 'thirdtxt' => '', 'fourtxt' => '', 'fivetxt' => '', 'sc_desc' => '', 'btntxt' => '', 'btnurl' => '', 'sc_layout' => 'one', ), $atts ) );
	
	ob_start();
	
	if($sc_layout == 'one') {
		?>
		<!-- About Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding about-section">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "" || $sc_subtitle !="") { 
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title !=""){ ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle !=""){ ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
					}
					if($sc_images != "" || $f_name != "" || $b_date != "" || $desgination != "" || $website != "" || $email != "" || $skype != "" ) {
						?>
						<div class="col-md-5 col-sm-5 no-padding">
							<div class="about-content">
								<?php echo wp_get_attachment_image($sc_images,"maxcv_488_591"); ?>
								<ul class="about-detail">
									<?php if($f_name != "" ) { ?><li><span><?php esc_html_e('Full Name :',"maxcv-toolkit"); ?></span> <?php echo esc_attr($f_name); ?></li><?php } ?>
									<?php if($b_date != "" ) { ?><li><span><?php esc_html_e('Birthday :',"maxcv-toolkit"); ?></span> <?php echo esc_attr($b_date); ?></li><?php } ?>
									<?php if($desgination != "" ) { ?><li><span><?php esc_html_e('Job :',"maxcv-toolkit"); ?></span> <?php echo esc_attr($desgination); ?></li><?php } ?>
									<?php if($website != "" ) { ?><li><span><?php esc_html_e('Website :',"maxcv-toolkit"); ?></span> <a href="<?php echo esc_attr($website); ?>" title="<?php echo esc_attr($website); ?>"><?php echo esc_attr($website); ?></a></li><?php } ?>
									<?php if($email != "" ) { ?><li><span><?php esc_html_e('Email :',"maxcv-toolkit"); ?></span> <a href="mailto:<?php echo esc_attr($email); ?>" title="<?php echo esc_attr($email); ?>"><?php echo esc_attr($email); ?></a></li><?php } ?>
									<?php if($skype != "" ) { ?><li><span><?php esc_html_e('Skype :',"maxcv-toolkit"); ?></span> <a href="tel:<?php echo esc_attr($skype); ?>" title="<?php echo esc_attr($skype); ?>"><?php echo esc_attr($skype); ?></a></li><?php } ?>
								</ul>
							</div>
						</div>
						<?php
					}
				?>
				<div class="col-md-7 col-sm-7 about-cv">
					<?php
						if( maxcv_options("opt_aboutus") != "" ) {
							?>
							<div class="skill-block">
								<h3><?php esc_html_e('My Skills',"maxcv-toolkit"); ?></h3>
								<div id="skill_type-1" class="horizontal-skill">
									<?php 
										$i = 1;
										foreach( maxcv_options("opt_aboutus") as $single_item ) {
											?>
											<div class="skill-progress-box">
												<h3 class="block-title"><?php echo esc_attr( $single_item["title"] ); ?> : <span><?php echo esc_attr( $single_item["textOne"] ); ?></span></h3>
												<div class="progress-box">
													<span data-skill_percent="<?php echo esc_attr($single_item["textTwo"]) ?>" id="skill_1_count-<?php echo esc_attr($i); ?>"><?php echo esc_attr($single_item["textTwo"]) ?></span>
													<div class="progress">
														<div class="progress-bar progress-bar-danger illustrator" role="progressbar" id="skill_bar_1_count-<?php echo esc_attr($i); ?>"></div>
													</div>
												</div>
											</div>
											<?php
											$i++;
										}
									?>
								</div>
							</div>
							<?php
						}
						if( maxcv_options("opt_hobbies") != "" ) {
							?>
							<div class="hobby-block">
								<h3><?php esc_html_e('Hobbies',"maxcv-toolkit"); ?></h3>
								<div class="row">
									<?php 
										foreach( maxcv_options("opt_hobbies") as $single_item ) {
											?>
											<div class="col-md-2 col-sm-4 col-xs-3">
												<?php if($single_item["textOne"] != "" ) { ?><i class="<?php echo esc_attr($single_item["textOne"] ); ?>"></i><?php } ?>
												<?php if($single_item["title"] != "" ) { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php } ?>
											</div>
											<?php
										}
									?>
								</div>
							</div>
							<?php
						}
					?>
				</div>
			</div><!-- Container /- -->
		</div><!-- About Section /- -->
		<?php 
	}
	elseif($sc_layout == 'two') {
		?>
		<!-- About Section -->
		<div <?php if($sc_id != "" ) { ?>id="<?php echo esc_attr($sc_id); ?>"<?php } ?> class="container-fluid no-padding about-section2">
			<!-- Container -->
			<div class="container">
				<?php 
					if($sc_title != "" || $sc_subtitle !="") { 
						?>
						<!-- Section Header -->
						<div class="section-header">
							<?php if($sc_title){ ?><h3><?php echo esc_attr($sc_title); ?></h3><?php } ?>
							<?php if($sc_subtitle){ ?><p><?php echo esc_attr($sc_subtitle); ?></p><?php } ?>
						</div><!-- Section Header /- -->
						<?php
						}
				?>
				<div class="col-md-5 col-sm-5 col-xs-12 no-padding">
					<?php echo wp_get_attachment_image($sc_imagestwo,"maxcv_452_648"); ?>
				</div>
				
				<div class="col-md-7 col-sm-7 col-xs-12 about-cv">
					<?php if($firsttxt != "" || $firsttxt != "" || $secondtxt != "" || $thirdtxt != "" || $fourtxt != "" | $fivetxt != "" ) { ?><h4><?php echo esc_attr($firsttxt); ?> <span><?php echo esc_attr($secondtxt); ?></span> <?php echo esc_attr($thirdtxt); ?> <span><?php echo esc_attr($fourtxt); ?></span> <?php echo esc_attr($fivetxt); ?></h4><?php } ?>
					<?php echo wpautop($sc_desc); ?>
					<?php if($btnurl != "") { ?><a href="<?php echo esc_attr($btnurl); ?>" title="<?php echo esc_attr($btntxt); ?>"><?php echo esc_attr($btntxt); ?> <i class="arrow_right"></i></a><?php } ?>
					<?php
					if( maxcv_options("opt_hobbies") != "" ) {
						?>
						<div id="skill_circuler-1" class="skill-progress">
							<?php 
								$j = 1;
								foreach( maxcv_options("opt_aboutussecond") as $single_item ) {
									?>
									<div class="col-md-4 col-sm-6 col-xs-4 skill-box">
										<div class="skill-icon">
											<input class="dial" data-angleOffset="0" data-angleArc="360" data-animation="fade-in" data-fgColor="#ffb400" data-bgcolor="#dddddd" data-delay="0" data-linecap="square" data-readonly="true" data-displayinput="false" data-thickness=".08" data-value="<?php echo esc_attr($single_item["textOne"] ); ?>" data-width="108" data-height="108" type="text" value="0"/>
											<span data-skills_percent="<?php echo esc_attr($single_item["textOne"] ); ?>" id="skill_1_count-<?php echo esc_attr($j); ?>"><?php echo esc_attr($single_item["textOne"] ); ?></span>
										</div>
										<?php if($single_item["title"] != "" ) { ?><h4><?php echo esc_attr($single_item["title"] ); ?></h4><?php } ?>
									</div>
									<?php
									$j++;
								}
							?>
						</div>
						<?php
					}
					?>
				</div> 
			</div><!-- Container /- -->
		</div><!-- About Section /- -->
		<?php
	}	
	return ob_get_clean();
}
add_shortcode('maxcv_aboutus', 'maxcv_aboutus');

if( function_exists('vc_map') ) {

	vc_map( array(
		'base' => 'maxcv_aboutus',
		'name' => __( 'About Us', "maxcv-toolkit" ),
		'class' => '',
		"category" => esc_html__("Maxcv Theme", "maxcv-toolkit"),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => __( 'Select a Layout', "maxcv-toolkit" ),
				'param_name' => 'sc_layout',
				'value' => array(
					__( 'Layout 1', "maxcv-toolkit" ) => 'one',
					__( 'Layout 2', "maxcv-toolkit" ) => 'two',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Section Id', "maxcv-toolkit" ),
				'param_name' => 'sc_id',
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title', "maxcv-toolkit" ),
				'param_name' => 'sc_title',
				"holder" => "div",
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Sub Title', "maxcv-toolkit" ),
				'param_name' => 'sc_subtitle',
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Images', "maxcv-toolkit" ),
				'param_name' => 'sc_images',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Full Name', "maxcv-toolkit" ),
				'param_name' => 'f_name',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Birthday', "maxcv-toolkit" ),
				'param_name' => 'b_date',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Designation', "maxcv-toolkit" ),
				'param_name' => 'desgination',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Website', "maxcv-toolkit" ),
				'param_name' => 'website',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Email ID', "maxcv-toolkit" ),
				'param_name' => 'email',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Skype ID', "maxcv-toolkit" ),
				'param_name' => 'skype',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'one') ),
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Images', "maxcv-toolkit" ),
				'param_name' => 'sc_imagestwo',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title First Text', "maxcv-toolkit" ),
				'param_name' => 'firsttxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Second Text', "maxcv-toolkit" ),
				'param_name' => 'secondtxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Third Text', "maxcv-toolkit" ),
				'param_name' => 'thirdtxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Four Text', "maxcv-toolkit" ),
				'param_name' => 'fourtxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Title Last Text', "maxcv-toolkit" ),
				'param_name' => 'fivetxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textarea',
				'heading' => __( 'Description', "maxcv-toolkit" ),
				'param_name' => 'sc_desc',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button Text', "maxcv-toolkit" ),
				'param_name' => 'btntxt',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Button URL', "maxcv-toolkit" ),
				'param_name' => 'btnurl',
				"dependency" => Array('element' => "sc_layout", 'value' => array( 'two') ),
			),
		),
	) );
}
?>