<?php
/**
 * Plugin Name:  Maxcv Toolkit
 * Plugin URI:   http://www.onistaweb.com/
 * Description:  An easy to use theme plugin to add custom features to WordPress Theme.
 * Version:      1.1
 * Author:       Onista Web
 * Author URI:   http://www.onistaweb.com/
 * Author Email: onistaweb@gmail.com
 *
 * @package    MAXCV_Theme_Toolkit
 * @since      1.0
 * @author     Onista Web
 * @copyright  Copyright (c) 2015-2016, Onista Web
 * @license    http://www.gnu.org/licenses/gpl-2.0.html
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class MAXCV_Theme_Toolkit {

	/**
	 * PHP5 constructor method.
	 *
	 * @since  1.0
	 */
	public function __construct() {

		// Set constant path to the plugin directory.
		add_action( 'plugins_loaded', array( &$this, 'maxcv_constants' ), 1 );

		// Internationalize the text strings used.
		add_action( 'plugins_loaded', array( &$this, 'maxcv_i18n' ), 2 );

		// Load the plugin functions files.
		add_action( 'plugins_loaded', array( &$this, 'maxcv_includes' ), 3 );

		// Loads the admin styles and scripts.
		add_action( 'admin_enqueue_scripts', array( &$this, 'maxcv_admin_scripts' ) );

		// Loads the frontend styles and scripts.
		add_action( 'wp_enqueue_scripts', array( &$this, 'maxcv_frontend_scripts' ) ); 
	}

	/**
	 * Defines constants used by the plugin.
	 *
	 * @since  1.0
	 */
	public function maxcv_constants() {

		// Set constant path to the plugin directory.
		define( 'MAXCV_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );

		// Set the constant path to the plugin directory URI.
		define( 'MAXCV_URI', trailingslashit( plugin_dir_url( __FILE__ ) ) );

		// Set the constant path to the inc directory.
		define( 'MAXCV_INC', MAXCV_DIR . trailingslashit( 'includes' ) );

		// Set the constant path to the shortcodes directory.
		define( 'MAXCV_SC', MAXCV_DIR . trailingslashit( 'shortcodes' ) );

		// Set the constant path to the assets directory.
		define( 'MAXCV_LIB', MAXCV_URI . trailingslashit( 'lib' ) );
	}

	/**
	 * Loads the translation files.
	 *
	 * @since  0.1.0
	 */
	public function maxcv_i18n() {
		load_plugin_textdomain( "maxcv-toolkit", false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Loads the initial files needed by the plugin.
	 *
	 * @since  0.1.0
	 */
	public function maxcv_includes() {

		// Load CPT, CMB, Widgets
		require_once( MAXCV_INC . 'inc.php' );
		require_once( MAXCV_SC . 'inc.php' );
	}

	/**
	 * Loads the admin styles and scripts.
	 *
	 * @since  0.1.0
	 */
	function maxcv_admin_scripts() {

		// Loads the popup custom style.
		wp_enqueue_style( 'maxcv-toolkit-admin', trailingslashit( MAXCV_LIB ) . 'css/admin.css', array(), '1.0', 'all' );
		wp_enqueue_script( 'maxcv-toolkit-admin' , trailingslashit( MAXCV_LIB ) . 'js/admin.js', array( 'jquery' ), '1.0', false );
	}

	/**
	 * Loads the frontend styles and scripts.
	 *
	 * @since  0.1.0
	 */
	function maxcv_frontend_scripts() {
		
		/* Google Map */
		$map_api = "";
		
		if( function_exists("maxcv_options") ) {
			$map_api = maxcv_options("map_api");
		}
		if( $map_api != "" ) {
			wp_enqueue_script( 'gmap-api', 'https://maps.googleapis.com/maps/api/js?key='.$map_api.'&callback=initMap', array(), null, true );
		}

		wp_enqueue_style( 'maxcv-toolkit', trailingslashit( MAXCV_LIB ) . 'css/plugin.css', array(), '1.0', 'all' );
		wp_enqueue_script( 'maxcv-toolkit' , trailingslashit( MAXCV_LIB ) . 'js/plugin.js', array( 'jquery' ), '1.0', false );
	}
}

new MAXCV_Theme_Toolkit;