(function($) {

	"use strict";

	/* - Contact Map */
	function initialize(obj) {

		var lat = $('#'+obj).attr("data-lat");
		var lng = $('#'+obj).attr("data-lng");
		var contentString = $('#'+obj).attr("data-string");
		var myLatlng = new google.maps.LatLng(lat,lng);
		var map, marker, infowindow;
		var image = $('#'+obj).attr("data-marker");
		var zoomLevel = parseInt($("#"+obj).attr("data-zoom") ,10);
		var styles = [{"featureType":"landscape","stylers":[{"saturation":-10},{"lightness":-100},{"visibility":"on"}]},{"featureType":"poi","stylers":[{"saturation":-100},{"lightness":-90},{"visibility":"simplified"}]},{"featureType":"road.highway","stylers":[{"saturation":-100},{"visibility":"off"}]},{"featureType":"road.arterial","stylers":[{"saturation":-80},{"lightness":-100},{"visibility":"on"}]},{"featureType":"road.local","stylers":[{"saturation":-80},{"lightness":-90},{"visibility":"on"}]},{"featureType":"transit","stylers":[{"saturation":-90},{"visibility":"simplified"}]},{"featureType":"administrative.province","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"labels","stylers":[{"visibility":"off"},{"lightness":-90},{"saturation":-90}]},{"featureType":"water","elementType":"geometry","stylers":[{"hue":"#ff5500"},{"lightness":-90},{"saturation":-90}]}]
		var styledMap = new google.maps.StyledMapType(styles,{name: "Styled Map"});	
		var mapOptions = {
			zoom: zoomLevel,
			disableDefaultUI: true,
			center: myLatlng,
            scrollwheel: false,
			mapTypeControlOptions: {
            mapTypeIds: [google.maps.MapTypeId.ROADMAP, "map_style"]
			}
		}
		map = new google.maps.Map(document.getElementById(obj), mapOptions);	
		map.mapTypes.set('map_style', styledMap);
		map.setMapTypeId('map_style');	
		infowindow = new google.maps.InfoWindow({
			content: contentString,
			maxWidth: 300
		});		
		marker = new google.maps.Marker({
			position: myLatlng,
			map: map,
			icon: image
		});
		google.maps.event.addListener(marker, 'click', function() {
			infowindow.open(map,marker);
		});	
	}
	
	window.initMap = function() {}	

	/* Event - Document Ready */
	$(document).on("ready",function() {

		/* - Contact Map Initialization */
		if( $('#map-canvas-contact').length==1 ) {
			initialize('map-canvas-contact');
		}
		
		/* - Counter */
		if($(".statistics-section").length) {
			$( ".statistics-section" ).each(function ()
			{
				var $this = $(this);
				var myVal = $(this).data("value");

				$this.appear(function()
				{		
					var statistics_item_count = 0;
					var statistics_count = 0;					
					statistics_item_count = $( "[id*='statistics_count-']" ).length;
					 
					for(var i=1; i<=statistics_item_count; i++)
					{
						statistics_count = $( "[id*='statistics_count-"+ i +"']" ).attr( "data-statistics_percent" );
						$("[id*='statistics_count-"+ i +"']").animateNumber({ number: statistics_count }, 4000);
					}				
				});
			});
		}
		
		/* - Testimonial Section */
		if( $(".testimonial-section").length ) {
			var totalItems = $("#testimonial-carousel .item").length;
			var currentIndex = $("#testimonial-carousel div.active").index() + 1;
			$(".num").html(""+ currentIndex +" / "+ totalItems +"");
			$("#testimonial-carousel").carousel({
				interval: 2900
			});
			$("#testimonial-carousel").on("slide.bs.carousel", function() {
				currentIndex = $("#testimonial-carousel div.active").index() + 1;
				$(".num").html(""+ currentIndex +" / "+ totalItems +"");
			});
		}
		
		/* -- Client Carousel */
		if($(".client-section").length){
			$(".client-carousel").owlCarousel({
				loop: true,    
				margin: 0,
				dots: false,
				nav:false,    
				autoplay:false,    
				autoplayHoverPause:true,
				responsive:{
					0:{
						items: 2
					},
					480:{
						items: 3
					},
					992:{
						items: 4
					},
					1200:{
						items: 5
					},
					1366:{
						items:6
					}
				}
			});
			$(".client-section .client-control .next").on("click",function(){
				$(".client-carousel").trigger('next.owl.carousel');
			})
			$(".client-section .client-control .prev").on("click",function(){
				$(".client-carousel").trigger('prev.owl.carousel');
			})
		}
		
		
		/* - Skill Section */
		$( " [id*='skill_type-'] " ).each(function ()
		{
			var ele_id = 0;
			ele_id = $(this).attr('id').split("-")[1];
			
			var $this = $(this);
			var myVal = $(this).data("value");

			$this.appear(function()
			{			
				var skill_type1_item_count = 0;
				var skill_type1_count = 0;					
				skill_type1_item_count = $( "[id*='skill_"+ ele_id +"_count-']" ).length;				
				
				for(var i=1; i<=skill_type1_item_count; i++)
				{
					skill_type1_count = $( "[id*='skill_"+ ele_id +"_count-"+i+"']" ).attr( "data-skill_percent" );
					$("[id*='skill_"+ ele_id +"_count-"+i+"']").animateNumber({ number: skill_type1_count }, 5000);
				}
				
				var skill_bar_count = 0;
				var skills_bar_count = 0;
				skill_bar_count = $( "[id*='skill_bar_"+ ele_id +"_count-']" ).length;
				
				for(var j=1; j<=skill_bar_count; j++)
				{
					skills_bar_count = $( "[id*='skill_"+ ele_id +"_count-"+j+"']" ).attr( "data-skill_percent" );
					$("[id*='skill_bar_"+ ele_id +"_count-"+j+"']").css({'width': skills_bar_count +'%'});
					$("[id*='skill_"+ ele_id +"_count-"+j+"']").css({'left': skills_bar_count +'%'});
				}
			});
		});
		
		/* - Circuler Skill  */
		$( "[id*='skill_circuler-']" ).each(function ()
		{
			var ele_id = 0;
			ele_id = $(this).attr('id').split("-")[1];
			
			var $this = $(this);
			var myVal = $(this).data("value");	

			$this.appear(function()
			{
				var skill_item_count = 0;
				var skills_count = 0;

				skill_item_count = $( "[id*='skill_"+ ele_id +"_count-']" ).length;

				for(var i=1; i<=skill_item_count; i++)
				{
					skills_count = $( "[id*='skill_"+ ele_id +"_count-"+i+"']" ).attr( "data-skills_percent" );
					$("[id*='skill_"+ ele_id +"_count-"+i+"']").animateNumber({ number: skills_count }, 2000);
				}
			});
		});
		
		
		
		$('.dial').each(function ()
		{
			var $this = $(this);
			var myVal = $(this).data("value");		

			$this.appear(function()
			{
				// alert(myVal);
				$this.knob({ });
				$({ value: 0 }).animate({ value: myVal },
				{
					duration: 2000,
					easing: 'swing',
					step: function ()
					{
						$this.val(Math.ceil(this.value)).trigger('change');
					}
				});
			});
		});
		
		
		/* - Portfolio Section */
		if($(".portfolio-section").length){
			var url;
			$(".portfolio-section .portfolio-box").magnificPopup({
				delegate: "a.zoom-in",
				type: "image",
				tLoading: "Loading image #%curr%...",
				mainClass: "mfp-img-mobile",
				gallery: {
					enabled: true,
					navigateByImgClick: false,
					preload: [0,1] // Will preload 0 - before current, and 1 after the current image
				},
				image: {
					tError: "<a href="%url%">The image #%curr%</a> could not be loaded.",				
				}
			});
		}
	});
	/* Event - Document Ready */
	
	
	/* ## Window Load - Handler for .load() called */	
	$(window).on("load",function() {
		/* - Portfolio Section */
		if($(".portfolio-fitrow").length){
			var $container = $(".portfolio-section .portfolio-fitrow");
			$container.isotope({
				layoutMode: 'fitRows',
				itemSelector: ".portfolio-box",
				gutter: 0,
				transitionDuration: "0.5s"
			});
			
			$("#filters a").on("click",function(){
				$('#filters a').removeClass("active");
				$(this).addClass("active");
				var selector = $(this).attr("data-filter");
				$container.isotope({ filter: selector });		
				return false;
			});
		}
	});

})(jQuery);