<?php
/**
 * Social Icons widget class Maxcv
 *
 * @since 2.8.0
 */
class Maxcv_Widget_Social extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_social', 'description' => esc_html( "Social Icons", "maxcv-toolkit" ) );
		
		parent::__construct('widget_social', esc_html('Maxcv :: Social Networks', "maxcv-toolkit"), $widget_ops);
		
		$this->alt_option_name = 'widget_social';
	}

	public function widget( $args, $instance ) {
		
		
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html( 'Social Networks', "maxcv-toolkit" );
		
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		echo html_entity_decode( $args['before_widget'] ); // Widget starts to print information

		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}

		$social_facebook = empty( $instance['social_facebook'] ) ? '' : $instance['social_facebook'];
		$social_twitter = empty( $instance['social_twitter'] ) ? '' : $instance['social_twitter'];
		$social_linkedin = empty( $instance['social_linkedin'] ) ? '' : $instance['social_linkedin'];
		$social_tumbler = empty( $instance['social_tumbler'] ) ? '' : $instance['social_tumbler'];
		$social_vimeo = empty( $instance['social_vimeo'] ) ? '' : $instance['social_vimeo'];
		$social_pinterest = empty( $instance['social_pinterest'] ) ? '' : $instance['social_pinterest'];
		?>
		
		<ul>
			<?php if( !empty( $social_facebook ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_facebook ); ?>"><i class="fa fa-facebook"></i></a></li><?php endif; ?>
			<?php if( !empty( $social_twitter ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_twitter ); ?>"><i class="fa fa-twitter"></i></a></li><?php endif; ?>
			<?php if( !empty( $social_linkedin ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_linkedin ); ?>"><i class="fa fa-linkedin"></i></a></li><?php endif; ?>
			<?php if( !empty( $social_tumbler ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_tumbler ); ?>"><i class="fa fa-tumblr"></i></a></li><?php endif; ?>
			<?php if( !empty( $social_vimeo ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_vimeo ); ?>"><i class="fa fa-vimeo"></i></a></li><?php endif; ?>
			<?php if( !empty( $social_pinterest ) ): ?><li><a target="_blank" href="<?php echo esc_url( $social_pinterest ); ?>"><i class="fa fa-pinterest-p"></i></a></li><?php endif; ?>
		</ul>

		<?php
		echo html_entity_decode( $args['after_widget'] );
	}

	public function form( $instance ) {

		$instance = wp_parse_args( ( array ) $instance, array( 'title' => '' ) );

		$title = $instance['title'];

		$social_facebook = empty( $instance['social_facebook'] ) ? '' : $instance['social_facebook'];
		$social_twitter = empty( $instance['social_twitter'] ) ? '' : $instance['social_twitter'];
		$social_linkedin = empty( $instance['social_linkedin'] ) ? '' : $instance['social_linkedin'];
		$social_tumbler = empty( $instance['social_tumbler'] ) ? '' : $instance['social_tumbler'];
		$social_vimeo = empty( $instance['social_vimeo'] ) ? '' : $instance['social_vimeo'];
		$social_pinterest = empty( $instance['social_pinterest'] ) ? '' : $instance['social_pinterest'];
		
		?>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('title') ); ?>" name="<?php echo esc_html( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_facebook') ); ?>"><?php esc_html_e('Facebook:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_facebook') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_facebook') ); ?>" type="text" value="<?php echo esc_url( $social_facebook ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_twitter') ); ?>"><?php esc_html_e('Twitter:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_twitter') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_twitter') ); ?>" type="text" value="<?php echo esc_url( $social_twitter ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_linkedin') ); ?>"><?php esc_html_e('Linkedin:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_linkedin') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_linkedin') ); ?>" type="text" value="<?php echo esc_url( $social_linkedin ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_tumbler') ); ?>"><?php esc_html_e('Tumbler:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_tumbler') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_tumbler') ); ?>" type="text" value="<?php echo esc_url( $social_tumbler ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_vimeo') ); ?>"><?php esc_html_e('Vimeo:', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_vimeo') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_vimeo') ); ?>" type="text" value="<?php echo esc_url( $social_vimeo ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id('social_pinterest') ); ?>"><?php esc_html_e('Pinterest', "maxcv-toolkit" ); ?> <input class="widefat" id="<?php echo esc_html( $this->get_field_id('social_pinterest') ); ?>" name="<?php echo esc_html( $this->get_field_name('social_pinterest') ); ?>" type="text" value="<?php echo esc_url( $social_pinterest ); ?>" /></label></p>

		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$new_instance = wp_parse_args( ( array ) $new_instance, array('title' => '') );

		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['social_facebook'] = ( ! empty( $new_instance['social_facebook'] ) ) ? strip_tags( $new_instance['social_facebook'] ) : '';
		$instance['social_twitter'] = ( ! empty( $new_instance['social_twitter'] ) ) ? strip_tags( $new_instance['social_twitter'] ) : '';
		$instance['social_linkedin'] = ( ! empty( $new_instance['social_linkedin'] ) ) ? strip_tags( $new_instance['social_linkedin'] ) : '';
		$instance['social_tumbler'] = ( ! empty( $new_instance['social_tumbler'] ) ) ? strip_tags( $new_instance['social_tumbler'] ) : '';
		$instance['social_vimeo'] = ( ! empty( $new_instance['social_vimeo'] ) ) ? strip_tags( $new_instance['social_vimeo'] ) : ''; 
		$instance['social_pinterest'] = ( ! empty( $new_instance['social_pinterest'] ) ) ? strip_tags( $new_instance['social_pinterest'] ) : '';
		
		return $instance;
	}
}