<?php
/**
 * IntstagramFeed widget class Maxcv
 *
 * @since 2.8.0
 */
	
class Maxcv_Widget_IntstagramFeed extends WP_Widget {
	
	public function __construct() {

		$widget_ops = array( 'classname' => 'widget_instafeed', 'description' => esc_html( "Instagram Feed", "maxcv-toolkit" ) );

		parent::__construct('widget_instafeed', esc_html('Maxcv :: Instagram Feed', "maxcv-toolkit"), $widget_ops);

		$this->alt_option_name = 'widget_instafeed';
	}
	public function widget($args, $instance) {
	
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html( 'Instagram Feed', "maxcv-toolkit" );
		
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$username = empty( $instance['username'] ) ? '' : $instance['username'];
		
		$limit = empty( $instance['number'] ) ? 9 : $instance['number'];
		
		$size = empty( $instance['size'] ) ? 'large' : $instance['size'];
		
		$target = empty( $instance['target'] ) ? '_self' : $instance['target'];
		
		$link = empty( $instance['link'] ) ? '' : $instance['link'];
		
		echo html_entity_decode( $args['before_widget'] );
		
		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}
		
		if ( $username != '' ) {
			
			$media_array = $this->scrape_instagram( $username, $limit );
			
			if ( is_wp_error( $media_array ) ) {
				
				echo html_entity_decode( $media_array->get_error_message() );
				
			} else {
				
				// filter for images only?
				if ( $images_only = apply_filters( 'wpiw_images_only', FALSE ) )
					
					$media_array = array_filter( $media_array, array( $this, 'images_only' ) );
					
				// filters for custom classes
				$ulclass = 'social-instafeeds';
				
				$liclass = 'il-item';
				
				$aclass = '';
				
				$imgclass = 'il-photo__img';
				
				?>
				<ul>
					<?php
						foreach ( $media_array as $item ) {
							?>
							<li>
								<a href="<?php echo esc_url( $item['link']); ?>">
									<img src="<?php echo esc_url( $item[$size]); ?>" alt="Instafeed">
								</a>
							</li>
							<?php
						}
					?>
				</ul>
				<?php
			}
		}
		$linkclass = apply_filters( 'wpiw_link_class', 'clear' );
		if ( $link != '' ) {
			?><p class="<?php echo esc_attr( $linkclass ); ?>"><a href="<?php echo trailingslashit( '//instagram.com/' . esc_attr( trim( $username ) ) ); ?>" rel="me" target="<?php echo esc_attr( $target ); ?>"><?php echo wp_kses_post( $link ); ?></a></p><?php
		}
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'username' => '', 'size' => 'large', 'link' => __( 'Follow Me!', 'maxcv-toolkit' ), 'number' => 6, 'target' => '_self' ) );
	
		$title = $instance['title'];
		
		$username = $instance['username'];
		
		$number = absint( $instance['number'] );
		
		$size = $instance['size'];
		
		$target = $instance['target'];
		
		$link = $instance['link'];
		?>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'maxcv-toolkit' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></label></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'username' ) ); ?>"><?php esc_html_e( 'Username', 'maxcv-toolkit' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'username' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'username' ) ); ?>" type="text" value="<?php echo esc_attr( $username ); ?>" /></label></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of photos', 'maxcv-toolkit' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" /></label></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>"><?php esc_html_e( 'Open links in', 'maxcv-toolkit' ); ?>:</label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'target' ) ); ?>" class="widefat">
				<option value="_self" <?php selected( '_self', $target ) ?>><?php esc_html_e( 'Current window (_self)', 'maxcv-toolkit' ); ?></option>
				<option value="_blank" <?php selected( '_blank', $target ) ?>><?php esc_html_e( 'New window (_blank)', 'maxcv-toolkit' ); ?></option>
			</select>
		</p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"><?php esc_html_e( 'Link text', 'maxcv-toolkit' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>" type="text" value="<?php echo esc_attr( $link ); ?>" /></label></p>
		
		<?php
	}
	public function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		$instance['title'] = strip_tags( $new_instance['title'] );
		
		$instance['username'] = trim( strip_tags( $new_instance['username'] ) );
		
		$instance['number'] = ! absint( $new_instance['number'] ) ? 6 : $new_instance['number'];
		
		$instance['size'] = ( ( $new_instance['size'] == 'thumbnail' || $new_instance['size'] == 'large' || $new_instance['size'] == 'small' || $new_instance['size'] == 'original' ) ? $new_instance['size'] : 'large' );
		
		$instance['target'] = ( ( $new_instance['target'] == '_self' || $new_instance['target'] == '_blank' ) ? $new_instance['target'] : '_self' );
		
		$instance['link'] = strip_tags( $new_instance['link'] );
		
		return $instance;
	}
	
	function scrape_instagram( $username, $slice = 6 ) {
		
		$username = strtolower( $username );
		
		$username = str_replace( '@', '', $username );
		
		if ( false === ( $instagram = get_transient( 'instagram-a4-'.sanitize_title_with_dashes( $username ) ) ) ) {
		
		$remote = wp_remote_get( 'http://instagram.com/'.trim( $username ) );

		if ( is_wp_error( $remote ) )
				return new WP_Error( 'site_down', esc_html__( '<p>Unable to communicate with Instagram.</p>', 'maxcv-toolkit' ) );
			if ( 200 != wp_remote_retrieve_response_code( $remote ) )
				return new WP_Error( 'invalid_response', esc_html__( 'Instagram did not return a 200.', 'maxcv-toolkit' ) );

			$shards = explode( 'window._sharedData = ', $remote['body'] );

			$insta_json = explode( ';</script>', $shards[1] );

			$insta_array = json_decode( $insta_json[0], TRUE );

			if ( ! $insta_array )
				return new WP_Error( 'bad_json', esc_html__( 'Instagram has returned invalid data.', 'maxcv-toolkit' ) );
		
			if ( isset( $insta_array['entry_data']['ProfilePage'][0]['user']['media']['nodes'] ) ) {
				$images = $insta_array['entry_data']['ProfilePage'][0]['user']['media']['nodes'];
			} else {
				return new WP_Error( 'bad_json_2', esc_html__( 'Instagram has returned invalid data.', 'maxcv-toolkit' ) );
			}
		
			if ( ! is_array( $images ) )
				return new WP_Error( 'bad_array', esc_html__( 'Instagram has returned invalid data.', 'maxcv-toolkit' ) );
			$instagram = array();
			
			foreach ( $images as $image ) {
				$image['thumbnail_src'] = preg_replace( '/^https?\:/i', '', $image['thumbnail_src'] );
				$image['display_src'] = preg_replace( '/^https?\:/i', '', $image['display_src'] );
				// handle both types of CDN url
				if ( (strpos( $image['thumbnail_src'], 's65x65' ) !== false ) ) {
					$image['thumbnail'] = str_replace( 's65x65', 's65x65', $image['thumbnail_src'] );
					$image['small'] = str_replace( 's65x65', 's65x65', $image['thumbnail_src'] );
				} else {
					$urlparts = wp_parse_url( $image['thumbnail_src'] );
					$pathparts = explode( '/', $urlparts['path'] );
					array_splice( $pathparts, 3, 0, array( 's65x65' ) );
					$image['thumbnail'] = '//' . $urlparts['host'] . implode('/', $pathparts);
					$pathparts[3] = 's65x65';
					$image['small'] = '//' . $urlparts['host'] . implode('/', $pathparts);
				}
				$image['large'] = $image['thumbnail_src'];
				if ( $image['is_video'] == true ) {
					$type = 'video';
				} else {
					$type = 'image';
				}
				$caption = __( 'Instagram Image', 'maxcv-toolkit' );
				if ( ! empty( $image['caption'] ) ) {
					$caption = $image['caption'];
				}
				$instagram[] = array(
					'description'   => $caption,
					'link'		  	=> trailingslashit( '//instagram.com/p/' . $image['code'] ),
					'time'		  	=> $image['date'],
					'comments'	  	=> $image['comments']['count'],
					'likes'		 	=> $image['likes']['count'],
					'thumbnail'	 	=> $image['thumbnail'],
					'small'			=> $image['small'],
					'large'			=> $image['large'],
					'original'		=> $image['display_src'],
					'type'		  	=> $type
				);
			}
			// do not set an empty transient - should help catch private or empty accounts
			if ( ! empty( $instagram ) ) {
				$instagram = base64_encode( serialize( $instagram ) );
				set_transient( 'instagram-a4-'.sanitize_title_with_dashes( $username ), $instagram, apply_filters( 'null_instagram_cache_time', HOUR_IN_SECONDS*2 ) );
			}
		}
		if ( ! empty( $instagram ) ) {
			$instagram = unserialize( base64_decode( $instagram ) );
			return array_slice( $instagram, 0, $slice );
		} else {
			return new WP_Error( 'no_images', esc_html__( 'Instagram did not return any images.', 'maxcv-toolkit' ) );
		}
	}
	function images_only( $media_item ) {
		if ( $media_item['type'] == 'image' )
			return true;
		return false;
	}
}