<?php
/**
 * Contact widget class Maxcv
 *
 * @since 2.8.0
 */
class Maxcv_Widget_Contact extends WP_Widget {

	public function __construct() {

		$widget_ops = array( 'classname' => 'ftr-widget ftr_widget_contact', 'description' => esc_html( "Contact us", "maxcv-toolkit" ) );

		parent::__construct('ftr_widget_contact', esc_html('Maxcv :: Contact us', "maxcv-toolkit"), $widget_ops);

		$this->alt_option_name = 'ftr_widget_contact';
	}

	public function widget($args, $instance) {

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		/** This filter is documented in wp-includes/default-widgets.php */

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html( 'Contact us', "maxcv-toolkit" );

		$address = ( ! empty( $instance['address'] ) ) ? esc_html( $instance['address'] ) : "";
		$phoneone = ( ! empty( $instance['phoneone'] ) ) ? esc_html( $instance['phoneone'] ) : "";
		$phonetwo = ( ! empty( $instance['phonetwo'] ) ) ? esc_html( $instance['phonetwo'] ) : "";
		$email = ( ! empty( $instance['email'] ) ) ? esc_html( $instance['email'] ) : "";
		
		echo html_entity_decode( $args['before_widget'] );

		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}
		
		?>            
			
		<?php if($address != "") { ?><p><i class="fa fa-home"></i> <?php echo esc_attr($address); ?> </p><?php } ?>
		<?php if($phoneone != "") { ?><p><i class="fa fa-phone"></i> <a href="tel:<?php echo esc_attr(str_replace(" ", "", $phoneone) ); ?>" title="<?php echo esc_attr($phoneone); ?>"><?php echo esc_attr($phoneone); ?></a></p><?php } ?>
		<?php if($phonetwo != "") { ?><p><i class="fa fa-fax"></i> <a href="tel:<?php echo esc_attr(str_replace(" ", "", $phonetwo) ); ?>" title="<?php echo esc_attr($phonetwo); ?>"><?php echo esc_attr($phonetwo); ?></a></p><?php } ?>
		<?php if($email != "") { ?><p><i class="fa fa-envelope"></i> <a href="mailto:<?php echo esc_attr($email); ?>" title="<?php echo esc_attr($email); ?>"><?php echo esc_attr($email); ?></a></p><?php } ?>
		<?php
		
		echo html_entity_decode( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		$instance['title'] = strip_tags( $new_instance['title'] );
		
		$instance['address'] = strip_tags( $new_instance['address'] );
		$instance['phoneone'] = strip_tags( $new_instance['phoneone'] );
		$instance['phonetwo'] = strip_tags( $new_instance['phonetwo'] );
		$instance['email'] = strip_tags( $new_instance['email'] );
		
		return $instance;
	}

	public function form( $instance ) {

		$title	=	isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : "";

		$address	=	isset( $instance['address'] ) ? esc_html( $instance['address'] ) : "";
		$phoneone	=	isset( $instance['phoneone'] ) ? esc_html( $instance['phoneone'] ) : "";
		$phonetwo	=	isset( $instance['phonetwo'] ) ? esc_html( $instance['phonetwo'] ) : "";
		$email	=	isset( $instance['email'] ) ? esc_html( $instance['email'] ) : "";
	
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', "maxcv-toolkit" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php esc_html_e( 'Address :', "maxcv-toolkit" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>" type="text" value="<?php echo esc_attr( $address ); ?>" />
		</p>
		
		
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'phoneone' ) ); ?>"><?php esc_html_e( 'Contact No 1 :', "maxcv-toolkit" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phoneone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phoneone' ) ); ?>" type="text" value="<?php echo esc_attr( $phoneone ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'phonetwo' ) ); ?>"><?php esc_html_e( 'Contact No 2 :', "maxcv-toolkit" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phonetwo' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phonetwo' ) ); ?>" type="text" value="<?php echo esc_attr( $phonetwo ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php esc_html_e( 'Email Address :', "maxcv-toolkit" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
		</p>
		
		<?php
	}
}
?>