<?php
/* CPT : Portfolio */
if ( ! function_exists('maxcv_cpt_portfolio') ) {

	add_action( 'init', 'maxcv_cpt_portfolio', 0 );

	function maxcv_cpt_portfolio() {

		$labels = array(
			'name' =>  __('Portfolio', "maxcv-toolkit" ),
			'singular_name' => __('Portfolio', "maxcv-toolkit" ),
			'add_new' => __('Add New', "maxcv-toolkit" ),
			'add_new_item' => __('Add New Portfolio', "maxcv-toolkit" ),
			'edit_item' => __('Edit Portfolio', "maxcv-toolkit" ),
			'new_item' => __('New Portfolio', "maxcv-toolkit" ),
			'all_items' => __('All Portfolio', "maxcv-toolkit" ),
			'view_item' => __('View Portfolio', "maxcv-toolkit" ),
			'search_items' => __('Search Portfolio', "maxcv-toolkit" ),
			'not_found' =>  __('No Portfolio found', "maxcv-toolkit" ),
			'not_found_in_trash' => __('No Portfolio found in Trash', "maxcv-toolkit" ),
			'parent_item_colon' => '',
			'menu_name' => __('Portfolio', "maxcv-toolkit")
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'publicly_queryable' => false,
			'show_ui' => true, 
			'show_in_menu' => true, 
			'query_var' => true,
			'supports' => array( 'title','thumbnail' ),
			'rewrite'  => array( 'slug' => 'portfolio-item' ),
			'has_archive' => false, 
			'capability_type' => 'post', 
			'hierarchical' => false,
			'menu_position' => 106,
			'menu_icon' => 'dashicons-images-alt2',
		);
		register_post_type( 'maxcv_portfolio', $args );
	}
}

// Register Custom Taxonomy
add_action( 'init', 'maxcv_tax_portfolio', 1 );
function maxcv_tax_portfolio() {

	$labels = array(
		'name'                       => _x( 'Portfolio Categories', 'Taxonomy General Name', 'maxcv-toolkit' ),
		'singular_name'              => _x( 'Portfolio Categories', 'Taxonomy Singular Name', 'maxcv-toolkit' ),
		'menu_name'                  => esc_html( 'Portfolio Category', 'maxcv-toolkit' ),
		'all_items'                  => esc_html( 'All Items', 'maxcv-toolkit' ),
		'parent_item'                => esc_html( 'Parent Item', 'maxcv-toolkit' ),
		'parent_item_colon'          => esc_html( 'Parent Item:', 'maxcv-toolkit' ),
		'new_item_name'              => esc_html( 'New Item Name', 'maxcv-toolkit' ),
		'add_new_item'               => esc_html( 'Add New Item', 'maxcv-toolkit' ),
		'edit_item'                  => esc_html( 'Edit Item', 'maxcv-toolkit' ),
		'update_item'                => esc_html( 'Update Item', 'maxcv-toolkit' ),
		'view_item'                  => esc_html( 'View Item', 'maxcv-toolkit' ),
		'separate_items_with_commas' => esc_html( 'Separate items with commas', 'maxcv-toolkit' ),
		'add_or_remove_items'        => esc_html( 'Add or remove items', 'maxcv-toolkit' ),
		'choose_from_most_used'      => esc_html( 'Choose from the most used', 'maxcv-toolkit' ),
		'popular_items'              => esc_html( 'Popular Items', 'maxcv-toolkit' ),
		'search_items'               => esc_html( 'Search Items', 'maxcv-toolkit' ),
		'not_found'                  => esc_html( 'Not Found', 'maxcv-toolkit' ),
		'items_list'                 => esc_html( 'Items list', 'maxcv-toolkit' ),
		'items_list_navigation'      => esc_html( 'Items list navigation', 'maxcv-toolkit' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
	);
	register_taxonomy( 'maxcv_portfolio_tax', array( 'maxcv_portfolio' ), $args );
}
?>