<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Metaboxes
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

if( ! function_exists("maxcv_get_sidebars") ) {

	function maxcv_get_sidebars() {

		global $wp_registered_sidebars;

		$sidebar_options = array();

		foreach ( $wp_registered_sidebars as $sidebar ) {
			$sidebar_options[$sidebar['id']] = $sidebar['name'];
		}
		return $sidebar_options;
	}
}

add_action( 'cmb2_init', 'register_maxcv_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_init' hook.
 */
function register_maxcv_metabox() {
	
		$footersidebar = array(
		"none" => "Select Footer Sidebar",
		"sidebar-5" => "Footer Sidebar 1",
		"sidebar-6" => "Footer Sidebar 2",
		"sidebar-7" => "Footer Sidebar 3",
		"sidebar-8" => "Footer Sidebar 4",
		"sidebar-9" => "Footer Sidebar 5",
		"sidebar-10" => "Footer Sidebar 6",
		"sidebar-11" => "Footer Sidebar 7"
	);
	

	// Start with an underscore to hide fields from custom fields list
	$prefix = 'maxcv_cf_';

	/* ## Page/Post Options ---------------------- */

	/* - Page Description */
	$cmb_page = new_cmb2_box( array(
		'id'            => $prefix . 'metabox_page',
		'title'         => __( 'Page Options', "maxcv-toolkit" ),
		'object_types'  => array( 'page', 'post','product' ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
	) );

	$cmb_page->add_field( array(
		'name'             => 'Content Area Padding',
		'desc'             => 'If your content section need to have just after header area without space, please select an option Off',
		'id'               => $prefix . 'content_padding',
		'type'             => 'select',
		'default'          => 'on',
		'options'          => array(
			'on' => __( 'On', "maxcv-toolkit" ),
			'off'   => __( 'Off', "maxcv-toolkit" ),
		),
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Header Background Color',
		'id'               => $prefix . 'header_bg',
		'type'             => 'select',
		'default'          => 'off',
		'options'          => array(
			'on' => __( 'On', "maxcv-toolkit" ),
			'off'   => __( 'Off', "maxcv-toolkit" ),
		),
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Page Layout',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'page_owlayout',
		'type'             => 'radio',
		'default'          => 'fixed',
		'options'          => array(
			//'default' =>  '<img title="Default" src="'. MAXCV_LIB .'/images/none.png" />',
			'fixed' =>  '<img title="Fixed" src="'. MAXCV_LIB .'/images/boxed.png" />',
			'fluid' =>  '<img title="Fluid" src="'. MAXCV_LIB .'/images/full.png" />'
		),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Sidebar Position',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'sidebar_owlayout',
		'type'             => 'radio',
		'default'          => 'right_sidebar',
		'options'          => array(
			//'default' =>  '<img src="'. MAXCV_LIB .'/images/none.png" />',
			'right_sidebar' =>  '<img src="'. MAXCV_LIB .'/images/right_side.png" />',
			'left_sidebar' =>  '<img src="'. MAXCV_LIB .'/images/left_side.png" />',
			'no_sidebar' =>  '<img src="'. MAXCV_LIB .'/images/no_side.png" />',
		),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Widget Area',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'widget_area',
		'type'             => 'select',
		'default'          => 'sidebar-1',
		'options'          => maxcv_get_sidebars(),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Page Header',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'page_title',
		'type'             => 'select',
		'default'          => 'enable',
		'options'          => array(
			'enable' => __( 'Enable', "maxcv-toolkit" ),
			'disable'   => __( 'Disable', "maxcv-toolkit" ),
		),
	) );

	$cmb_page->add_field( array(
		'name' => __( 'Header Image', "maxcv-toolkit" ),
		'desc' => __( 'Upload an image or enter a URL.', "maxcv-toolkit" ),
		'id'   => $prefix . 'page_header_img',
		'type' => 'file',
	) );

	$cmb_page->add_field( array(
		'name' => __( 'Sub Title', "maxcv-toolkit" ),
		'id'   => $prefix . 'page_subtitle',
		'type' => 'text',
	) );

	$cmb_page->add_field( array(
		'name' => __( 'Sub Title', "maxcv-toolkit" ),
		'id'   => $prefix . 'page_subtitle',
		'type' => 'text',
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Footer Layout',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'footer_layout',
		'type'             => 'select',
		'options'          => array(
			'' => __( 'Select Footer Type', "maxcv-toolkit" ),
			'1' => __( 'Layout 1', "maxcv-toolkit" ),
			'2'   => __( 'Layout 2', "maxcv-toolkit" ),
		),
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Footer Widget Area 1',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'footer_widget_area1',
		'type'             => 'select',
		'options'          => $footersidebar,
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Footer Widget Area 2',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'footer_widget_area2',
		'type'             => 'select',
		'options'          => $footersidebar,
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Footer Widget Area 3',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'footer_widget_area3',
		'type'             => 'select',
		'options'          => $footersidebar,   
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Footer Widget Area 4',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'footer_widget_area4',
		'type'             => 'select',
		'options'          => $footersidebar,   
	) );

	$prefix_cmb = "cmb_";

	/* ## Post Options ---------------------- */
	require_once( $prefix_cmb . "post.php");

	/* ## Portfolio Options ---------------------- */
	require_once( $prefix_cmb . "portfolio.php");
}
?>