<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Maxcv
 * @since Maxcv 1.0
 */
 
$css = "";
if( ! has_post_thumbnail() ) {
	$css = "no-post-thumbnail ";
}

// Get post format
$post_format = get_post_format();

$scss = "";
if(is_single() ) {
	$scss = 'post-full-content';
}
$page_css = $css.$scss;

?>
<article id="post-<?php the_ID(); ?>" <?php post_class($page_css); ?>>

	<div class="entry-cover">

		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?> <span class="sticky-post"><?php esc_html_e( 'Featured', "maxcv" ); ?></span> <?php endif; ?>

		<?php get_template_part("template-parts/format","gallery"); ?>

		<?php get_template_part("template-parts/format","video"); ?>

		<?php get_template_part("template-parts/format","audio"); ?>

		<?php
		if( has_post_thumbnail() && ( get_post_format() != "audio" && get_post_format() != "video" && get_post_format() != "gallery" ) ) {

			if( is_single() ) {
				the_post_thumbnail();
			}
			else {
				?>
				<a href="<?php the_permalink(); ?>" class="post-thumbnail">
					<?php the_post_thumbnail("full"); ?>
				</a>
				<?php
			}
		} 
		?>
	</div>
	<div class="entry-header">
		<?php
			if (!is_single() ) :				
				the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			endif;
		?>
		<div class="entry-meta">
			<div class="byline">
				<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php the_author() ?>">
					<i class="icon icon-User"></i> <?php esc_html_e('By ',"maxcv"); ?><?php the_author() ?>
				</a>
			</div>
			<div class="post-comment">
				<a href="<?php comments_link(); ?>" title="Comments">
					<i class="fa fa-comment-o"></i>
					<?php 
						comments_number( __( '0 Comments', "maxcv" ), 
						__( '1 Comment', "maxcv" ),
						__( '% Comments', "maxcv" )); 
					?>
				</a>
			</div>
			<div class="post-likes">
				<?php if( function_exists('maxcv_get_simple_likes_button') ) { echo maxcv_get_simple_likes_button( get_the_ID() ); } ?>
			</div>
			<div class="post-date">
				<?php 
					if(is_single() ) {
						?>
						<b><?php echo get_the_date( 'd', get_the_ID() );?></b> <b><?php echo get_the_date( 'M', get_the_ID() );?></b><?php echo get_the_date( 'Y', get_the_ID() );?>
						<?php
					}
					else {
						?>
						<a href="<?php the_permalink(); ?>"><b><?php echo get_the_date( 'd', get_the_ID() );?></b> <b><?php echo get_the_date( 'M', get_the_ID() );?></b> <?php echo get_the_date( 'Y', get_the_ID() );?></a>
						<?php
					}
				?>
			</div>
		</div>
	</div>
	<div class="entry-content">
		<?php
		if( is_single() ) {
			/* translators: %s: Name of current post */
			the_content( sprintf(
				esc_html__( 'Continue reading %s', "maxcv" ),
				the_title( '<span class="screen-reader-text">', '</span>', false )
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', "maxcv" ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', "maxcv" ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
			if( has_tag() ) {
				?>
				<div class="tags">
					<?php echo get_the_tag_list(' '); ?>
				</div>
				<?php
			}
		}
		else {
			?>
			<?php echo wpautop( wp_html_excerpt( strip_shortcodes( get_the_content() ), 500, ' [...]' ) ); ?>
			<a href="<?php the_permalink(); ?>" title="Read More"><?php esc_html_e('Read More',"maxcv"); ?></a>
			<?php
		}
		?>
		<ul class="social">
			<li><a href="javascript: void(0)" data-action="twitter" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>" title="Twitter"><i class="fa fa-twitter"></i></a></li>
			<li><a href="javascript: void(0)" data-action="tumblr" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>" title="Tumblr"><i class="fa fa-tumblr"></i></a></li>
			<li><a href="javascript: void(0)" data-action="vimeo" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>" title="Vimeo"><i class="fa fa-vimeo"></i></a></li>
			<li><a href="javascript: void(0)" data-action="pinterest" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>" title="Pinterest"><i class="fa fa-pinterest-p"></i></a></li>
		</ul>
	</div>
</article>